/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.media.MediaPlayer;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.millennialmedia.android.AdCache;
import com.millennialmedia.android.BridgeMMMedia;
import com.millennialmedia.android.HandShake;
import com.millennialmedia.android.MMJSObject;
import com.millennialmedia.android.MMJSResponse;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.MMWebView;
import com.millennialmedia.android.NVASpeechKit;
import com.millennialmedia.android.Utils;
import java.util.HashMap;

public class BridgeMMSpeechkit
extends MMJSObject
implements MediaPlayer.OnCompletionListener,
BridgeMMMedia.Audio.PeriodicListener {
    BridgeMMSpeechkit() {
    }

    private NVASpeechKit getCreateSpeechKit() {
        MMWebView mMWebView = (MMWebView)((Object)this.mmWebViewRef.get());
        NVASpeechKit nVASpeechKit = null;
        if (mMWebView != null) {
            boolean bl2 = mMWebView.allowSpeechCreationCommands();
            nVASpeechKit = null;
            if (bl2) {
                if (BridgeMMSpeechkit.getSpeechKitInternal() != null) {
                    return BridgeMMSpeechkit.getSpeechKitInternal();
                }
                Context context = mMWebView.getContext();
                nVASpeechKit = null;
                if (context != null) {
                    nVASpeechKit = new NVASpeechKit(mMWebView);
                    BridgeMMSpeechkit.setSpeechKit(nVASpeechKit);
                    HandShake.NuanceCredentials nuanceCredentials = HandShake.sharedHandShake((Context)context).nuanceCredentials;
                    if (nuanceCredentials != null) {
                        nVASpeechKit.initialize(nuanceCredentials, context.getApplicationContext());
                    }
                }
            }
        }
        return nVASpeechKit;
    }

    static SpeechKitHolder getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private NVASpeechKit getSpeechKit() {
        MMWebView mMWebView = (MMWebView)((Object)this.mmWebViewRef.get());
        if (mMWebView != null && mMWebView.allowRecordingCommands()) {
            return BridgeMMSpeechkit.getSpeechKitInternal();
        }
        return null;
    }

    static NVASpeechKit getSpeechKitInternal() {
        return BridgeMMSpeechkit.getInstance().getSpeechKit();
    }

    private NVASpeechKit getSpeechKitRelease() {
        return BridgeMMSpeechkit.getSpeechKitInternal();
    }

    static boolean releaseSpeechKit() {
        return BridgeMMSpeechkit.getInstance().release();
    }

    static void setSpeechKit(NVASpeechKit nVASpeechKit) {
        BridgeMMSpeechkit.getInstance().release();
        BridgeMMSpeechkit.getInstance().setSpeechKit(nVASpeechKit);
    }

    public MMJSResponse addCustomVoiceWords(HashMap<String, String> hashMap) {
        NVASpeechKit nVASpeechKit = this.getCreateSpeechKit();
        if (nVASpeechKit == null) {
            return MMJSResponse.responseWithError("Unable to create speech kit");
        }
        String string2 = hashMap.get("words");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            String[] stringArray = string2.split(",");
            nVASpeechKit.updateCustomWords(NVASpeechKit.CustomWordsOp.Add, stringArray);
            this.injectJavascript("javascript:MMJS.sdk.customVoiceWordsAdded()");
            return MMJSResponse.responseWithSuccess("Added " + string2);
        }
        return null;
    }

    public MMJSResponse cacheAudio(HashMap<String, String> hashMap) {
        Context context;
        String string2 = hashMap.get("url");
        if (!URLUtil.isValidUrl((String)string2)) {
            return MMJSResponse.responseWithError("Invalid url");
        }
        if (this.contextRef != null && (context = (Context)this.contextRef.get()) != null && AdCache.downloadComponentToCache(string2, string2.substring(1 + string2.lastIndexOf("/")), context)) {
            this.injectJavascript("javascript:MMJS.sdk.audioCached()");
            return MMJSResponse.responseWithSuccess("Successfully cached audio at " + string2);
        }
        return MMJSResponse.responseWithError("Failed to cache audio at" + string2);
    }

    public MMJSResponse deleteCustomVoiceWords(HashMap<String, String> hashMap) {
        NVASpeechKit nVASpeechKit = this.getCreateSpeechKit();
        if (nVASpeechKit == null) {
            return MMJSResponse.responseWithError("Unable to create speech kit");
        }
        String string2 = hashMap.get("words");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            String[] stringArray = string2.split(",");
            nVASpeechKit.updateCustomWords(NVASpeechKit.CustomWordsOp.Remove, stringArray);
            this.injectJavascript("javascript:MMJS.sdk.customVoiceWordsDeleted()");
            return MMJSResponse.responseWithSuccess("Deleted " + string2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MMJSResponse endRecording(HashMap<String, String> hashMap) {
        NVASpeechKit nVASpeechKit = this.getSpeechKit();
        if (nVASpeechKit == null) {
            return MMJSResponse.responseWithError("Unable to get speech kit");
        }
        synchronized (nVASpeechKit) {
            if (!nVASpeechKit.endRecording()) return MMJSResponse.responseWithError("Failed in speechKit");
            return MMJSResponse.responseWithSuccess();
        }
    }

    public MMJSResponse getSessionId(HashMap<String, String> hashMap) {
        NVASpeechKit nVASpeechKit = this.getSpeechKit();
        if (nVASpeechKit == null) {
            return MMJSResponse.responseWithError("No SpeechKit session open.");
        }
        String string2 = nVASpeechKit.getSessionId();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return MMJSResponse.responseWithSuccess(string2);
        }
        return MMJSResponse.responseWithError("No SpeechKit session open.");
    }

    void injectJavascript(String string2) {
        MMWebView mMWebView = (MMWebView)((Object)this.mmWebViewRef.get());
        if (mMWebView != null) {
            mMWebView.loadUrl(string2);
        }
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        BridgeMMMedia.Audio audio;
        this.injectJavascript("javascript:MMJS.sdk.audioCompleted()");
        Context context = (Context)this.contextRef.get();
        if (context != null && (audio = BridgeMMMedia.Audio.sharedAudio(context)) != null) {
            audio.removeCompletionListener(this);
            audio.removePeriodicListener(this);
        }
    }

    @Override
    public void onUpdate(int n2) {
        this.injectJavascript("javascript:MMJS.sdk.audioPositionChange(" + n2 + ")");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MMJSResponse playAudio(HashMap<String, String> hashMap) {
        if (this.getCreateSpeechKit() == null) {
            return MMJSResponse.responseWithError("Unable to create speech kit");
        }
        if (!URLUtil.isValidUrl((String)hashMap.get("url"))) {
            return MMJSResponse.responseWithError("Invalid url");
        }
        BridgeMMMedia bridgeMMMedia = new BridgeMMMedia();
        if (this.contextRef == null) return null;
        bridgeMMMedia.setContext((Context)this.contextRef.get());
        String string2 = hashMap.get("url");
        if (TextUtils.isEmpty((CharSequence)string2)) return null;
        Context context = (Context)this.contextRef.get();
        if (context == null) return null;
        BridgeMMMedia.Audio audio = BridgeMMMedia.Audio.sharedAudio(context);
        if (audio != null) {
            audio.addCompletionListener(this);
            audio.addPeriodicListener(this);
        }
        hashMap.put("path", string2);
        MMJSResponse mMJSResponse = bridgeMMMedia.playAudio(hashMap);
        if (mMJSResponse == null) return mMJSResponse;
        if (mMJSResponse.result != 1) return mMJSResponse;
        this.injectJavascript("javascript:MMJS.sdk.audioStarted()");
        return mMJSResponse;
    }

    public MMJSResponse releaseVoice(HashMap<String, String> hashMap) {
        if (BridgeMMSpeechkit.releaseSpeechKit()) {
            return MMJSResponse.responseWithError("Unable to get speech kit");
        }
        return MMJSResponse.responseWithSuccess("released speechkit");
    }

    public MMJSResponse sampleBackgroundAudioLevel(HashMap<String, String> hashMap) {
        NVASpeechKit nVASpeechKit = this.getCreateSpeechKit();
        if (nVASpeechKit == null) {
            return MMJSResponse.responseWithError("Unable to create speech kit");
        }
        nVASpeechKit.startSampleRecording();
        return null;
    }

    public MMJSResponse startRecording(HashMap<String, String> hashMap) {
        NVASpeechKit nVASpeechKit = this.getCreateSpeechKit();
        if (nVASpeechKit == null) {
            return MMJSResponse.responseWithError("Unable to create speech kit");
        }
        String string2 = hashMap.get("language");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "en_GB";
        }
        if (nVASpeechKit.startRecording(string2)) {
            return MMJSResponse.responseWithSuccess();
        }
        return MMJSResponse.responseWithError("Failed in speechKit");
    }

    public MMJSResponse stopAudio(HashMap<String, String> hashMap) {
        NVASpeechKit nVASpeechKit = this.getSpeechKit();
        if (nVASpeechKit == null) {
            return MMJSResponse.responseWithError("Unable to get speech kit");
        }
        nVASpeechKit.stopActions();
        BridgeMMMedia bridgeMMMedia = new BridgeMMMedia();
        if (this.contextRef != null) {
            bridgeMMMedia.setContext((Context)this.contextRef.get());
            return bridgeMMMedia.stopAudio(hashMap);
        }
        return MMJSResponse.responseWithSuccess();
    }

    public MMJSResponse textToSpeech(HashMap<String, String> hashMap) {
        MMSDK.Log.d("@@-Calling textToSpeech");
        NVASpeechKit nVASpeechKit = this.getCreateSpeechKit();
        if (nVASpeechKit == null) {
            return MMJSResponse.responseWithError("Unable to create speech kit");
        }
        String string2 = hashMap.get("language");
        String string3 = hashMap.get("text");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "en_GB";
        }
        nVASpeechKit.stopActions();
        if (nVASpeechKit.textToSpeech(string3, string2)) {
            return MMJSResponse.responseWithSuccess();
        }
        return MMJSResponse.responseWithError("Failed in speechKit");
    }

    private static class SingletonHolder {
        public static final SpeechKitHolder INSTANCE = new SpeechKitHolder();

        private SingletonHolder() {
        }
    }

    private static class SpeechKitHolder {
        private NVASpeechKit _speechKit;

        private SpeechKitHolder() {
        }

        static /* synthetic */ NVASpeechKit access$002(SpeechKitHolder speechKitHolder, NVASpeechKit nVASpeechKit) {
            speechKitHolder._speechKit = nVASpeechKit;
            return nVASpeechKit;
        }

        public NVASpeechKit getSpeechKit() {
            return this._speechKit;
        }

        public boolean release() {
            if (this._speechKit == null) {
                return false;
            }
            Utils.ThreadUtils.execute(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    SpeechKitHolder speechKitHolder = SpeechKitHolder.this;
                    synchronized (speechKitHolder) {
                        if (SpeechKitHolder.this._speechKit != null) {
                            SpeechKitHolder.this._speechKit.cancelRecording();
                            SpeechKitHolder.this._speechKit.release();
                            SpeechKitHolder.access$002(SpeechKitHolder.this, null);
                        }
                        return;
                    }
                }
            });
            return true;
        }

        public void setSpeechKit(NVASpeechKit nVASpeechKit) {
            this._speechKit = nVASpeechKit;
        }
    }
}

