/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.media.MediaRecorder;
import android.text.TextUtils;
import com.millennialmedia.android.AdCache;
import com.millennialmedia.android.MMJSObject;
import com.millennialmedia.android.MMJSResponse;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.MMWebView;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class BridgeMMMicrophone
extends MMJSObject {
    BridgeMMMicrophone() {
    }

    private void delayedEnd(String string2) {
        try {
            int n2 = 1000 * Integer.parseInt(string2);
            MMSDK.runOnUiThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    BridgeMMMicrophone.this.stopRecording(null);
                }
            }, n2);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    private Recorder initRecorder() {
        WeakReference weakReference = this.mmWebViewRef;
        Recorder recorder = null;
        if (weakReference != null) {
            MMWebView mMWebView = (MMWebView)((Object)this.mmWebViewRef.get());
            recorder = null;
            if (mMWebView != null) {
                boolean bl2 = mMWebView.allowMicrophoneCreationCommands();
                recorder = null;
                if (bl2) {
                    recorder = Recorder.getInstance();
                    recorder.addCallBack(mMWebView);
                }
            }
        }
        return recorder;
    }

    public MMJSResponse isRecordingAllowed(HashMap<String, String> hashMap) {
        WeakReference weakReference = this.contextRef;
        Context context = null;
        if (weakReference != null) {
            context = (Context)this.contextRef.get();
        }
        if (MMSDK.hasVoiceAbility(context).equals("true")) {
            return MMJSResponse.responseWithSuccess("Has Microphone / Ready to use");
        }
        return MMJSResponse.responseWithError("No voice ability");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MMJSResponse startRecording(HashMap<String, String> hashMap) {
        File file;
        File file2;
        Recorder recorder = this.initRecorder();
        if (recorder == null) {
            return MMJSResponse.responseWithError("Unable to create Microphone Recorder");
        }
        String string2 = hashMap.get("path");
        if (!TextUtils.isEmpty((CharSequence)string2) && this.contextRef != null && (file2 = AdCache.getCacheDirectory((Context)this.contextRef.get())) != null && (file = new File(file2, string2)) != null) {
            string2 = file.getPath();
        }
        if (!TextUtils.isEmpty((CharSequence)hashMap.get("duration"))) {
            this.delayedEnd("9");
        }
        String string3 = hashMap.get("callbackRate");
        int n2 = 100;
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            float f2;
            try {
                f2 = Float.parseFloat(string3);
            }
            catch (Exception exception) {}
            n2 = (int)(f2 * 1000.0f);
        }
        recorder.startRecording(string2, n2);
        return MMJSResponse.responseWithSuccess("recording");
    }

    public MMJSResponse stopRecording(HashMap<String, String> hashMap) {
        Recorder recorder = this.initRecorder();
        if (recorder == null) {
            return MMJSResponse.responseWithError("Unable to create Microphone Recorder");
        }
        recorder.stopRecording();
        return MMJSResponse.responseWithSuccess("stopped recording");
    }

    static class Recorder {
        State _state = State.READY;
        AudioRunnable audioRunnable;
        private MediaRecorder mRecorder = null;
        private WeakReference<MMWebView> webViewRef;

        private Recorder() {
        }

        private double getAudioLevel() {
            if (this.mRecorder != null) {
                return (double)(9 * this.mRecorder.getMaxAmplitude()) / 32767.0;
            }
            return 0.0;
        }

        public static Recorder getInstance() {
            return SingletonHolder.INSTANCE;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void startRecording(String string2, int n2) {
            synchronized (this) {
                MMWebView mMWebView;
                if (this.mRecorder == null) {
                    this.mRecorder = new MediaRecorder();
                }
                this.stopRecording();
                this.mRecorder.setAudioSource(1);
                this.mRecorder.setOutputFormat(1);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    this.mRecorder.setOutputFile(string2);
                }
                this.mRecorder.setAudioEncoder(1);
                try {
                    this.mRecorder.prepare();
                }
                catch (IOException iOException) {
                    MMSDK.Log.e("prepare() failed");
                }
                this.mRecorder.start();
                this.mRecorder.getMaxAmplitude();
                if (this.webViewRef != null && (mMWebView = (MMWebView)((Object)this.webViewRef.get())) != null) {
                    this._state = State.RECORDING;
                    mMWebView.setmicrophoneStateChange(State.RECORDING.getState());
                    if (n2 > 0) {
                        if (this.audioRunnable != null) {
                            this.audioRunnable.cancel();
                        }
                        this.audioRunnable = new AudioRunnable(n2);
                        mMWebView.postDelayed(this.audioRunnable, n2);
                    }
                }
                return;
            }
        }

        void addCallBack(MMWebView mMWebView) {
            synchronized (this) {
                this.webViewRef = new WeakReference<MMWebView>(mMWebView);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void stopRecording() {
            synchronized (this) {
                MMWebView mMWebView;
                MediaRecorder mediaRecorder = this.mRecorder;
                if (mediaRecorder != null) {
                    try {
                        this.mRecorder.stop();
                        this.mRecorder.reset();
                    }
                    catch (Exception exception) {
                        MMSDK.Log.w("Exception: " + exception.getMessage());
                    }
                }
                if (this.audioRunnable != null) {
                    this.audioRunnable.cancel();
                }
                if (this.webViewRef != null && (mMWebView = (MMWebView)((Object)this.webViewRef.get())) != null) {
                    this._state = State.READY;
                    mMWebView.setmicrophoneStateChange(State.READY.getState());
                }
                return;
            }
        }

        private class AudioRunnable
        implements Runnable {
            private int _callbackRate;
            boolean shouldCancel;

            public AudioRunnable(int n2) {
                this._callbackRate = n2;
            }

            void cancel() {
                this.shouldCancel = true;
            }

            @Override
            public void run() {
                if (Recorder.this._state.equals((Object)State.RECORDING) && !this.shouldCancel) {
                    MMWebView mMWebView = (MMWebView)((Object)Recorder.this.webViewRef.get());
                    if (mMWebView != null) {
                        mMWebView.setmicrophoneAudioLevelChange(Recorder.this.getAudioLevel());
                    }
                    mMWebView.postDelayed(this, this._callbackRate);
                }
            }
        }

        private static class SingletonHolder {
            public static final Recorder INSTANCE = new Recorder();

            private SingletonHolder() {
            }
        }

        static final class State
        extends Enum<State> {
            private static final /* synthetic */ State[] $VALUES;
            public static final /* enum */ State READY;
            public static final /* enum */ State RECORDING;
            private String _state;

            static {
                RECORDING = new State("recording");
                READY = new State("ready");
                State[] stateArray = new State[]{RECORDING, READY};
                $VALUES = stateArray;
            }

            private State(String string3) {
                this._state = string3;
            }

            public static State valueOf(String string2) {
                return Enum.valueOf(State.class, string2);
            }

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public String getState() {
                return this._state;
            }
        }
    }
}

