/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.net.Uri;
import android.os.StatFs;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.millennialmedia.android.AdCache;
import com.millennialmedia.android.Base64;
import com.millennialmedia.android.HandShake;
import com.millennialmedia.android.MMJSObject;
import com.millennialmedia.android.MMJSResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import org.json.JSONArray;

class BridgeMMFileManager
extends MMJSObject {
    private File root;

    BridgeMMFileManager() {
    }

    private boolean hasCreativeDirectory() {
        Context context = (Context)this.contextRef.get();
        if (context != null) {
            File file;
            this.root = file = AdCache.getCacheDirectory(context);
            if (file != null) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MMJSResponse cleanupCache(HashMap<String, String> hashMap) {
        long l2 = 259200000L;
        if (!this.hasCreativeDirectory()) return null;
        boolean bl2 = hashMap.containsKey("clear");
        boolean bl3 = false;
        if (bl2) {
            bl3 = Boolean.parseBoolean(hashMap.get("clear"));
        }
        if (bl3) {
            l2 = 0L;
        } else {
            Context context = (Context)this.contextRef.get();
            if (context != null) {
                l2 = HandShake.sharedHandShake((Context)context).creativeCacheTimeout;
            }
        }
        try {
            AdCache.cleanupDirectory(this.root, l2);
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public MMJSResponse downloadFile(HashMap<String, String> hashMap) {
        String string2;
        Context context = (Context)this.contextRef.get();
        String string3 = hashMap.get("url");
        if (!TextUtils.isEmpty((CharSequence)string3) && context != null && AdCache.downloadComponentToCache(string3, string2 = hashMap.containsKey("path") ? hashMap.get("path") : Uri.parse((String)hashMap.get("url")).getLastPathSegment(), context)) {
            return MMJSResponse.responseWithSuccess(string2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MMJSResponse getDirectoryContents(HashMap<String, String> hashMap) {
        if (!this.hasCreativeDirectory()) {
            return null;
        }
        File file = hashMap.containsKey("path") ? new File(this.root, hashMap.get("path")) : this.root;
        JSONArray jSONArray = new JSONArray();
        String[] stringArray = file.list();
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                MMJSResponse mMJSResponse = new MMJSResponse();
                mMJSResponse.result = 1;
                mMJSResponse.response = jSONArray;
                return mMJSResponse;
            }
            jSONArray.put((Object)stringArray[n3]);
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    public MMJSResponse getFileContents(HashMap<String, String> var1_1) {
        block18: {
            block17: {
                if (!this.hasCreativeDirectory()) break block18;
                var2_2 = null;
                if (!var1_1.containsKey("path")) break block18;
                var3_3 = new File(this.root, var1_1.get("path"));
                var4_4 = new FileInputStream(var3_3);
                var6_5 = new byte[(int)var3_3.length()];
                var4_4.read(var6_5);
                if (var4_4 == null) break block17;
                try {
                    var4_4.close();
                }
                catch (Exception var12_7) {
                    ** GOTO lbl15
                }
            }
lbl15:
            // 5 sources

            while (var6_5 != null) {
                var8_6 = new MMJSResponse();
                var8_6.result = 1;
                var8_6.dataResponse = var6_5;
                return var8_6;
            }
            break block18;
            catch (Exception var13_8) lbl-1000:
            // 2 sources

            {
                while (true) {
                    var6_5 = null;
                    if (var2_2 == null) ** GOTO lbl15
                    try {
                        var2_2.close();
                        var6_5 = null;
                    }
                    catch (Exception var7_9) {
                        var6_5 = null;
                    }
                    break;
                }
            }
            catch (Throwable var9_10) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var2_2 != null) {
                        var2_2.close();
                    }
lbl39:
                    // 4 sources

                    throw var9_11;
                }
            }
        }
        return null;
        {
            catch (Exception var10_13) {
                ** continue;
            }
        }
        catch (Throwable var9_12) {
            var2_2 = var4_4;
            ** continue;
        }
        catch (Exception var5_14) {
            var2_2 = var4_4;
            ** continue;
        }
    }

    public MMJSResponse getFreeDiskSpace(HashMap<String, String> hashMap) {
        if (this.hasCreativeDirectory()) {
            MMJSResponse mMJSResponse = new MMJSResponse();
            mMJSResponse.result = 1;
            StatFs statFs = new StatFs(this.root.getAbsolutePath());
            mMJSResponse.response = new Long((long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize());
            return mMJSResponse;
        }
        return null;
    }

    public MMJSResponse getMimeType(HashMap<String, String> hashMap) {
        if (this.hasCreativeDirectory()) {
            String[] stringArray = hashMap.get("path").split("\\.");
            String string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(stringArray[-1 + stringArray.length]);
            if (string2 != null) {
                MMJSResponse mMJSResponse = new MMJSResponse();
                mMJSResponse.result = 1;
                mMJSResponse.response = string2;
                return mMJSResponse;
            }
        }
        return null;
    }

    public MMJSResponse moveFile(HashMap<String, String> hashMap) {
        block5: {
            if (this.hasCreativeDirectory()) {
                String string2 = hashMap.get("fromPath");
                String string3 = hashMap.get("toPath");
                if (string2 == null || string3 == null) break block5;
                try {
                    if (new File(this.root, string2).renameTo(new File(this.root, string3))) {
                        MMJSResponse mMJSResponse = MMJSResponse.responseWithSuccess("File moved successfully");
                        return mMJSResponse;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public MMJSResponse removeAtPath(HashMap<String, String> hashMap) {
        block5: {
            if (this.hasCreativeDirectory()) {
                String string2 = hashMap.get("path");
                if (string2 == null) break block5;
                try {
                    if (new File(this.root, string2).delete()) {
                        MMJSResponse mMJSResponse = MMJSResponse.responseWithSuccess("File removed successfully");
                        return mMJSResponse;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public MMJSResponse writeData(HashMap<String, String> var1_1) {
        block18: {
            block17: {
                if (!this.hasCreativeDirectory()) break block18;
                var2_2 = null;
                if (!var1_1.containsKey("path") || !var1_1.containsKey("data")) break block18;
                var3_3 = new File(this.root, var1_1.get("path"));
                var9_4 = Base64.decode(var1_1.get("data"));
                var10_5 = new FileOutputStream(var3_3);
                var10_5.write(var9_4);
                var7_6 = true;
                if (var10_5 == null) break block17;
                try {
                    var10_5.close();
                }
                catch (Exception var12_7) {
                    ** GOTO lbl15
                }
            }
lbl15:
            // 5 sources

            while (var7_6) {
                return MMJSResponse.responseWithSuccess("File written successfully");
            }
            break block18;
            catch (Exception var6_8) lbl-1000:
            // 2 sources

            {
                while (true) {
                    var7_6 = false;
                    if (var2_2 == null) ** GOTO lbl15
                    try {
                        var2_2.close();
                        var7_6 = false;
                    }
                    catch (Exception var8_9) {
                        var7_6 = false;
                    }
                    break;
                }
            }
            catch (Throwable var4_10) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var2_2 != null) {
                        var2_2.close();
                    }
lbl36:
                    // 4 sources

                    throw var4_11;
                }
            }
        }
        return null;
        {
            catch (Exception var5_13) {
                ** continue;
            }
        }
        catch (Throwable var4_12) {
            var2_2 = var10_5;
            ** continue;
        }
        catch (Exception var11_14) {
            var2_2 = var10_5;
            ** continue;
        }
    }
}

