/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.millennialmedia.android.HandShake;
import com.millennialmedia.android.MMJSObject;
import com.millennialmedia.android.MMJSResponse;
import com.millennialmedia.android.MMRequest;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.MMWebView;
import com.millennialmedia.android.Utils;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class BridgeMMDevice
extends MMJSObject {
    BridgeMMDevice() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static JSONObject getDeviceInfo(Context context) {
        JSONArray jSONArray;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
        }
        catch (JSONException jSONException) {
            return null;
        }
        try {
            jSONObject2.put("sdkVersion", (Object)"5.1.0-13.08.12.a");
            jSONObject2.put("mmisdk", (Object)"5.1.0-13.08.12.a");
            jSONObject2.put("connection", (Object)MMSDK.getConnectionType(context));
            jSONObject2.put("platform", (Object)"Android");
            if (Build.VERSION.RELEASE != null) {
                jSONObject2.put("version", (Object)Build.VERSION.RELEASE);
            }
            if (Build.MODEL != null) {
                jSONObject2.put("device", (Object)Build.MODEL);
            }
            jSONObject2.put("mmdid", (Object)MMSDK.getMMdid(context));
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            jSONObject2.put("density", (Object)new Float(displayMetrics.density));
            jSONObject2.put("height", (Object)new Integer(displayMetrics.heightPixels));
            jSONObject2.put("width", (Object)new Integer(displayMetrics.widthPixels));
            Locale locale = Locale.getDefault();
            if (locale != null) {
                jSONObject2.put("language", (Object)locale.getLanguage());
                jSONObject2.put("country", (Object)locale.getCountry());
            }
            jSONObject = new JSONObject();
        }
        catch (JSONException jSONException) {
            return jSONObject2;
        }
        try {
            jSONObject.put("name", (Object)"MAC-ID");
            jSONObject.put("path", (Object)"/");
            jSONObject.put("value", (Object)MMSDK.macId);
            jSONArray = new JSONArray();
        }
        catch (JSONException jSONException) {
            return jSONObject2;
        }
        try {}
        catch (JSONException jSONException) {
            return jSONObject2;
        }
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("cookies", (Object)jSONArray);
        return jSONObject2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MMJSResponse call(HashMap<String, String> hashMap) {
        Context context = (Context)this.contextRef.get();
        String string2 = hashMap.get("number");
        if (context != null && string2 != null) {
            MMSDK.Log.d("Dialing Phone: %s", string2);
            Intent intent = Boolean.parseBoolean(hashMap.get("dial")) && context.checkCallingOrSelfPermission("android.permission.CALL_PHONE") == 0 ? new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + string2))) : new Intent("android.intent.action.VIEW", Uri.parse((String)("tel:" + string2)));
            Utils.IntentUtils.startActivity(context, intent);
            MMSDK.Event.intentStarted(context, "tel", this.getAdImplId(hashMap.get("PROPERTY_EXPANDING")));
            return MMJSResponse.responseWithSuccess();
        }
        return null;
    }

    public MMJSResponse composeEmail(HashMap<String, String> hashMap) {
        Context context = (Context)this.contextRef.get();
        String string2 = hashMap.get("recipient");
        String string3 = hashMap.get("subject");
        String string4 = hashMap.get("message");
        if (context != null) {
            MMSDK.Log.d("Creating email");
            Intent intent = new Intent("android.intent.action.SEND");
            intent.setType("plain/text");
            if (string2 != null) {
                intent.putExtra("android.intent.extra.EMAIL", string2.split(","));
            }
            if (string3 != null) {
                intent.putExtra("android.intent.extra.SUBJECT", string3);
            }
            if (string4 != null) {
                intent.putExtra("android.intent.extra.TEXT", string4);
            }
            Utils.IntentUtils.startActivity(context, intent);
            MMSDK.Event.intentStarted(context, "email", this.getAdImplId(hashMap.get("PROPERTY_EXPANDING")));
            return MMJSResponse.responseWithSuccess();
        }
        return null;
    }

    public MMJSResponse composeSms(HashMap<String, String> hashMap) {
        Context context = (Context)this.contextRef.get();
        String string2 = hashMap.get("number");
        String string3 = hashMap.get("message");
        if (context != null && string2 != null) {
            MMSDK.Log.d("Creating sms: %s", string2);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("sms:" + string2)));
            if (string3 != null) {
                intent.putExtra("sms_body", string3);
            }
            Utils.IntentUtils.startActivity(context, intent);
            MMSDK.Event.intentStarted(context, "sms", this.getAdImplId(hashMap.get("PROPERTY_EXPANDING")));
            return MMJSResponse.responseWithSuccess("SMS Sent");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MMJSResponse enableHardwareAcceleration(HashMap<String, String> hashMap) {
        MMSDK.Log.d("hardware accel call" + hashMap);
        String string2 = hashMap.get("enabled");
        MMWebView mMWebView = (MMWebView)((Object)this.mmWebViewRef.get());
        if (mMWebView == null || mMWebView == null) return null;
        if (Boolean.parseBoolean(string2)) {
            mMWebView.enableHardwareAcceleration();
            return MMJSResponse.responseWithSuccess();
        }
        mMWebView.disableAllAcceleration();
        return MMJSResponse.responseWithSuccess();
    }

    public MMJSResponse getAvailableSchemes(HashMap<String, String> hashMap) {
        Context context = (Context)this.contextRef.get();
        if (context != null) {
            HandShake handShake = HandShake.sharedHandShake(context);
            MMJSResponse mMJSResponse = new MMJSResponse();
            mMJSResponse.result = 1;
            mMJSResponse.response = handShake.getSchemesJSONArray(context);
            return mMJSResponse;
        }
        return null;
    }

    public MMJSResponse getInfo(HashMap<String, String> hashMap) {
        Context context = (Context)this.contextRef.get();
        if (context != null) {
            MMJSResponse mMJSResponse = new MMJSResponse();
            mMJSResponse.result = 1;
            mMJSResponse.response = BridgeMMDevice.getDeviceInfo(context);
            return mMJSResponse;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MMJSResponse getLocation(HashMap<String, String> hashMap) {
        JSONObject jSONObject;
        block9: {
            JSONObject jSONObject2;
            if (MMRequest.location == null) {
                return MMJSResponse.responseWithError("location object has not been set");
            }
            try {
                jSONObject2 = new JSONObject();
            }
            catch (JSONException jSONException) {
                jSONObject = null;
                break block9;
            }
            try {
                jSONObject2.put("lat", (Object)Double.toString(MMRequest.location.getLatitude()));
                jSONObject2.put("long", (Object)Double.toString(MMRequest.location.getLongitude()));
                if (MMRequest.location.hasAccuracy()) {
                    jSONObject2.put("ha", (Object)Float.toString(MMRequest.location.getAccuracy()));
                    jSONObject2.put("va", (Object)Float.toString(MMRequest.location.getAccuracy()));
                }
                if (MMRequest.location.hasSpeed()) {
                    jSONObject2.put("spd", (Object)Float.toString(MMRequest.location.getSpeed()));
                }
                if (MMRequest.location.hasBearing()) {
                    jSONObject2.put("brg", (Object)Float.toString(MMRequest.location.getBearing()));
                }
                if (MMRequest.location.hasAltitude()) {
                    jSONObject2.put("alt", (Object)Double.toString(MMRequest.location.getAltitude()));
                }
                jSONObject2.put("tslr", (Object)Long.toString(MMRequest.location.getTime()));
                jSONObject = jSONObject2;
            }
            catch (JSONException jSONException) {
                jSONObject = jSONObject2;
            }
        }
        MMJSResponse mMJSResponse = new MMJSResponse();
        mMJSResponse.result = 1;
        mMJSResponse.response = jSONObject;
        return mMJSResponse;
    }

    public MMJSResponse getOrientation(HashMap<String, String> hashMap) {
        Context context = (Context)this.contextRef.get();
        if (context != null) {
            int n2 = context.getResources().getConfiguration().orientation;
            if (n2 == 0) {
                n2 = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getOrientation();
            }
            MMJSResponse mMJSResponse = new MMJSResponse();
            mMJSResponse.result = 1;
            switch (n2) {
                default: {
                    mMJSResponse.response = "portrait";
                    return mMJSResponse;
                }
                case 2: 
            }
            mMJSResponse.response = "landscape";
            return mMJSResponse;
        }
        return null;
    }

    public MMJSResponse isSchemeAvailable(HashMap<String, String> hashMap) {
        String string2 = hashMap.get("scheme");
        if (!string2.contains(":")) {
            string2 = string2 + ":";
        }
        Context context = (Context)this.contextRef.get();
        if (string2 != null && context != null) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            if (context.getPackageManager().queryIntentActivities(intent, 65536).size() > 0) {
                return MMJSResponse.responseWithSuccess(string2);
            }
        }
        return MMJSResponse.responseWithError(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public MMJSResponse openAppStore(HashMap<String, String> hashMap) {
        Context context = (Context)this.contextRef.get();
        String string2 = hashMap.get("appId");
        String string3 = hashMap.get("referrer");
        if (context != null && string2 != null) {
            MMSDK.Log.d("Opening marketplace: %s", string2);
            Intent intent = new Intent("android.intent.action.VIEW");
            if (string3 != null) {
                Object[] objectArray = new Object[]{string2, URLEncoder.encode(string3)};
                intent.setData(Uri.parse((String)String.format("market://details?id=%s&referrer=%s", objectArray)));
            } else {
                intent.setData(Uri.parse((String)("market://details?id=" + string2)));
            }
            MMSDK.Event.intentStarted(context, "market", this.getAdImplId(hashMap.get("PROPERTY_EXPANDING")));
            Utils.IntentUtils.startActivity(context, intent);
            return MMJSResponse.responseWithSuccess();
        }
        return null;
    }

    public MMJSResponse openUrl(HashMap<String, String> hashMap) {
        Context context = (Context)this.contextRef.get();
        String string2 = hashMap.get("url");
        if (context != null && string2 != null) {
            MMSDK.Log.d("Opening: %s", string2);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            if (intent.getScheme().startsWith("http") || intent.getScheme().startsWith("https")) {
                MMSDK.Event.intentStarted(context, "browser", this.getAdImplId(hashMap.get("PROPERTY_EXPANDING")));
            }
            Utils.IntentUtils.startActivity(context, intent);
            return MMJSResponse.responseWithSuccess("Overlay opened");
        }
        return MMJSResponse.responseWithError("URL could not be opened");
    }

    public MMJSResponse setMMDID(HashMap<String, String> hashMap) {
        String string2 = hashMap.get("mmdid");
        Context context = (Context)this.contextRef.get();
        if (context != null) {
            HandShake.sharedHandShake(context).setMMdid(context, string2);
            return MMJSResponse.responseWithSuccess("MMDID is set");
        }
        return null;
    }

    public MMJSResponse showMap(HashMap<String, String> hashMap) {
        Context context = (Context)this.contextRef.get();
        String string2 = hashMap.get("location");
        if (context != null && string2 != null) {
            MMSDK.Log.d("Launching Google Maps: %s", string2);
            Utils.IntentUtils.startActivity(context, new Intent("android.intent.action.VIEW", Uri.parse((String)("geo:" + string2))));
            MMSDK.Event.intentStarted(context, "geo", this.getAdImplId(hashMap.get("PROPERTY_EXPANDING")));
            return MMJSResponse.responseWithSuccess("Map successfully opened");
        }
        return null;
    }

    public MMJSResponse tweet(HashMap<String, String> hashMap) {
        return null;
    }
}

