/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.app.Activity;
import android.content.Context;
import com.millennialmedia.android.AdCache;
import com.millennialmedia.android.CachedAd;
import com.millennialmedia.android.HttpGetRequest;
import com.millennialmedia.android.MMActivity;
import com.millennialmedia.android.MMBaseActivity;
import com.millennialmedia.android.MMJSObject;
import com.millennialmedia.android.MMJSResponse;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.MMWebView;
import com.millennialmedia.android.VideoAd;
import com.millennialmedia.android.VideoPlayerActivity;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.json.JSONArray;

class BridgeMMCachedVideo
extends MMJSObject
implements AdCache.AdCacheTaskListener {
    private boolean success;

    BridgeMMCachedVideo() {
    }

    private VideoPlayerActivity getVPA() {
        WeakReference weakReference = this.mmWebViewRef;
        VideoPlayerActivity videoPlayerActivity = null;
        if (weakReference != null) {
            Object t2 = this.mmWebViewRef.get();
            videoPlayerActivity = null;
            if (t2 != null) {
                boolean bl2 = ((MMWebView)((Object)this.mmWebViewRef.get())).getActivity() instanceof MMActivity;
                videoPlayerActivity = null;
                if (bl2) {
                    MMWebView mMWebView = (MMWebView)((Object)this.mmWebViewRef.get());
                    videoPlayerActivity = null;
                    if (mMWebView != null) {
                        Activity activity = mMWebView.getActivity();
                        videoPlayerActivity = null;
                        if (activity != null) {
                            boolean bl3 = activity instanceof MMActivity;
                            videoPlayerActivity = null;
                            if (bl3) {
                                MMActivity mMActivity = (MMActivity)activity;
                                MMBaseActivity mMBaseActivity = mMActivity.getWrappedActivity();
                                videoPlayerActivity = null;
                                if (mMBaseActivity != null) {
                                    boolean bl4 = mMActivity.getWrappedActivity() instanceof VideoPlayerActivity;
                                    videoPlayerActivity = null;
                                    if (bl4) {
                                        videoPlayerActivity = (VideoPlayerActivity)mMActivity.getWrappedActivity();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return videoPlayerActivity;
    }

    public MMJSResponse availableCachedVideos(HashMap<String, String> hashMap) {
        final Context context = (Context)this.contextRef.get();
        if (context != null) {
            final JSONArray jSONArray = new JSONArray();
            AdCache.iterateCachedAds(context, 2, new AdCache.Iterator(){

                @Override
                boolean callback(CachedAd cachedAd) {
                    if (cachedAd instanceof VideoAd && cachedAd.isOnDisk(context) && !cachedAd.isExpired()) {
                        jSONArray.put((Object)cachedAd.getId());
                    }
                    return true;
                }
            });
            MMJSResponse mMJSResponse = new MMJSResponse();
            mMJSResponse.result = 1;
            mMJSResponse.response = jSONArray;
            return mMJSResponse;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MMJSResponse cacheVideo(HashMap<String, String> hashMap) {
        synchronized (this) {
            Context context = (Context)this.contextRef.get();
            String string2 = hashMap.get("url");
            MMJSResponse mMJSResponse = null;
            if (string2 == null) return mMJSResponse;
            mMJSResponse = null;
            if (context == null) return mMJSResponse;
            try {
                block19: {
                    block20: {
                        HttpResponse httpResponse;
                        block18: {
                            httpResponse = new HttpGetRequest().get(string2);
                            if (httpResponse != null) break block18;
                            MMSDK.Log.i("HTTP response is null");
                            break block19;
                        }
                        HttpEntity httpEntity = httpResponse.getEntity();
                        if (httpEntity == null) {
                            MMSDK.Log.d("Null HTTP entity");
                            return null;
                        }
                        if (httpEntity.getContentLength() == 0L) {
                            MMSDK.Log.d("Millennial ad return failed. Zero content length returned.");
                            return null;
                        }
                        Header header = httpEntity.getContentType();
                        mMJSResponse = null;
                        if (header == null) return mMJSResponse;
                        String string3 = header.getValue();
                        mMJSResponse = null;
                        if (string3 == null) return mMJSResponse;
                        boolean bl2 = header.getValue().equalsIgnoreCase("application/json");
                        mMJSResponse = null;
                        if (!bl2) return mMJSResponse;
                        VideoAd videoAd = new VideoAd(HttpGetRequest.convertStreamToString(httpEntity.getContent()));
                        mMJSResponse = null;
                        if (videoAd == null) return mMJSResponse;
                        boolean bl3 = videoAd.isValid();
                        mMJSResponse = null;
                        if (!bl3) return mMJSResponse;
                        videoAd.downloadPriority = 3;
                        boolean bl4 = AdCache.startDownloadTask(context, null, videoAd, this);
                        if (!bl4) break block20;
                        try {
                            block21: {
                                this.wait();
                                if (this.success) {
                                    MMJSResponse mMJSResponse2;
                                    mMJSResponse = mMJSResponse2 = MMJSResponse.responseWithSuccess(String.format("Cached video(%s)", string2));
                                    this.notify();
                                }
                                break block21;
                                catch (IllegalStateException illegalStateException) {
                                    illegalStateException.printStackTrace();
                                    MMSDK.Log.d("Millennial ad return failed. Invalid response data.");
                                    mMJSResponse = null;
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                    MMSDK.Log.d("Millennial ad return failed. Invalid response data.");
                                    mMJSResponse = null;
                                }
                            }
                            this.notify();
                            mMJSResponse = null;
                        }
                        catch (InterruptedException interruptedException) {
                            MMSDK.Log.e(interruptedException);
                            Object[] objectArray = new Object[]{interruptedException.getMessage()};
                            MMSDK.Log.e("Caching interrupted: %s", objectArray);
                            mMJSResponse = null;
                        }
                        finally {
                            this.notify();
                        }
                    }
                    MMJSResponse mMJSResponse3 = MMJSResponse.responseWithError(String.format("Unable to start download for Cached video(%s)", string2));
                    return mMJSResponse3;
                }
                return mMJSResponse;
            }
            catch (Exception exception) {
                MMSDK.Log.d("HTTP error: " + exception.getMessage());
                return null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void downloadCompleted(CachedAd cachedAd, boolean bl2) {
        synchronized (this) {
            Context context = (Context)this.contextRef.get();
            if (bl2 && context != null) {
                AdCache.save(context, cachedAd);
            }
            this.success = bl2;
            this.notify();
            return;
        }
    }

    @Override
    public void downloadStart(CachedAd cachedAd) {
    }

    public MMJSResponse endVideo(HashMap<String, String> hashMap) {
        final VideoPlayerActivity videoPlayerActivity = this.getVPA();
        if (videoPlayerActivity != null) {
            return this.runOnUiThreadFuture(new Callable<MMJSResponse>(){

                @Override
                public MMJSResponse call() {
                    videoPlayerActivity.endVideo();
                    return MMJSResponse.responseWithSuccess();
                }
            });
        }
        return null;
    }

    public MMJSResponse pauseVideo(HashMap<String, String> hashMap) {
        final VideoPlayerActivity videoPlayerActivity = this.getVPA();
        if (videoPlayerActivity != null) {
            return this.runOnUiThreadFuture(new Callable<MMJSResponse>(){

                @Override
                public MMJSResponse call() {
                    videoPlayerActivity.pauseVideoByUser();
                    return MMJSResponse.responseWithSuccess();
                }
            });
        }
        return null;
    }

    public MMJSResponse playCachedVideo(HashMap<String, String> hashMap) {
        Context context = (Context)this.contextRef.get();
        String string2 = hashMap.get("videoId");
        MMJSResponse mMJSResponse = null;
        if (string2 != null) {
            mMJSResponse = null;
            if (context != null) {
                VideoAd videoAd = (VideoAd)AdCache.load(context, string2);
                mMJSResponse = null;
                if (videoAd != null) {
                    boolean bl2 = videoAd.canShow(context, null, false);
                    mMJSResponse = null;
                    if (bl2) {
                        videoAd.show(context, this.getAdImplId(hashMap.get("PROPERTY_EXPANDING")));
                        mMJSResponse = MMJSResponse.responseWithSuccess(String.format("Playing Video(%s)", string2));
                    }
                }
            }
        }
        return mMJSResponse;
    }

    public MMJSResponse playVideo(HashMap<String, String> hashMap) {
        final VideoPlayerActivity videoPlayerActivity = this.getVPA();
        if (videoPlayerActivity != null) {
            return this.runOnUiThreadFuture(new Callable<MMJSResponse>(){

                @Override
                public MMJSResponse call() {
                    videoPlayerActivity.resumeVideo();
                    return MMJSResponse.responseWithSuccess();
                }
            });
        }
        return null;
    }

    public MMJSResponse restartVideo(HashMap<String, String> hashMap) {
        final VideoPlayerActivity videoPlayerActivity = this.getVPA();
        if (videoPlayerActivity != null) {
            return this.runOnUiThreadFuture(new Callable<MMJSResponse>(){

                @Override
                public MMJSResponse call() {
                    videoPlayerActivity.restartVideo();
                    return MMJSResponse.responseWithSuccess();
                }
            });
        }
        return null;
    }

    @Deprecated
    public MMJSResponse videoIdExists(HashMap<String, String> hashMap) {
        VideoAd videoAd;
        Context context = (Context)this.contextRef.get();
        String string2 = hashMap.get("videoId");
        if (string2 != null && context != null && (videoAd = (VideoAd)AdCache.load(context, string2)) != null && videoAd.isOnDisk(context) && !videoAd.isExpired()) {
            return MMJSResponse.responseWithSuccess(string2);
        }
        return null;
    }
}

