/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.millennialmedia.android.AdViewOverlayActivity;
import com.millennialmedia.android.BannerExpandedWebViewClient;
import com.millennialmedia.android.BridgeMMSpeechkit;
import com.millennialmedia.android.HttpGetRequest;
import com.millennialmedia.android.InterstitialWebViewClient;
import com.millennialmedia.android.MMAdImpl;
import com.millennialmedia.android.MMAdImplController;
import com.millennialmedia.android.MMLayout;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.MMWebViewClient;
import com.millennialmedia.android.OverlaySettings;
import java.lang.ref.WeakReference;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

class AdViewOverlayView
extends MMLayout {
    private Button mraidCloseButton;
    CloseTopDrawable mraidCloseDrawable;
    WeakReference<AdViewOverlayActivity> overlayActivityRef;
    private ProgressBar progressBar;
    private boolean progressDone;
    OverlaySettings settings;

    /*
     * Enabled aggressive block sorting
     */
    AdViewOverlayView(AdViewOverlayActivity adViewOverlayActivity, OverlaySettings overlaySettings) {
        super((Context)adViewOverlayActivity.activity);
        this.overlayActivityRef = new WeakReference<AdViewOverlayActivity>(adViewOverlayActivity);
        this.adImpl = new AdViewOverlayViewMMAdImpl((Context)adViewOverlayActivity.activity);
        this.setId(15062);
        this.adImpl.adType = "i";
        this.settings = overlaySettings;
        boolean bl2 = adViewOverlayActivity.activity instanceof Activity;
        NonConfigurationInstance nonConfigurationInstance = null;
        if (bl2) {
            nonConfigurationInstance = (NonConfigurationInstance)adViewOverlayActivity.activity.getLastNonConfigurationInstance();
            if (nonConfigurationInstance != null) {
                this.progressDone = nonConfigurationInstance.progressDone;
                this.adImpl.controller = nonConfigurationInstance.controller;
                this.settings = nonConfigurationInstance.settings;
                if (this.adImpl != null && this.adImpl.controller != null && this.adImpl.controller.webView != null) {
                    this.addView((View)this.adImpl.controller.webView);
                }
                MMSDK.Log.d("Restoring configurationinstance w/ controller= " + nonConfigurationInstance.controller);
            } else {
                MMSDK.Log.d("Null configurationinstance ");
            }
        }
        float f2 = adViewOverlayActivity.activity.getResources().getDisplayMetrics().density;
        RelativeLayout.LayoutParams layoutParams = this.settings.height != 0 && this.settings.width != 0 ? new RelativeLayout.LayoutParams((int)(f2 * (float)this.settings.width), (int)(f2 * (float)this.settings.height)) : new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(13);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        Integer n2 = (int)(0.0625f * f2 * (float)this.settings.shouldResizeOverlay);
        this.setPadding(n2, n2, n2, n2);
        this.mraidCloseButton = this.initMRaidCloseButton((Context)adViewOverlayActivity.activity, f2);
        if (this.settings.isExpanded() && !this.settings.hasExpandUrl()) {
            this.adImpl.linkForExpansionId = this.settings.creatorAdImplId;
        }
        MMAdImplController.assignAdViewController(this.adImpl);
        if (this.mraidCloseButton != null) {
            this.addView((View)this.mraidCloseButton);
        }
        if (!(this.progressDone || this.settings.isExpanded() || this.settings.isFromInterstitial())) {
            this.initProgressBar();
        }
        if (this.settings.getIsTransparent()) {
            if (this.adImpl != null && this.adImpl.controller != null && this.adImpl.controller.webView != null) {
                this.adImpl.controller.webView.setBackgroundColor(0);
            }
            this.setBackgroundColor(0);
        } else {
            if (this.adImpl != null && this.adImpl.controller != null && this.adImpl.controller.webView != null) {
                this.adImpl.controller.webView.setBackgroundColor(-1);
            }
            this.setBackgroundColor(-1);
        }
        if (this.settings.enableHardwareAccel() && this.adImpl != null && this.adImpl.controller != null && this.adImpl.controller.webView != null) {
            this.adImpl.controller.webView.enableHardwareAcceleration();
        }
        if (nonConfigurationInstance == null) {
            this.animateView();
        }
        this.setUseCustomClose(this.settings.getUseCustomClose());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void animateView() {
        block5: {
            TranslateAnimation translateAnimation;
            block3: {
                block4: {
                    block2: {
                        if (!this.settings.getTransition().equals("slideup")) break block2;
                        translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
                        MMSDK.Log.v("Translate up");
                        break block3;
                    }
                    if (!this.settings.getTransition().equals("slidedown")) break block4;
                    translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, -1.0f, 1, 0.0f);
                    MMSDK.Log.v("Translate down");
                    break block3;
                }
                if (!this.settings.getTransition().equals("explode")) break block5;
                translateAnimation = new ScaleAnimation(1.1f, 0.9f, 0.1f, 0.9f, 1, 0.5f, 1, 0.5f);
                MMSDK.Log.v("Explode");
            }
            translateAnimation.setDuration(this.settings.getTransitionDurationInMillis());
            this.startAnimation((Animation)translateAnimation);
        }
    }

    private RelativeLayout.LayoutParams getCloseAreaParams(float f2) {
        int n2 = (int)(0.5f + 50.0f * f2);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(n2, n2);
        layoutParams.addRule(11);
        layoutParams.addRule(10);
        return layoutParams;
    }

    private Button initMRaidCloseButton(Context context, float f2) {
        Button button = new Button(context);
        button.setId(301);
        this.mraidCloseDrawable = new CloseTopDrawable(true, f2);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MMSDK.Log.v("Close button clicked.");
                AdViewOverlayView.this.finishOverlayWithAnimation();
            }
        });
        RelativeLayout.LayoutParams layoutParams = this.getCloseAreaParams(f2);
        button.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        button.post((Runnable)new SetCloseButtonTouchDelegateRunnable(button, layoutParams.topMargin, layoutParams.leftMargin, layoutParams.bottomMargin, layoutParams.rightMargin));
        return button;
    }

    private void initProgressBar() {
        AdViewOverlayActivity adViewOverlayActivity = (AdViewOverlayActivity)this.overlayActivityRef.get();
        if (adViewOverlayActivity != null) {
            this.progressBar = new ProgressBar((Context)adViewOverlayActivity.activity);
            this.progressBar.setIndeterminate(true);
            this.progressBar.setVisibility(0);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(13);
            this.addView((View)this.progressBar, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    private void removeProgressBar() {
        if (!this.progressDone && this.progressBar != null) {
            this.progressDone = true;
            this.progressBar.setVisibility(8);
            this.removeView((View)this.progressBar);
            this.progressBar = null;
        }
    }

    @Override
    void addInlineVideo() {
        super.addInlineVideo();
        this.bringMraidCloseToFront();
    }

    boolean attachWebViewToLink() {
        return this.adImpl != null && this.adImpl.linkForExpansionId != 0L && MMAdImplController.attachWebViewFromOverlay(this.adImpl);
    }

    void bringMraidCloseToFront() {
        if (this.mraidCloseButton != null) {
            this.mraidCloseButton.bringToFront();
        }
    }

    @Override
    void closeAreaTouched() {
        this.post(new Runnable(){

            @Override
            public void run() {
                AdViewOverlayView.this.finishOverlayWithAnimation();
            }
        });
    }

    void finishOverlayWithAnimation() {
        MMSDK.Log.d("Ad overlay closed");
        if ((Activity)this.getContext() == null) {
            return;
        }
        AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        alphaAnimation.setAnimationListener((Animation.AnimationListener)new AnimationListener(this));
        alphaAnimation.setFillEnabled(true);
        alphaAnimation.setFillBefore(true);
        alphaAnimation.setFillAfter(true);
        alphaAnimation.setDuration(400L);
        this.startAnimation((Animation)alphaAnimation);
    }

    @Override
    void fullScreenVideoLayout() {
        this.removeView((View)this.inlineVideoLayout);
        this.addView((View)this.inlineVideoLayout, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.bringMraidCloseToFront();
    }

    Object getNonConfigurationInstance() {
        if (this.adImpl != null) {
            MMSDK.Log.d("Saving getNonConfigurationInstance for " + this.adImpl);
            if (this.adImpl.controller != null && this.adImpl.controller.webView != null) {
                this.adImpl.controller.webView.removeFromParent();
            }
        }
        NonConfigurationInstance nonConfigurationInstance = new NonConfigurationInstance();
        nonConfigurationInstance.progressDone = this.progressDone;
        nonConfigurationInstance.controller = this.adImpl.controller;
        nonConfigurationInstance.settings = this.settings;
        return nonConfigurationInstance;
    }

    void getWebContent(String string2) {
        new FetchWebViewContentTask(this, string2).execute(new Void[0]);
    }

    void injectJS(String string2) {
        if (this.adImpl.controller != null) {
            this.adImpl.controller.loadUrl(string2);
        }
    }

    void inlineConfigChange() {
        if (this.inlineVideoView != null && this.inlineVideoLayout != null) {
            this.inlineVideoLayout.setLayoutParams((ViewGroup.LayoutParams)this.inlineVideoView.getCustomLayoutParams());
            this.bringMraidCloseToFront();
        }
    }

    void killWebView() {
        BridgeMMSpeechkit.releaseSpeechKit();
        if (this.adImpl != null && this.adImpl.controller != null && this.adImpl.controller.webView != null) {
            this.adImpl.controller.webView.clearFocus();
            this.adImpl.controller.webView.setMraidViewableHidden();
            this.adImpl.controller.webView.onPauseWebView();
        }
    }

    void removeSelfAndAll() {
        this.removeAllViews();
        ViewParent viewParent = this.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView((View)this);
        }
    }

    @Override
    void repositionVideoLayout() {
        this.removeView((View)this.inlineVideoLayout);
        this.addView((View)this.inlineVideoLayout, (ViewGroup.LayoutParams)this.inlineVideoView.getCustomLayoutParams());
        this.bringMraidCloseToFront();
    }

    /*
     * Enabled aggressive block sorting
     */
    void setUseCustomClose(boolean bl2) {
        this.settings.setUseCustomClose(bl2);
        Button button = this.mraidCloseButton;
        CloseTopDrawable closeTopDrawable = bl2 ? null : this.mraidCloseDrawable;
        button.setBackgroundDrawable((Drawable)closeTopDrawable);
    }

    class AdViewOverlayViewMMAdImpl
    extends MMLayout.MMLayoutMMAdImpl {
        public AdViewOverlayViewMMAdImpl(Context context) {
            super(context);
            this.mmWebViewClientListener = new OverlayWebViewClientListener(this);
        }

        @Override
        MMWebViewClient getMMWebViewClient() {
            MMSDK.Log.d("Returning a client for user: OverlayWebViewClient, adimpl=" + AdViewOverlayView.this.adImpl);
            if (AdViewOverlayView.this.adImpl.linkForExpansionId != 0L || AdViewOverlayView.this.settings.hasExpandUrl()) {
                BannerExpandedWebViewClient bannerExpandedWebViewClient = new BannerExpandedWebViewClient(this.mmWebViewClientListener, new OverlayRedirectionListenerImpl(this));
                this.mmWebViewClient = bannerExpandedWebViewClient;
                return bannerExpandedWebViewClient;
            }
            InterstitialWebViewClient interstitialWebViewClient = new InterstitialWebViewClient(this.mmWebViewClientListener, new OverlayRedirectionListenerImpl(this));
            this.mmWebViewClient = interstitialWebViewClient;
            return interstitialWebViewClient;
        }

        @Override
        boolean isExpandingToUrl() {
            return AdViewOverlayView.this.settings.hasExpandUrl() && !AdViewOverlayView.this.settings.hasLoadedExpandUrl();
        }

        @Override
        void removeProgressBar() {
            AdViewOverlayView.this.removeProgressBar();
        }
    }

    private static class AnimationListener
    implements Animation.AnimationListener {
        private WeakReference<AdViewOverlayView> overlayRef;

        public AnimationListener(AdViewOverlayView adViewOverlayView) {
            this.overlayRef = new WeakReference<AdViewOverlayView>(adViewOverlayView);
        }

        public void onAnimationEnd(Animation animation) {
            AdViewOverlayView adViewOverlayView = (AdViewOverlayView)this.overlayRef.get();
            if (adViewOverlayView != null) {
                Activity activity = (Activity)adViewOverlayView.getContext();
                MMSDK.Log.d("Finishing overlay this is in w/ anim finishOverLayWithAnim()");
                activity.finish();
            }
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationStart(Animation animation) {
            AdViewOverlayView adViewOverlayView = (AdViewOverlayView)this.overlayRef.get();
            if (adViewOverlayView != null && adViewOverlayView.mraidCloseButton != null) {
                adViewOverlayView.mraidCloseButton.setVisibility(8);
            }
        }
    }

    private static class CloseDrawable
    extends Drawable {
        protected boolean enabled = true;
        protected final Paint paint;

        CloseDrawable(boolean bl2) {
            this.enabled = bl2;
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
            this.paint.setStyle(Paint.Style.STROKE);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void draw(Canvas canvas) {
            Rect rect = this.copyBounds();
            int n2 = rect.right - rect.left;
            int n3 = rect.bottom - rect.top;
            float f2 = (float)n2 / 6.0f;
            this.paint.setStrokeWidth(f2);
            int n4 = this.enabled ? 255 : 80;
            this.paint.setARGB(255, n4, n4, n4);
            canvas.drawLine(f2 / 2.0f, f2 / 2.0f, (float)n2 - f2 / 2.0f, (float)n3 - f2 / 2.0f, this.paint);
            canvas.drawLine((float)n2 - f2 / 2.0f, f2 / 2.0f, f2 / 2.0f, (float)n3 - f2 / 2.0f, this.paint);
        }

        public int getOpacity() {
            return -3;
        }

        public void setAlpha(int n2) {
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }
    }

    private static class CloseTopDrawable
    extends CloseDrawable {
        final float dist;
        final float scale;

        CloseTopDrawable(boolean bl2, float f2) {
            super(bl2);
            this.scale = f2;
            this.dist = 4.0f * f2;
            this.paint.setColor(-16777216);
        }

        @Override
        public void draw(Canvas canvas) {
            Rect rect = this.copyBounds();
            float f2 = (float)(rect.right - rect.left) / 10.0f;
            float f3 = (float)rect.right - 20.0f * this.scale;
            float f4 = (float)rect.top + 20.0f * this.scale;
            this.paint.setStrokeWidth(f2);
            this.paint.setColor(-16777216);
            this.paint.setStyle(Paint.Style.STROKE);
            canvas.drawCircle(f3, f4, 12.0f * this.scale, this.paint);
            this.paint.setColor(-1);
            this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
            canvas.drawCircle(f3, f4, 10.0f * this.scale, this.paint);
            this.paint.setColor(-16777216);
            canvas.drawCircle(f3, f4, 7.0f * this.scale, this.paint);
            this.paint.setColor(-1);
            this.paint.setStrokeWidth(f2 / 2.0f);
            this.paint.setStyle(Paint.Style.STROKE);
            canvas.drawLine(f3 - this.dist, f4 - this.dist, f3 + this.dist, f4 + this.dist, this.paint);
            canvas.drawLine(f3 + this.dist, f4 - this.dist, f3 - this.dist, f4 + this.dist, this.paint);
        }
    }

    private static class FetchWebViewContentTask
    extends AsyncTask<Void, Void, String> {
        private WeakReference<AdViewOverlayView> _overlayViewRef;
        private String baseUrl;
        private boolean cancelVideo;

        public FetchWebViewContentTask(AdViewOverlayView adViewOverlayView, String string2) {
            this.baseUrl = string2;
            this._overlayViewRef = new WeakReference<AdViewOverlayView>(adViewOverlayView);
        }

        protected String doInBackground(Void ... voidArray) {
            block6: {
                this.cancelVideo = true;
                if (!TextUtils.isEmpty((CharSequence)this.baseUrl)) {
                    HttpEntity httpEntity;
                    HttpResponse httpResponse = new HttpGetRequest().get(this.baseUrl);
                    if (httpResponse == null) break block6;
                    StatusLine statusLine = httpResponse.getStatusLine();
                    if (httpResponse == null || statusLine == null) break block6;
                    if (statusLine.getStatusCode() == 404 || (httpEntity = httpResponse.getEntity()) == null) break block6;
                    try {
                        String string2 = HttpGetRequest.convertStreamToString(httpEntity.getContent());
                        this.cancelVideo = false;
                        return string2;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void onPostExecute(String string2) {
            AdViewOverlayView adViewOverlayView = (AdViewOverlayView)this._overlayViewRef.get();
            if (adViewOverlayView != null) {
                if (this.cancelVideo) {
                    AdViewOverlayActivity adViewOverlayActivity = (AdViewOverlayActivity)adViewOverlayView.overlayActivityRef.get();
                    if (adViewOverlayActivity != null) {
                        adViewOverlayActivity.finish();
                    } else {
                        adViewOverlayView.removeProgressBar();
                    }
                }
                if (string2 != null && adViewOverlayView.adImpl != null && adViewOverlayView.adImpl.controller != null) {
                    adViewOverlayView.adImpl.controller.setWebViewContent(string2, this.baseUrl);
                }
            }
        }

        protected void onPreExecute() {
            AdViewOverlayView adViewOverlayView = (AdViewOverlayView)this._overlayViewRef.get();
            if (adViewOverlayView != null && adViewOverlayView.progressBar == null) {
                adViewOverlayView.initProgressBar();
            }
            super.onPreExecute();
        }
    }

    private static final class NonConfigurationInstance {
        MMAdImplController controller;
        boolean progressDone;
        OverlaySettings settings;

        private NonConfigurationInstance() {
        }
    }

    static class OverlayRedirectionListenerImpl
    extends MMAdImpl.MMAdImplRedirectionListenerImpl {
        public OverlayRedirectionListenerImpl(MMAdImpl mMAdImpl) {
            super(mMAdImpl);
        }

        @Override
        public boolean isExpandingToUrl() {
            MMAdImpl mMAdImpl = (MMAdImpl)this.adImplRef.get();
            if (mMAdImpl != null && mMAdImpl instanceof AdViewOverlayViewMMAdImpl) {
                return mMAdImpl.isExpandingToUrl();
            }
            return false;
        }
    }

    private static class OverlayWebViewClientListener
    extends MMAdImpl.BasicWebViewClientListener {
        OverlayWebViewClientListener(MMAdImpl mMAdImpl) {
            super(mMAdImpl);
        }

        @Override
        public void onPageFinished(String string2) {
            super.onPageFinished(string2);
            MMAdImpl mMAdImpl = (MMAdImpl)this.adImplRef.get();
            if (mMAdImpl != null) {
                mMAdImpl.removeProgressBar();
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        public Object customInlineLayoutParams;
        String gson;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.gson = parcel.readString();
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeString(this.gson);
        }
    }

    private static class SetCloseButtonTouchDelegateRunnable
    implements Runnable {
        int bottom;
        private final Button closeButton;
        int left;
        int right;
        int top;

        SetCloseButtonTouchDelegateRunnable(Button button, int n2, int n3, int n4, int n5) {
            this.closeButton = button;
            this.top = n2;
            this.left = n3;
            this.bottom = n4;
            this.right = n5;
        }

        @Override
        public void run() {
            Rect rect = new Rect();
            this.closeButton.getHitRect(rect);
            rect.top += this.top;
            rect.right += this.right;
            rect.bottom += this.bottom;
            rect.left += this.left;
            TouchDelegate touchDelegate = new TouchDelegate(rect, (View)this.closeButton);
            if (View.class.isInstance(this.closeButton.getParent())) {
                ((View)this.closeButton.getParent()).setTouchDelegate(touchDelegate);
            }
        }
    }
}

