/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.millennialmedia.android.AdViewOverlayView;
import com.millennialmedia.android.BridgeMMMedia;
import com.millennialmedia.android.BridgeMMMicrophone;
import com.millennialmedia.android.MMBaseActivity;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.OverlaySettings;

class AdViewOverlayActivity
extends MMBaseActivity {
    private AdViewOverlayView adViewOverlayView;
    boolean hasFocus;
    boolean isPaused;
    private OverlaySettings settings;

    AdViewOverlayActivity() {
    }

    private void lockOrientation() {
        if (this.activity.getRequestedOrientation() == 0) {
            this.setRequestedOrientation(0);
            return;
        }
        if (this.activity.getRequestedOrientation() == 8) {
            this.setRequestedOrientation(8);
            return;
        }
        if (this.activity.getRequestedOrientation() == 9) {
            this.setRequestedOrientation(9);
            return;
        }
        this.setRequestedOrientation(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setRequestedOrientation(String string2) {
        if ("landscape".equalsIgnoreCase(string2)) {
            this.setRequestedOrientation(0);
            return;
        } else {
            if (!"portrait".equalsIgnoreCase(string2)) return;
            this.setRequestedOrientation(1);
            return;
        }
    }

    @Override
    public void finish() {
        if (this.adViewOverlayView != null) {
            if (!this.adViewOverlayView.attachWebViewToLink()) {
                this.adViewOverlayView.killWebView();
            }
            this.adViewOverlayView.removeSelfAndAll();
        }
        this.adViewOverlayView = null;
        super.finish();
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        if (this.adViewOverlayView != null) {
            this.adViewOverlayView.inlineConfigChange();
        }
        super.onConfigurationChanged(configuration);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onCreate(Bundle bundle) {
        Uri uri;
        this.setTheme(0x1030010);
        super.onCreate(bundle);
        this.requestWindowFeature(1);
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.getWindow().clearFlags(1024);
        this.getWindow().addFlags(2048);
        this.getWindow().addFlags(0x1000000);
        Intent intent = this.getIntent();
        this.settings = (OverlaySettings)intent.getParcelableExtra("settings");
        if (this.settings == null) {
            this.settings = new OverlaySettings();
        }
        this.settings.log();
        if (this.settings.orientation != null) {
            this.setRequestedOrientation(this.settings.orientation);
        }
        if (this.settings.allowOrientationChange) {
            this.unlockScreenOrientation();
        } else {
            this.lockOrientation();
        }
        if (intent != null && (uri = intent.getData()) != null) {
            Object[] objectArray = new Object[]{uri.getLastPathSegment()};
            MMSDK.Log.v("Path: %s", objectArray);
        }
        RelativeLayout relativeLayout = new RelativeLayout((Context)this.activity);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(13);
        relativeLayout.setId(885394873);
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.adViewOverlayView = new AdViewOverlayView(this, this.settings);
        relativeLayout.addView((View)this.adViewOverlayView);
        this.setContentView((View)relativeLayout);
        if (this.getLastNonConfigurationInstance() == null) {
            if (this.settings.isExpanded()) {
                if (this.adViewOverlayView.adImpl != null && this.adViewOverlayView.adImpl.controller != null && this.adViewOverlayView.adImpl.controller.webView != null) {
                    this.adViewOverlayView.adImpl.controller.webView.setMraidExpanded();
                }
                if (this.settings.hasExpandUrl()) {
                    this.adViewOverlayView.getWebContent(this.settings.urlToLoad);
                }
            } else if (!this.settings.isExpanded()) {
                this.adViewOverlayView.loadWebContent(this.settings.content, this.settings.adUrl);
            }
        }
        this.settings.orientation = null;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        MMSDK.Log.d("Overlay onDestroy");
    }

    @Override
    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (n2 == 4 && keyEvent.getRepeatCount() == 0) {
            this.adViewOverlayView.finishOverlayWithAnimation();
            return true;
        }
        return super.onKeyDown(n2, keyEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onPause() {
        this.isPaused = true;
        MMSDK.Log.d("Overlay onPause");
        BridgeMMMedia.Audio audio = BridgeMMMedia.Audio.sharedAudio((Context)this.activity);
        if (audio != null) {
            synchronized (this) {
                audio.stop();
            }
        }
        BridgeMMMicrophone.Recorder.getInstance().stopRecording();
        if (this.adViewOverlayView != null) {
            this.adViewOverlayView.pauseVideo();
            if (this.adViewOverlayView.adImpl != null && this.adViewOverlayView.adImpl.controller != null && this.adViewOverlayView.adImpl.controller.webView != null) {
                this.adViewOverlayView.adImpl.controller.webView.onPauseWebView();
            }
        }
        this.setResult(0);
        super.onPause();
    }

    @Override
    protected void onRestoreInstanceState(Bundle bundle) {
        super.onRestoreInstanceState(bundle);
    }

    @Override
    protected void onResume() {
        this.isPaused = false;
        MMSDK.Log.d("Overlay onResume");
        if (this.adViewOverlayView != null) {
            if (this.hasFocus) {
                this.adViewOverlayView.resumeVideo();
            }
            this.adViewOverlayView.addBlackView();
            if (this.adViewOverlayView.adImpl != null && this.adViewOverlayView.adImpl.controller != null && this.adViewOverlayView.adImpl.controller.webView != null) {
                this.adViewOverlayView.adImpl.controller.webView.onResumeWebView();
            }
        }
        super.onResume();
    }

    @Override
    public Object onRetainNonConfigurationInstance() {
        return this.adViewOverlayView.getNonConfigurationInstance();
    }

    @Override
    protected void onSaveInstanceState(Bundle bundle) {
        bundle.putInt("adViewId", this.adViewOverlayView.getId());
        super.onSaveInstanceState(bundle);
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    public void onWindowFocusChanged(boolean bl2) {
        super.onWindowFocusChanged(bl2);
        this.hasFocus = bl2;
        if (!this.isPaused && bl2) {
            this.adViewOverlayView.resumeVideo();
        }
    }

    void setAllowOrientationChange(boolean bl2) {
        this.settings.allowOrientationChange = bl2;
        if (bl2) {
            this.unlockScreenOrientation();
            return;
        }
        this.lockOrientation();
    }

    void setRequestedOrientationLandscape() {
        this.settings.orientation = "landscape";
        this.settings.allowOrientationChange = false;
        this.setRequestedOrientation(0);
    }

    void setRequestedOrientationPortrait() {
        this.settings.orientation = "portrait";
        this.settings.allowOrientationChange = false;
        this.setRequestedOrientation(1);
    }

    void unlockScreenOrientation() {
        this.setRequestedOrientation(-1);
    }
}

