/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.util.DisplayMetrics;
import com.millennialmedia.android.BridgeMMDevice;
import com.millennialmedia.android.MMSDK;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;

class AdProperties {
    WeakReference<Context> contextRef;

    AdProperties(Context context) {
        this.contextRef = new WeakReference<Context>(context);
    }

    private JSONObject getAd() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("height", (Object)this.getAdDpiIndependentHeight());
        jSONObject.put("width", (Object)this.getAdDpiIndependentWidth());
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    private JSONObject getPermissions() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        boolean bl2 = this.getContext().checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0;
        jSONObject.put("android.permission.ACCESS_FINE_LOCATION", bl2);
        return jSONObject;
    }

    private JSONObject getScreen() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("height", (Object)this.getScreenDpiIndependentHeight());
        jSONObject.put("width", (Object)this.getScreenDpiIndependentWidth());
        return jSONObject;
    }

    private JSONObject getSupports() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        Context context = this.getContext();
        jSONObject.put("sms", (Object)MMSDK.getSupportsSms(context));
        jSONObject.put("tel", (Object)MMSDK.getSupportsTel(context));
        jSONObject.put("calendar", (Object)"false");
        jSONObject.put("storePicture", (Object)"false");
        jSONObject.put("inlineVideo", (Object)"true");
        return jSONObject;
    }

    String getAdDpiIndependentHeight() {
        return this.getScreenDpiIndependentHeight();
    }

    String getAdDpiIndependentWidth() {
        return this.getScreenDpiIndependentWidth();
    }

    public JSONObject getAdProperties() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("screen", (Object)this.getScreen());
            jSONObject.put("ad", (Object)this.getAd());
            jSONObject.put("do", (Object)MMSDK.getOrientation(this.getContext()));
            jSONObject.put("supports", (Object)this.getSupports());
            jSONObject.put("device", (Object)BridgeMMDevice.getDeviceInfo(this.getContext()));
            jSONObject.put("permissions", (Object)this.getPermissions());
            jSONObject.put("maxSize", (Object)this.getScreen());
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return jSONObject;
        }
    }

    Context getContext() {
        return (Context)this.contextRef.get();
    }

    String getScreenDpiIndependentHeight() {
        DisplayMetrics displayMetrics = MMSDK.getMetrics(this.getContext());
        return String.valueOf((int)((float)displayMetrics.heightPixels / displayMetrics.density));
    }

    String getScreenDpiIndependentWidth() {
        DisplayMetrics displayMetrics = MMSDK.getMetrics(this.getContext());
        return String.valueOf((int)((float)displayMetrics.widthPixels / displayMetrics.density));
    }
}

