/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import com.millennialmedia.android.AdCache;
import com.millennialmedia.android.CachedAd;
import com.millennialmedia.android.HandShake;
import java.lang.ref.WeakReference;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class AdCacheThreadPool {
    private static AdCacheThreadPool sharedThreadPool;
    private ThreadPoolExecutor executor;
    private PriorityBlockingQueue queue;

    private AdCacheThreadPool() {
        PriorityBlockingQueue<Runnable> priorityBlockingQueue;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        this.queue = priorityBlockingQueue = new PriorityBlockingQueue<Runnable>(32);
        this.executor = new ThreadPoolExecutor(1, 2, 30L, timeUnit, priorityBlockingQueue);
    }

    static AdCacheThreadPool sharedThreadPool() {
        synchronized (AdCacheThreadPool.class) {
            if (sharedThreadPool == null) {
                sharedThreadPool = new AdCacheThreadPool();
            }
            AdCacheThreadPool adCacheThreadPool = sharedThreadPool;
            return adCacheThreadPool;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean startDownloadTask(Context context, String string2, CachedAd cachedAd, AdCache.AdCacheTaskListener adCacheTaskListener) {
        synchronized (this) {
            if (context == null) return false;
            if (cachedAd == null) return false;
            AdCacheTask adCacheTask = new AdCacheTask(context, string2, cachedAd, adCacheTaskListener);
            if (this.queue.contains(adCacheTask)) return false;
            if (cachedAd.isOnDisk(context)) return false;
            this.executor.execute(adCacheTask);
            return true;
        }
    }

    private class AdCacheTask
    implements Runnable,
    Comparable<AdCacheTask> {
        private CachedAd ad;
        private String adName;
        private WeakReference<Context> contextRef;
        private WeakReference<AdCache.AdCacheTaskListener> listenerRef;

        AdCacheTask(Context context, String string2, CachedAd cachedAd, AdCache.AdCacheTaskListener adCacheTaskListener) {
            this.contextRef = new WeakReference<Context>(context.getApplicationContext());
            this.adName = string2;
            this.ad = cachedAd;
            if (adCacheTaskListener != null) {
                this.listenerRef = new WeakReference<AdCache.AdCacheTaskListener>(adCacheTaskListener);
            }
        }

        @Override
        public int compareTo(AdCacheTask adCacheTask) {
            return this.ad.downloadPriority - adCacheTask.ad.downloadPriority;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AdCacheTask)) {
                return false;
            }
            AdCacheTask adCacheTask = (AdCacheTask)object;
            return this.ad.equals(adCacheTask.ad);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            WeakReference<AdCache.AdCacheTaskListener> weakReference = this.listenerRef;
            AdCache.AdCacheTaskListener adCacheTaskListener = null;
            if (weakReference != null) {
                adCacheTaskListener = (AdCache.AdCacheTaskListener)this.listenerRef.get();
            }
            if (adCacheTaskListener != null) {
                adCacheTaskListener.downloadStart(this.ad);
            }
            HandShake.sharedHandShake((Context)this.contextRef.get()).lockAdTypeDownload(this.adName);
            boolean bl2 = this.ad.download((Context)this.contextRef.get());
            HandShake.sharedHandShake((Context)this.contextRef.get()).unlockAdTypeDownload(this.adName);
            if (!bl2) {
                String string2 = AdCache.getIncompleteDownload((Context)this.contextRef.get(), this.adName);
                if (string2 != null && this.ad.getId().equals(string2)) {
                    this.ad.delete((Context)this.contextRef.get());
                    AdCache.setIncompleteDownload((Context)this.contextRef.get(), this.adName, null);
                } else {
                    Context context = (Context)this.contextRef.get();
                    String string3 = this.adName;
                    boolean bl3 = this.ad.downloadAllOrNothing;
                    String string4 = null;
                    if (!bl3) {
                        string4 = this.ad.getId();
                    }
                    AdCache.setIncompleteDownload(context, string3, string4);
                }
            } else {
                AdCache.setIncompleteDownload((Context)this.contextRef.get(), this.adName, null);
            }
            if (adCacheTaskListener != null) {
                adCacheTaskListener.downloadCompleted(this.ad, bl2);
            }
        }
    }
}

