/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import android.text.TextUtils;
import com.millennialmedia.android.AdCacheThreadPool;
import com.millennialmedia.android.CachedAd;
import com.millennialmedia.android.HandShake;
import com.millennialmedia.android.MMAdImpl;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class AdCache {
    private static final String CACHED_AD_FILE = "ad.dat";
    private static final String CACHE_INCOMPLETE_PREFIX = "incompleteDownload_";
    private static final String CACHE_PREFIX = "nextCachedAd_";
    private static final String CACHE_PREFIX_APID = "nextCachedAd_apids";
    private static final String LOCK_FILE = "ad.lock";
    static final int PRIORITY_FETCH = 3;
    static final int PRIORITY_PRECACHE = 1;
    static final int PRIORITY_REFRESH = 2;
    static final String PRIVATE_CACHE_DIR = ".mmsyscache";
    private static Set<String> apidListSet;
    private static String cachedVideoList;
    private static boolean cachedVideoListLoaded;
    private static Set<String> cachedVideoSet;
    private static Map<String, String> incompleteDownloadHashMap;
    private static boolean incompleteDownloadHashMapLoaded;
    static boolean isExternalEnabled;
    private static Map<String, String> nextCachedAdHashMap;
    private static boolean nextCachedAdHashMapLoaded;

    static {
        isExternalEnabled = true;
    }

    private AdCache() {
    }

    static void cachedVideoWasAdded(Context context, String string2) {
        synchronized (AdCache.class) {
            if (string2 != null) {
                if (!cachedVideoListLoaded) {
                    AdCache.getCachedVideoList(context);
                }
                if (cachedVideoSet == null) {
                    cachedVideoSet = new HashSet<String>();
                }
                cachedVideoSet.add(string2);
                cachedVideoList = null;
            }
            return;
            finally {
            }
        }
    }

    static void cachedVideoWasRemoved(Context context, String string2) {
        synchronized (AdCache.class) {
            block6: {
                if (string2 != null) {
                    if (!cachedVideoListLoaded) {
                        AdCache.getCachedVideoList(context);
                    }
                    if (cachedVideoSet == null) break block6;
                    cachedVideoSet.remove(string2);
                    cachedVideoList = null;
                }
            }
            return;
            finally {
            }
        }
    }

    static void cleanCache(final Context context) {
        Utils.ThreadUtils.execute(new Runnable(){

            @Override
            public void run() {
                MMSDK.Log.d("AdCache");
                AdCache.cleanUpExpiredAds(context);
                AdCache.cleanupCache(context);
            }
        });
    }

    static void cleanUpExpiredAds(final Context context) {
        AdCache.iterateCachedAds(context, 1, new Iterator(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            boolean callback(String string2, int n2, Date date, String string3, long l2, ObjectInputStream objectInputStream) {
                if (date == null || date.getTime() > System.currentTimeMillis()) return true;
                try {
                    CachedAd cachedAd = (CachedAd)objectInputStream.readObject();
                    Object[] objectArray = new Object[]{cachedAd.getId()};
                    MMSDK.Log.d("Deleting expired ad %s.", objectArray);
                    cachedAd.delete(context);
                }
                catch (Exception exception) {
                    MMSDK.Log.d("There was a problem reading the cached ad %s.", string2);
                    MMSDK.Log.d(exception);
                    return true;
                }
                return true;
            }
        });
    }

    static void cleanupCache(Context context) {
        AdCache.cleanupInternalCache(context);
        if (AdCache.isExternalStorageAvailable(context)) {
            AdCache.cleanupExternalCache(context);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void cleanupDirectory(File file, long l2) {
        File[] fileArray = file.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file2 = fileArray[n3];
            if (file2.isFile()) {
                if (System.currentTimeMillis() - file2.lastModified() > l2) {
                    file2.delete();
                }
            } else if (file2.isDirectory()) {
                try {
                    AdCache.cleanupDirectory(file2, l2);
                    if (file2.list().length == 0) {
                        file2.delete();
                    }
                }
                catch (SecurityException securityException) {}
            }
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void cleanupExternalCache(Context context) {
        File file = AdCache.getExternalCacheDirectory(context);
        if (file == null || !file.exists() || !file.isDirectory()) {
            return;
        }
        AdCache.cleanupDirectory(file, HandShake.sharedHandShake((Context)context).creativeCacheTimeout);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void cleanupInternalCache(Context context) {
        File file = AdCache.getInternalCacheDirectory(context);
        if (file == null || !file.exists() || !file.isDirectory()) {
            return;
        }
        AdCache.cleanupDirectory(file, HandShake.sharedHandShake((Context)context).creativeCacheTimeout);
    }

    static boolean deleteFile(Context context, String string2) {
        File file = AdCache.getCachedAdFile(context, string2);
        if (file != null) {
            return file.delete();
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    static boolean downloadComponent(String var0, String var1_1, File var2_2, Context var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 11[TRYBLOCK] [21, 22 : 381->392)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean downloadComponentToCache(String string2, String string3, Context context) {
        return AdCache.downloadComponent(string2, string3, AdCache.getCacheDirectory(context), context);
    }

    static File getCacheDirectory(Context context) {
        if (AdCache.isExternalStorageAvailable(context)) {
            return AdCache.getExternalCacheDirectory(context);
        }
        return AdCache.getInternalCacheDirectory(context);
    }

    private static File getCachedAdFile(Context context, String string2) {
        File file;
        block10: {
            boolean bl2;
            File file2;
            boolean bl3;
            String string3;
            block9: {
                string3 = string2 + CACHED_AD_FILE;
                bl3 = AdCache.isExternalStorageAvailable(context);
                File file3 = AdCache.getCacheDirectory(context);
                file = null;
                if (file3 != null) {
                    boolean bl4 = file3.isDirectory();
                    file = null;
                    if (!bl4) break block9;
                    file = new File(file3, string3);
                }
            }
            if (file != null) {
                if (file.exists()) break block10;
            }
            if (bl3) break block10;
            try {
                file2 = context.getFilesDir();
                if (file2 == null) break block10;
            }
            catch (Exception exception) {
                MMSDK.Log.e(exception);
                return null;
            }
            File file4 = new File(file2, PRIVATE_CACHE_DIR + File.separator + string3);
            if (file4.exists() && (bl2 = file4.isFile())) {
                return file4;
            }
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getCachedVideoList(final Context context) {
        synchronized (AdCache.class) {
            if (cachedVideoList != null) return cachedVideoList;
            if (!cachedVideoListLoaded) {
                final HashSet<String> hashSet = new HashSet<String>();
                AdCache.iterateCachedAds(context, 2, new Iterator(){

                    @Override
                    boolean callback(CachedAd cachedAd) {
                        if (cachedAd.acid != null && cachedAd.getType() == 1 && cachedAd.isOnDisk(context)) {
                            hashSet.add(cachedAd.acid);
                        }
                        return true;
                    }
                });
                cachedVideoSet = hashSet;
                cachedVideoListLoaded = true;
            }
            if (cachedVideoSet == null) return cachedVideoList;
            if (cachedVideoSet.size() <= 0) return cachedVideoList;
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : cachedVideoSet) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("," + string2);
                    continue;
                }
                stringBuilder.append(string2);
            }
            cachedVideoList = stringBuilder.toString();
            return cachedVideoList;
        }
    }

    static File getDownloadFile(Context context, String string2) {
        File file = AdCache.getCacheDirectory(context);
        File file2 = null;
        if (file != null) {
            file2 = new File(file, string2);
        }
        return file2;
    }

    private static File getExternalCacheDirectory(Context context) {
        File file = Environment.getExternalStorageDirectory();
        File file2 = null;
        if (file != null && !(file2 = new File(file, PRIVATE_CACHE_DIR)).exists() && !file2.mkdirs()) {
            file2 = null;
        }
        return file2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getIncompleteDownload(Context context, String string2) {
        synchronized (AdCache.class) {
            block7: {
                if (!incompleteDownloadHashMapLoaded) {
                    AdCache.loadIncompleteDownloadHashMap(context);
                }
                if (string2 != null) break block7;
                return null;
            }
            String string3 = incompleteDownloadHashMap.get(string2);
            return string3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static File getInternalCacheDirectory(Context context) {
        if (context == null) {
            return null;
        }
        File file = new File(context.getFilesDir(), PRIVATE_CACHE_DIR);
        if (file == null) return file;
        if (file.exists()) return file;
        if (file.mkdirs()) return file;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getNextCachedAd(Context context, String string2) {
        synchronized (AdCache.class) {
            block7: {
                if (!nextCachedAdHashMapLoaded) {
                    AdCache.loadNextCachedAdHashMap(context);
                }
                if (string2 != null) break block7;
                return null;
            }
            String string3 = nextCachedAdHashMap.get(string2);
            return string3;
        }
    }

    static boolean hasDownloadFile(Context context, String string2) {
        File file = AdCache.getDownloadFile(context, string2);
        return file != null && file.exists();
    }

    static boolean isExternalMounted() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean isExternalStorageAvailable(Context context) {
        block3: {
            block2: {
                if (context == null) break block2;
                String string2 = Environment.getExternalStorageState();
                if (context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0 && !TextUtils.isEmpty((CharSequence)string2) && string2.equals("mounted") && isExternalEnabled) break block3;
            }
            return false;
        }
        return true;
    }

    static boolean isInternalDir(Context context, File file) {
        File file2 = AdCache.getInternalCacheDirectory(context);
        return file2 != null && file2.equals(file);
    }

    /*
     * Unable to fully structure code
     */
    static void iterateCachedAds(Context var0, int var1_1, Iterator var2_2) {
        var3_3 = AdCache.getCacheDirectory(var0);
        if (var3_3 == null || (var4_4 = var3_3.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && file.getName().endsWith(AdCache.CACHED_AD_FILE);
            }
        })) == null) ** GOTO lbl29
        var5_5 = var4_4.length;
        var7_7 = null;
        block27: for (var6_6 = 0; var6_6 < var5_5; ++var6_6) {
            block39: {
                block38: {
                    block37: {
                        block40: {
                            block36: {
                                block35: {
                                    var9_8 = var4_4[var6_6];
                                    if (var9_8 != null) {
                                        var17_16 = var9_8.exists();
                                        if (var17_16) break block35;
                                    }
                                    if (var7_7 == null) break block39;
                                    try {
                                        var7_7.close();
                                        var10_9 = null;
                                    }
                                    catch (IOException var11_10) {
                                        var10_9 = var7_7;
                                    }
lbl15:
                                    // 10 sources

                                    while (true) {
                                        var7_7 = var10_9;
                                        continue block27;
                                        break;
                                    }
                                    ** GOTO lbl15
                                }
                                if (var1_1 != 0) break block40;
                                var26_22 = var2_2.callback(var9_8.getName());
                                if (var26_22) break block36;
                                if (var7_7 == null) break;
                                try {
                                    var7_7.close();
                                }
                                catch (IOException var28_24) {
                                }
lbl29:
                                // 10 sources

                                while (true) {
                                    var2_2.done();
                                    return;
                                }
                            }
                            if (var7_7 == null) break block39;
                            try {
                                var7_7.close();
                                var10_9 = null;
                            }
                            catch (IOException var27_23) {
                                var10_9 = var7_7;
                            }
                            ** GOTO lbl15
                        }
                        var10_9 = new ObjectInputStream(new FileInputStream(var9_8));
                        var18_17 = var10_9.readInt();
                        var19_18 = (Date)var10_9.readObject();
                        var20_19 = (String)var10_9.readObject();
                        var21_20 = var10_9.readLong();
                        if (var1_1 != 1) break block37;
                        if (var2_2.callback(var9_8.getName(), var18_17, var19_18, var20_19, var21_20, var10_9)) break block38;
                        var10_9.close();
                        if (!false) ** GOTO lbl29
                        null.close();
                    }
                    if (var2_2.callback((CachedAd)var10_9.readObject())) break block38;
                    var10_9.close();
                    if (!false) ** GOTO lbl29
                    null.close();
                }
                if (var10_9 == null) ** GOTO lbl15
                var10_9.close();
                var10_9 = null;
                catch (Exception var14_12) {
                    var10_9 = var7_7;
lbl76:
                    // 2 sources

                    while (true) {
                        var15_14 = new Object[]{var9_8.getName()};
                        MMSDK.Log.d("There was a problem reading the cached ad %s.", var15_14);
                        MMSDK.Log.d((Throwable)var14_11);
                        if (var10_9 == null) ** GOTO lbl15
                        var10_9.close();
                        var10_9 = null;
                        break;
                    }
                }
                catch (Throwable var12_25) {
                    var10_9 = var7_7;
lbl88:
                    // 2 sources

                    while (true) {
                        if (var10_9 != null) {
                            var10_9.close();
                        }
lbl92:
                        // 4 sources

                        throw var12_26;
                    }
                }
                catch (IOException var24_28) {}
                ** GOTO lbl29
                catch (IOException var25_29) {}
                ** GOTO lbl29
                catch (IOException var23_21) {}
                ** GOTO lbl15
                {
                    catch (IOException var16_15) {}
                }
                {
                    catch (IOException var13_30) {
                        ** continue;
                    }
                }
                {
                    catch (Throwable var12_27) {
                        ** continue;
                    }
                }
                catch (Exception var14_13) {
                    ** continue;
                }
            }
            var10_9 = var7_7;
            ** continue;
        }
        ** while (true)
    }

    /*
     * Unable to fully structure code
     */
    static CachedAd load(Context var0, String var1_1) {
        block26: {
            if (var1_1 == null || var1_1.equals("")) lbl-1000:
            // 3 sources

            {
                return null;
            }
            var2_2 = null;
            var3_3 = AdCache.getCachedAdFile(var0, var1_1);
            if (var3_3 == null) {
                return null;
            }
            var4_4 = new ObjectInputStream(new FileInputStream(var3_3));
            var4_4.readInt();
            (Date)var4_4.readObject();
            var4_4.readObject();
            var4_4.readLong();
            var16_5 = (CachedAd)var4_4.readObject();
            if (var4_4 == null) break block26;
            try {
                var4_4.close();
            }
            catch (IOException var17_6) {
                return var16_5;
            }
        }
        return var16_5;
        catch (FileNotFoundException var18_7) lbl-1000:
        // 2 sources

        {
            while (true) {
                MMSDK.Log.e("There was a problem loading up the cached ad %s. Ad is not on disk.", new Object[]{var1_1});
                if (var2_2 == null) ** GOTO lbl-1000
                try {
                    var2_2.close();
                    return null;
                }
                catch (IOException var8_8) {
                    return null;
                }
                break;
            }
        }
        catch (Exception var9_9) lbl-1000:
        // 2 sources

        {
            while (true) {
                MMSDK.Log.e("There was a problem loading up the cached ad %s.", new Object[]{var1_1});
                MMSDK.Log.d(var9_10.getMessage());
                MMSDK.Log.d((Throwable)var9_10);
                if (var2_2 == null) ** continue;
                {
                    catch (Throwable var6_13) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var2_2 != null) {
                                var2_2.close();
                            }
lbl49:
                            // 4 sources

                            throw var6_14;
                            catch (IOException var7_16) {
                                ** continue;
                            }
                            break;
                        }
                    }
                }
                try {
                    var2_2.close();
                    return null;
                }
                catch (IOException var10_12) {
                    return null;
                }
                break;
            }
        }
        catch (Throwable var6_15) {
            var2_2 = var4_4;
            ** continue;
        }
        catch (Exception var9_11) {
            var2_2 = var4_4;
            ** continue;
        }
        catch (FileNotFoundException var5_17) {
            var2_2 = var4_4;
            ** continue;
        }
    }

    private static void loadApidListSet(SharedPreferences sharedPreferences) {
        String[] stringArray;
        apidListSet = new HashSet<String>();
        String string2 = sharedPreferences.getString(CACHE_PREFIX_APID, null);
        if (string2 != null && (stringArray = string2.split(MMSDK.COMMA)) != null && stringArray.length > 0) {
            for (String string3 : stringArray) {
                apidListSet.add(string3);
            }
        }
    }

    static CachedAd loadIncompleteDownload(Context context, String string2) {
        String string3 = AdCache.getIncompleteDownload(context, string2);
        if (string3 == null) {
            return null;
        }
        return AdCache.load(context, string3);
    }

    private static void loadIncompleteDownloadHashMap(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("MillennialMediaSettings", 0);
        incompleteDownloadHashMap = new ConcurrentHashMap<String, String>();
        if (apidListSet == null) {
            AdCache.loadApidListSet(sharedPreferences);
        }
        for (String string2 : apidListSet) {
            for (String string3 : MMAdImpl.getAdTypes()) {
                String string4 = sharedPreferences.getString(CACHE_INCOMPLETE_PREFIX + string3 + '_' + string2, null);
                if (string4 == null) continue;
                incompleteDownloadHashMap.put(string3 + '_' + string2, string4);
            }
        }
        incompleteDownloadHashMapLoaded = true;
    }

    static CachedAd loadNextCachedAd(Context context, String string2) {
        String string3 = AdCache.getNextCachedAd(context, string2);
        if (string3 == null || string3.equals("")) {
            return null;
        }
        return AdCache.load(context, string3);
    }

    private static void loadNextCachedAdHashMap(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("MillennialMediaSettings", 0);
        nextCachedAdHashMap = new ConcurrentHashMap<String, String>();
        if (apidListSet == null) {
            AdCache.loadApidListSet(sharedPreferences);
        }
        for (String string2 : apidListSet) {
            for (String string3 : MMAdImpl.getAdTypes()) {
                String string4 = sharedPreferences.getString(CACHE_PREFIX + string3 + '_' + string2, null);
                if (string4 == null) continue;
                nextCachedAdHashMap.put(string3 + '_' + string2, string4);
            }
        }
        nextCachedAdHashMapLoaded = true;
    }

    static void resetCache(final Context context) {
        AdCache.iterateCachedAds(context, 2, new Iterator(){

            @Override
            boolean callback(CachedAd cachedAd) {
                Object[] objectArray = new Object[]{cachedAd.getId()};
                MMSDK.Log.d("Deleting ad %s.", objectArray);
                cachedAd.delete(context);
                return true;
            }
        });
        cachedVideoSet = null;
        cachedVideoList = null;
        cachedVideoListLoaded = false;
        if (nextCachedAdHashMap != null) {
            java.util.Iterator<String> iterator = nextCachedAdHashMap.keySet().iterator();
            while (iterator.hasNext()) {
                AdCache.setNextCachedAd(context, iterator.next(), null);
            }
        }
        if (incompleteDownloadHashMap != null) {
            java.util.Iterator<String> iterator = incompleteDownloadHashMap.keySet().iterator();
            while (iterator.hasNext()) {
                AdCache.setIncompleteDownload(context, iterator.next(), null);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean save(Context var0, CachedAd var1_1) {
        var2_2 = null;
        var3_3 = null;
        if (var1_1 == null) {
            return false;
        }
        var4_4 = AdCache.getCachedAdFile(var0, var1_1.getId());
        if (var4_4 == null) return false;
        var5_5 = new Object[]{var1_1.getId(), var4_4};
        MMSDK.Log.v("Saving CachedAd %s to %s", var5_5);
        var6_6 = new File(var4_4.getParent(), var1_1.getId() + "ad.lock");
        if (var6_6.createNewFile()) ** GOTO lbl-1000
        var17_7 = new Object[]{var1_1.getId()};
        MMSDK.Log.v("Could not save the cached ad %s. Ad was locked.", var17_7);
        try {}
        catch (IOException var18_21) {
            return false;
        }
        ** GOTO lbl56
lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var1_1.saveAssets(var0) != false) return true;
                var1_1.delete(var0);
                return false;
            }
lbl-1000:
            // 2 sources

            {
                while (true) {
                    try {
                        var11_13 = new Object[]{var1_1.getId()};
                        MMSDK.Log.e("There was a problem saving the cached ad %s.", var11_13);
                        MMSDK.Log.d(var7_10.getMessage());
                        MMSDK.Log.d((Throwable)var7_10);
                        ** GOTO lbl40
                    }
                    catch (Throwable var8_15) lbl-1000:
                    // 3 sources

                    {
                        while (true) {
                            try {
                                var2_2.delete();
                                if (var3_3 == null) throw var8_16;
                                var3_3.close();
                                throw var8_16;
                            }
                            catch (IOException var9_19) {
                                throw var8_16;
                            }
                            break;
                        }
lbl40:
                        // 1 sources

                        try {
                            var2_2.delete();
                            if (var3_3 == null) return false;
                            var3_3.close();
                            return false;
                        }
                        catch (IOException var12_14) {
                            return false;
                        }
                    }
                    break;
                }
            }
            catch (Throwable var8_17) {
                var2_2 = var6_6;
                var3_3 = null;
                ** GOTO lbl-1000
            }
            catch (Exception var7_11) {
                var2_2 = var6_6;
                var3_3 = null;
                ** GOTO lbl-1000
            }
lbl56:
            // 1 sources

            var6_6.delete();
            return false;
lbl-1000:
            // 1 sources

            {
                var14_8 = new ObjectOutputStream(new FileOutputStream(var4_4));
            }
            var14_8.writeInt(var1_1.getType());
            var14_8.writeObject(var1_1.expiration);
            var14_8.writeObject(var1_1.acid);
            var14_8.writeLong(var1_1.deferredViewStart);
            var14_8.writeObject(var1_1);
            var6_6.delete();
            if (var14_8 == null) ** GOTO lbl-1000
            var14_8.close();
            ** continue;
        }
        catch (Exception var7_9) {}
        ** while (true)
        catch (Throwable var8_18) {
            var3_3 = var14_8;
            var2_2 = var6_6;
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void saveApidListSet(SharedPreferences.Editor editor, String string2) {
        String string3;
        int n2 = string2.indexOf(95);
        if (n2 >= 0 && n2 < string2.length() && (string3 = string2.substring(n2 + 1)) != null && !apidListSet.contains(string3)) {
            boolean bl2 = apidListSet.isEmpty();
            StringBuilder stringBuilder = null;
            if (!bl2) {
                java.util.Iterator<String> iterator = apidListSet.iterator();
                stringBuilder = new StringBuilder();
                while (iterator.hasNext()) {
                    stringBuilder.append(iterator.next() + MMSDK.COMMA);
                }
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            String string4 = stringBuilder == null ? "" : stringBuilder.toString();
            editor.putString(CACHE_PREFIX_APID, stringBuilder2.append(string4).append(string3).toString());
            apidListSet.add(string3);
        }
    }

    private static void saveIncompleteDownloadHashMap(Context context, String string2) {
        if (string2 != null) {
            SharedPreferences.Editor editor = context.getSharedPreferences("MillennialMediaSettings", 0).edit();
            AdCache.saveApidListSet(editor, string2);
            editor.putString(CACHE_INCOMPLETE_PREFIX + string2, incompleteDownloadHashMap.get(string2));
            editor.commit();
        }
    }

    private static void saveNextCachedAdHashMapValue(Context context, String string2) {
        if (string2 != null) {
            SharedPreferences.Editor editor = context.getSharedPreferences("MillennialMediaSettings", 0).edit();
            AdCache.saveApidListSet(editor, string2);
            editor.putString(CACHE_PREFIX + string2, nextCachedAdHashMap.get(string2));
            editor.commit();
        }
    }

    static void setEnableExternalStorage(boolean bl2) {
        isExternalEnabled = bl2;
    }

    static void setIncompleteDownload(Context context, String string2, String string3) {
        synchronized (AdCache.class) {
            block7: {
                Map<String, String> map;
                block8: {
                    if (!incompleteDownloadHashMapLoaded) {
                        AdCache.loadIncompleteDownloadHashMap(context);
                    }
                    if (string2 == null) break block7;
                    map = incompleteDownloadHashMap;
                    if (string3 != null) break block8;
                    string3 = "";
                }
                map.put(string2, string3);
                AdCache.saveIncompleteDownloadHashMap(context, string2);
            }
            return;
            finally {
            }
        }
    }

    static void setNextCachedAd(Context context, String string2, String string3) {
        synchronized (AdCache.class) {
            block7: {
                Map<String, String> map;
                block8: {
                    if (!nextCachedAdHashMapLoaded) {
                        AdCache.loadNextCachedAdHashMap(context);
                    }
                    if (string2 == null) break block7;
                    map = nextCachedAdHashMap;
                    if (string3 != null) break block8;
                    string3 = "";
                }
                map.put(string2, string3);
                AdCache.saveNextCachedAdHashMapValue(context, string2);
            }
            return;
            finally {
            }
        }
    }

    static boolean startDownloadTask(Context context, String string2, CachedAd cachedAd, AdCacheTaskListener adCacheTaskListener) {
        return AdCacheThreadPool.sharedThreadPool().startDownloadTask(context, string2, cachedAd, adCacheTaskListener);
    }

    static interface AdCacheTaskListener {
        public void downloadCompleted(CachedAd var1, boolean var2);

        public void downloadStart(CachedAd var1);
    }

    static class Iterator {
        static final int ITERATE_ID = 0;
        static final int ITERATE_INFO = 1;
        static final int ITERATE_OBJECT = 2;

        Iterator() {
        }

        boolean callback(CachedAd cachedAd) {
            return false;
        }

        boolean callback(String string2) {
            return false;
        }

        boolean callback(String string2, int n2, Date date, String string3, long l2, ObjectInputStream objectInputStream) {
            return false;
        }

        void done() {
        }
    }
}

