/*
 * Decompiled with CFR 0.152.
 */
package com.manuelpeinado.multichoiceadapter;

import android.app.ListActivity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.ListView;
import com.manuelpeinado.multichoiceadapter.ItemClickInActionModePolicy;
import com.manuelpeinado.multichoiceadapter.MultiChoiceAdapter;
import com.manuelpeinado.multichoiceadapter.MultiChoiceBaseAdapter;
import com.manuelpeinado.multichoiceadapter.R;
import java.util.HashSet;
import java.util.Set;

public abstract class MultiChoiceAdapterHelperBase
implements AdapterView.OnItemLongClickListener,
AdapterView.OnItemClickListener,
CompoundButton.OnCheckedChangeListener {
    private static final String BUNDLE_KEY = "mca__selection";
    protected static final String TAG = MultiChoiceAdapterHelperBase.class.getSimpleName();
    protected AdapterView<? super MultiChoiceBaseAdapter> adapterView;
    private Set<Long> checkedItems = new HashSet<Long>();
    private boolean ignoreCheckedListener;
    private ItemClickInActionModePolicy itemClickInActionModePolicy = null;
    private AdapterView.OnItemClickListener itemClickListener;
    private Boolean itemIncludesCheckBox;
    protected BaseAdapter owner;

    protected MultiChoiceAdapterHelperBase(BaseAdapter baseAdapter) {
        this.owner = baseAdapter;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int correctPositionAccountingForHeader(AdapterView<?> adapterView, int n2) {
        ListView listView = adapterView instanceof ListView ? (ListView)adapterView : null;
        int n3 = listView == null ? 0 : listView.getHeaderViewsCount();
        if (n3 > 0) {
            n2 -= listView.getHeaderViewsCount();
        }
        return n2;
    }

    private void initItemCheckbox(int n2, ViewGroup viewGroup) {
        CheckBox checkBox = (CheckBox)viewGroup.findViewById(0x1020001);
        boolean bl2 = this.isChecked(n2);
        checkBox.setTag((Object)n2);
        checkBox.setChecked(bl2);
        checkBox.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean itemIncludesCheckBox(View view) {
        block6: {
            block5: {
                if (this.itemIncludesCheckBox != null) break block5;
                if (view instanceof ViewGroup) break block6;
                this.itemIncludesCheckBox = false;
            }
            return this.itemIncludesCheckBox;
        }
        View view2 = ((ViewGroup)view).findViewById(0x1020001);
        boolean bl2 = false;
        if (view2 != null) {
            bl2 = true;
        }
        this.itemIncludesCheckBox = bl2;
        return this.itemIncludesCheckBox;
    }

    private void onItemSelectedStateChanged() {
        int n2 = this.getCheckedItemCount();
        if (n2 == 0) {
            this.finishActionMode();
            return;
        }
        Resources resources = this.adapterView.getResources();
        int n3 = R.plurals.selected_items;
        Object[] objectArray = new Object[]{n2};
        this.setActionModeTitle(resources.getQuantityString(n3, n2, objectArray));
    }

    private void parseAttrs() {
        Context context = this.getContext();
        int n2 = R.attr.multiChoiceAdapterStyle;
        int n3 = R.style.MultiChoiceAdapter_DefaultSelectedItemStyle;
        TypedArray typedArray = context.obtainStyledAttributes(null, R.styleable.MultiChoiceAdapter, n2, n3);
        if (this.itemClickInActionModePolicy == null) {
            int n4 = typedArray.getInt(0, ItemClickInActionModePolicy.SELECT.ordinal());
            this.itemClickInActionModePolicy = ItemClickInActionModePolicy.values()[n4];
        }
        typedArray.recycle();
    }

    public void checkActivity() {
        if (this.adapterView.getContext() instanceof ListActivity) {
            throw new RuntimeException("ListView cannot belong to an activity which subclasses ListActivity");
        }
    }

    public void checkItem(long l2) {
        if (this.isChecked(l2)) {
            return;
        }
        if (!this.isActionModeStarted()) {
            this.startActionMode();
        }
        this.checkedItems.add(l2);
        this.owner.notifyDataSetChanged();
        this.onItemSelectedStateChanged();
    }

    protected abstract void clearActionMode();

    protected abstract void finishActionMode();

    public int getCheckedItemCount() {
        return this.checkedItems.size();
    }

    public Set<Long> getCheckedItems() {
        return new HashSet<Long>(this.checkedItems);
    }

    public Context getContext() {
        return this.adapterView.getContext();
    }

    public ItemClickInActionModePolicy getItemClickInActionModePolicy() {
        return this.itemClickInActionModePolicy;
    }

    public View getView(int n2, View view) {
        if (view instanceof Checkable) {
            boolean bl2 = this.isChecked(this.positionToSelectionHandle(n2));
            this.ignoreCheckedListener = true;
            ((Checkable)view).setChecked(bl2);
            this.ignoreCheckedListener = false;
        }
        if (this.itemIncludesCheckBox(view)) {
            this.initItemCheckbox(n2, (ViewGroup)view);
        }
        return view;
    }

    protected abstract boolean isActionModeStarted();

    public boolean isChecked(long l2) {
        return this.checkedItems.contains(l2);
    }

    public void onCheckedChanged(CompoundButton compoundButton, boolean bl2) {
        if (this.ignoreCheckedListener) {
            return;
        }
        this.setItemChecked(((Integer)compoundButton.getTag()).intValue(), bl2);
    }

    public void onDestroyActionMode() {
        this.checkedItems.clear();
        this.clearActionMode();
        this.owner.notifyDataSetChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
        if (this.isActionModeStarted()) {
            switch (1.$SwitchMap$com$manuelpeinado$multichoiceadapter$ItemClickInActionModePolicy[this.itemClickInActionModePolicy.ordinal()]) {
                default: {
                    throw new RuntimeException("Invalid \"itemClickInActionMode\" value: " + (Object)((Object)this.itemClickInActionModePolicy));
                }
                case 1: {
                    this.onItemLongClick(adapterView, view, n2, l2);
                    return;
                }
                case 2: {
                    this.finishActionMode();
                }
            }
        }
        if (this.itemClickListener == null) return;
        this.itemClickListener.onItemClick(adapterView, view, n2, l2);
    }

    public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n2, long l2) {
        if (!((MultiChoiceAdapter)this.owner).isItemCheckable(n2)) {
            return false;
        }
        long l3 = this.positionToSelectionHandle(this.correctPositionAccountingForHeader(adapterView, n2));
        boolean bl2 = this.isChecked(l3);
        boolean bl3 = false;
        if (!bl2) {
            bl3 = true;
        }
        this.setItemChecked(l3, bl3);
        return true;
    }

    protected long positionToSelectionHandle(int n2) {
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void restoreSelectionFromSavedInstanceState(Bundle bundle) {
        if (bundle != null) {
            long[] lArray = bundle.getLongArray(BUNDLE_KEY);
            this.checkedItems.clear();
            for (long l2 : lArray) {
                this.checkedItems.add(l2);
            }
        }
    }

    public void save(Bundle bundle) {
        long[] lArray = new long[this.checkedItems.size()];
        int n2 = 0;
        for (Long l2 : this.checkedItems) {
            int n3 = n2 + 1;
            lArray[n2] = l2;
            n2 = n3;
        }
        bundle.putLongArray(BUNDLE_KEY, lArray);
    }

    protected abstract void setActionModeTitle(String var1);

    public void setAdapterView(AdapterView<? super BaseAdapter> adapterView) {
        this.adapterView = adapterView;
        this.checkActivity();
        adapterView.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this);
        adapterView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        adapterView.setAdapter((Adapter)this.owner);
        this.parseAttrs();
        if (!this.checkedItems.isEmpty()) {
            this.startActionMode();
            this.onItemSelectedStateChanged();
        }
    }

    public void setItemChecked(long l2, boolean bl2) {
        if (bl2) {
            this.checkItem(l2);
            return;
        }
        this.uncheckItem(l2);
    }

    public void setItemClickInActionModePolicy(ItemClickInActionModePolicy itemClickInActionModePolicy) {
        this.itemClickInActionModePolicy = itemClickInActionModePolicy;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.itemClickListener = onItemClickListener;
    }

    protected abstract void startActionMode();

    public void uncheckItem(long l2) {
        if (!this.isChecked(l2)) {
            return;
        }
        this.checkedItems.remove(l2);
        if (this.getCheckedItemCount() == 0) {
            this.finishActionMode();
            return;
        }
        this.owner.notifyDataSetChanged();
        this.onItemSelectedStateChanged();
    }
}

