/*
 * Decompiled with CFR 0.152.
 */
package com.manuelpeinado.multichoiceadapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.RelativeLayout;
import com.manuelpeinado.multichoiceadapter.R;

public class CheckableRelativeLayout
extends RelativeLayout
implements Checkable {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private boolean mChecked;

    public CheckableRelativeLayout(Context context) {
        this(context, null);
        this.init();
    }

    public CheckableRelativeLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    private void init() {
        if (this.getBackground() == null) {
            this.setBackgroundResource(R.drawable.mca__list_item_selector);
        }
    }

    private void setCheckedRecursive(ViewGroup viewGroup, boolean bl2) {
        int n2 = viewGroup.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = viewGroup.getChildAt(i2);
            if (view instanceof Checkable) {
                ((Checkable)view).setChecked(bl2);
            }
            if (!(view instanceof ViewGroup)) continue;
            this.setCheckedRecursive((ViewGroup)view, bl2);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable2 = this.getBackground();
        if (drawable2 != null) {
            drawable2.setState(this.getDrawableState());
            this.invalidate();
        }
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    protected int[] onCreateDrawableState(int n2) {
        int[] nArray = super.onCreateDrawableState(n2 + 1);
        if (this.isChecked()) {
            CheckableRelativeLayout.mergeDrawableStates((int[])nArray, (int[])CHECKED_STATE_SET);
        }
        return nArray;
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return this.onTouchEvent(motionEvent);
    }

    public boolean performClick() {
        this.toggle();
        return super.performClick();
    }

    public void setChecked(boolean bl2) {
        if (this.mChecked != bl2) {
            this.mChecked = bl2;
            this.refreshDrawableState();
            this.setCheckedRecursive((ViewGroup)this, bl2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void toggle() {
        boolean bl2 = !this.mChecked;
        this.setChecked(bl2);
    }
}

