/*
 * Decompiled with CFR 0.152.
 */
package com.manuelpeinado.multichoiceadapter;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.widget.Checkable;
import android.widget.ImageView;
import com.manuelpeinado.multichoiceadapter.R;

public class CheckableImageView
extends ImageView
implements Checkable {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private boolean mChecked;
    private StateListDrawable stateList;

    public CheckableImageView(Context context) {
        super(context);
    }

    public CheckableImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CheckableImageView, R.attr.checkableImageViewStyle, R.style.MultiChoiceAdapter_DefaultCheckableImageViewStyle);
        this.stateList = (StateListDrawable)typedArray.getDrawable(0);
        typedArray.recycle();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.stateList != null) {
            int[] nArray = this.getDrawableState();
            this.stateList.setState(nArray);
            this.invalidate();
        }
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public int[] onCreateDrawableState(int n2) {
        int[] nArray = super.onCreateDrawableState(n2 + 1);
        if (this.isChecked()) {
            CheckableImageView.mergeDrawableStates((int[])nArray, (int[])CHECKED_STATE_SET);
        }
        return nArray;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.stateList != null) {
            this.stateList.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            this.stateList.draw(canvas);
        }
    }

    public void setChecked(boolean bl2) {
        if (this.mChecked != bl2) {
            this.mChecked = bl2;
            this.refreshDrawableState();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void toggle() {
        boolean bl2 = !this.isChecked();
        this.setChecked(bl2);
    }
}

