/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.http;

import android.net.Uri;
import android.net.http.AndroidHttpClient;
import android.os.AsyncTask;
import com.codebutler.android_websockets.WebSocketClient;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

public class AsyncHttpClient {
    private String readToEnd(InputStream inputStream) throws IOException {
        return new String(this.readToEndAsArray(inputStream));
    }

    private byte[] readToEndAsArray(InputStream inputStream) throws IOException {
        int n2;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = dataInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void executeString(final SocketIORequest socketIORequest, final StringCallback stringCallback) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... voidArray) {
                AndroidHttpClient androidHttpClient = AndroidHttpClient.newInstance((String)"android-websockets-2.0");
                HttpPost httpPost = new HttpPost(socketIORequest.getUri());
                try {
                    HttpResponse httpResponse = androidHttpClient.execute((HttpUriRequest)httpPost);
                    String string2 = AsyncHttpClient.this.readToEnd(httpResponse.getEntity().getContent());
                    if (stringCallback != null) {
                        stringCallback.onCompleted(null, string2);
                    }
                    return null;
                }
                catch (IOException iOException) {
                    if (stringCallback != null) {
                        stringCallback.onCompleted(iOException, null);
                    }
                    return null;
                }
                finally {
                    androidHttpClient.close();
                }
            }
        }.execute((Object[])new Void[0]);
    }

    public static class SocketIORequest {
        private String mEndpoint;
        private String mUri;

        public SocketIORequest(String string2) {
            this(string2, null);
        }

        public SocketIORequest(String string2, String string3) {
            this.mUri = Uri.parse((String)string2).buildUpon().encodedPath("/socket.io/1/").build().toString();
            this.mEndpoint = string3;
        }

        public String getEndpoint() {
            return this.mEndpoint;
        }

        public String getUri() {
            return this.mUri;
        }
    }

    public static interface StringCallback {
        public void onCompleted(Exception var1, String var2);
    }

    public static interface WebSocketConnectCallback {
        public void onCompleted(Exception var1, WebSocketClient var2);
    }
}

