/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.socketio;

import android.os.Handler;
import android.text.TextUtils;
import com.codebutler.android_websockets.WebSocketClient;
import com.koushikdutta.async.http.socketio.Acknowledge;
import com.koushikdutta.async.http.socketio.ConnectCallback;
import com.koushikdutta.async.http.socketio.DisconnectCallback;
import com.koushikdutta.async.http.socketio.ErrorCallback;
import com.koushikdutta.async.http.socketio.JSONCallback;
import com.koushikdutta.async.http.socketio.ReconnectCallback;
import com.koushikdutta.async.http.socketio.SocketIOClient;
import com.koushikdutta.async.http.socketio.StringCallback;
import com.koushikdutta.http.AsyncHttpClient;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

class SocketIOConnection {
    int ackCount;
    Hashtable<String, Acknowledge> acknowledges;
    ArrayList<SocketIOClient> clients = new ArrayList();
    int heartbeat;
    AsyncHttpClient httpClient;
    private Handler mHandler;
    long reconnectDelay = 1000L;
    AsyncHttpClient.SocketIORequest request;
    WebSocketClient webSocketClient;

    public SocketIOConnection(Handler handler, AsyncHttpClient asyncHttpClient, AsyncHttpClient.SocketIORequest socketIORequest) {
        this.acknowledges = new Hashtable();
        this.mHandler = handler;
        this.httpClient = asyncHttpClient;
        this.request = socketIORequest;
    }

    static /* synthetic */ void access$100(SocketIOConnection socketIOConnection, String string2) {
        socketIOConnection.reportConnect(string2);
    }

    static /* synthetic */ Acknowledge access$200(SocketIOConnection socketIOConnection, String string2) {
        return socketIOConnection.acknowledge(string2);
    }

    static /* synthetic */ void access$300(SocketIOConnection socketIOConnection, String string2, String string3, Acknowledge acknowledge) {
        socketIOConnection.reportString(string2, string3, acknowledge);
    }

    static /* synthetic */ void access$400(SocketIOConnection socketIOConnection, String string2, JSONObject jSONObject, Acknowledge acknowledge) {
        socketIOConnection.reportJson(string2, jSONObject, acknowledge);
    }

    static /* synthetic */ void access$500(SocketIOConnection socketIOConnection, String string2, String string3, JSONArray jSONArray, Acknowledge acknowledge) {
        socketIOConnection.reportEvent(string2, string3, jSONArray, acknowledge);
    }

    static /* synthetic */ void access$600(SocketIOConnection socketIOConnection, String string2, String string3) {
        socketIOConnection.reportError(string2, string3);
    }

    private Acknowledge acknowledge(final String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        return new Acknowledge(){

            @Override
            public void acknowledge(JSONArray jSONArray) {
                String string22 = "";
                if (jSONArray != null) {
                    string22 = string22 + "+" + jSONArray.toString();
                }
                WebSocketClient webSocketClient = SocketIOConnection.this.webSocketClient;
                Object[] objectArray = new Object[]{string2, string22};
                webSocketClient.send(String.format("6:::%s%s", objectArray));
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private void delayReconnect() {
        block5: {
            block4: {
                boolean bl2;
                block3: {
                    if (this.webSocketClient != null || this.clients.size() == 0) break block4;
                    Iterator<SocketIOClient> iterator = this.clients.iterator();
                    do {
                        boolean bl3 = iterator.hasNext();
                        bl2 = false;
                        if (!bl3) break block3;
                    } while (!iterator.next().disconnected);
                    bl2 = true;
                }
                if (bl2) break block5;
            }
            return;
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                SocketIOConnection.this.reconnect();
            }
        }, this.reconnectDelay);
        this.reconnectDelay = 2L * this.reconnectDelay;
    }

    private void reportConnect(String string2) {
        this.select(string2, new SelectCallback(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onSelect(SocketIOClient socketIOClient) {
                if (socketIOClient.isConnected()) return;
                if (!socketIOClient.connected) {
                    socketIOClient.connected = true;
                    ConnectCallback connectCallback = socketIOClient.connectCallback;
                    if (connectCallback == null) return;
                    connectCallback.onConnectCompleted(null, socketIOClient);
                    return;
                }
                if (!socketIOClient.disconnected) return;
                socketIOClient.disconnected = false;
                ReconnectCallback reconnectCallback = socketIOClient.reconnectCallback;
                if (reconnectCallback == null) {
                    return;
                }
                reconnectCallback.onReconnect();
            }
        });
    }

    private void reportDisconnect(final Exception exception) {
        this.select(null, new SelectCallback(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onSelect(final SocketIOClient socketIOClient) {
                if (socketIOClient.connected) {
                    socketIOClient.disconnected = true;
                    final DisconnectCallback disconnectCallback = socketIOClient.getDisconnectCallback();
                    if (disconnectCallback == null) return;
                    SocketIOConnection.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            disconnectCallback.onDisconnect(exception);
                        }
                    });
                    return;
                }
                final ConnectCallback connectCallback = socketIOClient.connectCallback;
                if (connectCallback == null) return;
                SocketIOConnection.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        connectCallback.onConnectCompleted(exception, socketIOClient);
                    }
                });
            }
        });
        this.delayReconnect();
    }

    private void reportError(String string2, final String string3) {
        this.select(string2, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient socketIOClient) {
                final ErrorCallback errorCallback = socketIOClient.errorCallback;
                if (errorCallback != null) {
                    SocketIOConnection.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            errorCallback.onError(string3);
                        }
                    });
                }
            }
        });
    }

    private void reportEvent(String string2, final String string3, final JSONArray jSONArray, final Acknowledge acknowledge) {
        this.select(string2, new SelectCallback(){

            @Override
            public void onSelect(final SocketIOClient socketIOClient) {
                SocketIOConnection.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        socketIOClient.onEvent(string3, jSONArray, acknowledge);
                    }
                });
            }
        });
    }

    private void reportJson(String string2, final JSONObject jSONObject, final Acknowledge acknowledge) {
        this.select(string2, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient socketIOClient) {
                final JSONCallback jSONCallback = socketIOClient.jsonCallback;
                if (jSONCallback != null) {
                    SocketIOConnection.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            jSONCallback.onJSON(jSONObject, acknowledge);
                        }
                    });
                }
            }
        });
    }

    private void reportString(String string2, final String string3, final Acknowledge acknowledge) {
        this.select(string2, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient socketIOClient) {
                final StringCallback stringCallback = socketIOClient.stringCallback;
                if (stringCallback != null) {
                    SocketIOConnection.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            stringCallback.onString(string3, acknowledge);
                        }
                    });
                }
            }
        });
    }

    private void select(String string2, SelectCallback selectCallback) {
        for (SocketIOClient socketIOClient : this.clients) {
            if (string2 != null && !TextUtils.equals((CharSequence)socketIOClient.endpoint, (CharSequence)string2)) continue;
            selectCallback.onSelect(socketIOClient);
        }
    }

    public void connect(SocketIOClient socketIOClient) {
        this.clients.add(socketIOClient);
        WebSocketClient webSocketClient = this.webSocketClient;
        Object[] objectArray = new Object[]{socketIOClient.endpoint};
        webSocketClient.send(String.format("1::%s", objectArray));
    }

    public void disconnect(SocketIOClient socketIOClient) {
        this.clients.remove(socketIOClient);
        boolean bl2 = true;
        Iterator<SocketIOClient> iterator = this.clients.iterator();
        while (iterator.hasNext()) {
            if (!TextUtils.equals((CharSequence)iterator.next().endpoint, (CharSequence)socketIOClient.endpoint) && !TextUtils.isEmpty((CharSequence)socketIOClient.endpoint)) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            WebSocketClient webSocketClient = this.webSocketClient;
            Object[] objectArray = new Object[]{socketIOClient.endpoint};
            webSocketClient.send(String.format("0::%s", objectArray));
        }
        if (this.clients.size() > 0) {
            return;
        }
        this.webSocketClient.disconnect();
        this.webSocketClient = null;
    }

    public void emitRaw(int n2, SocketIOClient socketIOClient, String string2, Acknowledge acknowledge) {
        String string3 = "";
        if (acknowledge != null) {
            StringBuilder stringBuilder = new StringBuilder().append("");
            int n3 = this.ackCount;
            this.ackCount = n3 + 1;
            String string4 = stringBuilder.append(n3).toString();
            string3 = string4 + "+";
            this.acknowledges.put(string4, acknowledge);
        }
        WebSocketClient webSocketClient = this.webSocketClient;
        Object[] objectArray = new Object[]{n2, string3, socketIOClient.endpoint, string2};
        webSocketClient.send(String.format("%d:%s:%s:%s", objectArray));
    }

    public boolean isConnected() {
        return this.webSocketClient != null && this.webSocketClient.isConnected();
    }

    void reconnect() {
        if (this.isConnected()) {
            return;
        }
        this.httpClient.executeString(this.request, new AsyncHttpClient.StringCallback(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onCompleted(Exception exception, String string2) {
                String string3;
                if (exception != null) {
                    SocketIOConnection.this.reportDisconnect(exception);
                    return;
                }
                try {
                    String[] stringArray = string2.split(":");
                    string3 = stringArray[0];
                    SocketIOConnection.this.heartbeat = !"".equals(stringArray[1]) ? 1000 * (Integer.parseInt(stringArray[1]) / 2) : 0;
                    if (!new HashSet<String>(Arrays.asList(stringArray[3].split(","))).contains("websocket")) {
                        throw new Exception("websocket not supported");
                    }
                }
                catch (Exception exception2) {
                    SocketIOConnection.this.reportDisconnect(exception2);
                    return;
                }
                String string4 = SocketIOConnection.this.request.getUri().toString() + "websocket/" + string3 + "/";
                SocketIOConnection.this.webSocketClient = new WebSocketClient(URI.create(string4), new WebSocketClient.Listener(){

                    @Override
                    public void onConnect() {
                        SocketIOConnection.this.reconnectDelay = 1000L;
                        SocketIOConnection.this.setupHeartbeat();
                    }

                    @Override
                    public void onDisconnect(int n2, String string2) {
                        SocketIOConnection socketIOConnection = SocketIOConnection.this;
                        Object[] objectArray = new Object[]{n2, string2};
                        socketIOConnection.reportDisconnect(new IOException(String.format("Disconnected code %d for reason %s", objectArray)));
                    }

                    @Override
                    public void onError(Exception exception) {
                        SocketIOConnection.this.reportDisconnect(exception);
                    }

                    /*
                     * Exception decompiling
                     */
                    @Override
                    public void onMessage(String var1_1) {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 111->331)] java.lang.Exception
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }

                    @Override
                    public void onMessage(byte[] byArray) {
                    }
                }, null);
                SocketIOConnection.this.webSocketClient.connect();
            }
        });
    }

    void setupHeartbeat() {
        new Runnable(){

            @Override
            public void run() {
                if (SocketIOConnection.this.heartbeat <= 0 || webSocketClient != SocketIOConnection.this.webSocketClient || webSocketClient == null || !webSocketClient.isConnected()) {
                    return;
                }
                SocketIOConnection.this.webSocketClient.send("2:::");
                SocketIOConnection.this.mHandler.postDelayed((Runnable)this, (long)SocketIOConnection.this.heartbeat);
            }
        }.run();
    }

    private static interface SelectCallback {
        public void onSelect(SocketIOClient var1);
    }
}

