/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.socketio;

import android.os.Handler;
import android.text.TextUtils;
import com.codebutler.android_websockets.WebSocketClient;
import com.koushikdutta.async.http.socketio.Acknowledge;
import com.koushikdutta.async.http.socketio.ConnectCallback;
import com.koushikdutta.async.http.socketio.DisconnectCallback;
import com.koushikdutta.async.http.socketio.ErrorCallback;
import com.koushikdutta.async.http.socketio.EventEmitter;
import com.koushikdutta.async.http.socketio.JSONCallback;
import com.koushikdutta.async.http.socketio.ReconnectCallback;
import com.koushikdutta.async.http.socketio.SocketIOConnection;
import com.koushikdutta.async.http.socketio.StringCallback;
import com.koushikdutta.http.AsyncHttpClient;
import org.json.JSONArray;
import org.json.JSONObject;

public class SocketIOClient
extends EventEmitter {
    ConnectCallback connectCallback;
    boolean connected;
    SocketIOConnection connection;
    DisconnectCallback disconnectCallback;
    boolean disconnected;
    String endpoint;
    ErrorCallback errorCallback;
    Handler handler;
    JSONCallback jsonCallback;
    ReconnectCallback reconnectCallback;
    StringCallback stringCallback;

    private SocketIOClient(SocketIOConnection socketIOConnection, String string2, ConnectCallback connectCallback) {
        this.endpoint = string2;
        this.connection = socketIOConnection;
        this.connectCallback = connectCallback;
    }

    public static void connect(final AsyncHttpClient.SocketIORequest socketIORequest, final ConnectCallback connectCallback, final Handler handler) {
        final SocketIOConnection socketIOConnection = new SocketIOConnection(handler, new AsyncHttpClient(), socketIORequest);
        ConnectCallback connectCallback2 = new ConnectCallback(){

            @Override
            public void onConnectCompleted(Exception exception, SocketIOClient socketIOClient) {
                if (exception != null || TextUtils.isEmpty((CharSequence)socketIORequest.getEndpoint())) {
                    socketIOClient.handler = handler;
                    if (connectCallback != null) {
                        connectCallback.onConnectCompleted(exception, socketIOClient);
                    }
                    return;
                }
                socketIOConnection.clients.remove(socketIOClient);
                socketIOClient.of(socketIORequest.getEndpoint(), new ConnectCallback(){

                    @Override
                    public void onConnectCompleted(Exception exception, SocketIOClient socketIOClient) {
                        if (connectCallback != null) {
                            connectCallback.onConnectCompleted(exception, socketIOClient);
                        }
                    }
                });
            }
        };
        socketIOConnection.clients.add(new SocketIOClient(socketIOConnection, "", connectCallback2));
        socketIOConnection.reconnect();
    }

    public static void connect(String string2, ConnectCallback connectCallback, Handler handler) {
        SocketIOClient.connect(new AsyncHttpClient.SocketIORequest(string2), connectCallback, handler);
    }

    private void emitRaw(int n2, String string2, Acknowledge acknowledge) {
        this.connection.emitRaw(n2, this, string2, acknowledge);
    }

    public void disconnect() {
        this.connection.disconnect(this);
        final DisconnectCallback disconnectCallback = this.disconnectCallback;
        if (disconnectCallback != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    disconnectCallback.onDisconnect(null);
                }
            });
        }
    }

    public void emit(String string2) {
        this.emit(string2, (Acknowledge)null);
    }

    public void emit(String string2, Acknowledge acknowledge) {
        this.emitRaw(3, string2, acknowledge);
    }

    public void emit(String string2, JSONArray jSONArray) {
        this.emit(string2, jSONArray, null);
    }

    public void emit(String string2, JSONArray jSONArray, Acknowledge acknowledge) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("name", (Object)string2);
            jSONObject.put("args", (Object)jSONArray);
            this.emitRaw(5, jSONObject.toString(), acknowledge);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void emit(JSONObject jSONObject) {
        this.emit(jSONObject, null);
    }

    public void emit(JSONObject jSONObject, Acknowledge acknowledge) {
        this.emitRaw(4, jSONObject.toString(), acknowledge);
    }

    public DisconnectCallback getDisconnectCallback() {
        return this.disconnectCallback;
    }

    public ErrorCallback getErrorCallback() {
        return this.errorCallback;
    }

    public JSONCallback getJSONCallback() {
        return this.jsonCallback;
    }

    public ReconnectCallback getReconnectCallback() {
        return this.reconnectCallback;
    }

    public StringCallback getStringCallback() {
        return this.stringCallback;
    }

    public WebSocketClient getWebSocket() {
        return this.connection.webSocketClient;
    }

    public boolean isConnected() {
        return this.connected && !this.disconnected && this.connection.isConnected();
    }

    public void of(String string2, ConnectCallback connectCallback) {
        this.connection.connect(new SocketIOClient(this.connection, string2, connectCallback));
    }

    public void setDisconnectCallback(DisconnectCallback disconnectCallback) {
        this.disconnectCallback = disconnectCallback;
    }

    public void setErrorCallback(ErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
    }

    public void setJSONCallback(JSONCallback jSONCallback) {
        this.jsonCallback = jSONCallback;
    }

    public void setReconnectCallback(ReconnectCallback reconnectCallback) {
        this.reconnectCallback = reconnectCallback;
    }

    public void setStringCallback(StringCallback stringCallback) {
        this.stringCallback = stringCallback;
    }
}

