/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.re.controller.util;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import com.inmobi.commons.internal.Base64;
import com.inmobi.commons.internal.Log;
import com.inmobi.re.configs.Initializer;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageProcessing {
    public static String convertMediaUriToPath(Uri uri, Context context) {
        String[] stringArray = new String[]{"_data"};
        Cursor cursor = context.getContentResolver().query(uri, stringArray, null, null, null);
        int n2 = cursor.getColumnIndexOrThrow("_data");
        cursor.moveToFirst();
        String string2 = cursor.getString(n2);
        cursor.close();
        return string2;
    }

    public static String getBase64EncodedImage(Bitmap bitmap, Context context) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = ImageProcessing.getDefaultImgQuality(context);
        bitmap.compress(Bitmap.CompressFormat.JPEG, n2, (OutputStream)byteArrayOutputStream);
        return Base64.encodeToString(byteArrayOutputStream.toByteArray(), 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap getCompressedBitmap(String string2, Context context) {
        try {
            Bitmap bitmap;
            int n2 = ImageProcessing.getDefaultImgWidth(context) * ImageProcessing.getDefaultImgHeight(context);
            FileInputStream fileInputStream = new FileInputStream(string2);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)fileInputStream, null, (BitmapFactory.Options)options);
            ((InputStream)fileInputStream).close();
            int n3 = 1;
            while ((double)(options.outWidth * options.outHeight) * (1.0 / Math.pow(n3, 2.0)) > (double)n2) {
                ++n3;
            }
            FileInputStream fileInputStream2 = new FileInputStream(string2);
            if (n3 > 1) {
                int n4 = n3 - 1;
                BitmapFactory.Options options2 = new BitmapFactory.Options();
                options2.inSampleSize = n4;
                Bitmap bitmap2 = BitmapFactory.decodeStream((InputStream)fileInputStream2, null, (BitmapFactory.Options)options2);
                int n5 = bitmap2.getHeight();
                int n6 = bitmap2.getWidth();
                double d2 = Math.sqrt((double)n2 / ((double)n6 / (double)n5));
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)((int)(d2 / (double)n5 * (double)n6)), (int)((int)d2), (boolean)true);
                bitmap2.recycle();
                System.gc();
            } else {
                Bitmap bitmap3;
                bitmap = bitmap3 = BitmapFactory.decodeStream((InputStream)fileInputStream2);
            }
            ((InputStream)fileInputStream2).close();
            Log.debug("[InMobi]-[RE]-4.1.1", "bitmap size - width: " + bitmap.getWidth() + ", height: " + bitmap.getHeight());
            return bitmap;
        }
        catch (IOException iOException) {
            Log.debug("[InMobi]-[RE]-4.1.1", iOException.getMessage(), iOException);
            return null;
        }
    }

    public static int getDefaultImgHeight(Context context) {
        return Initializer.getConfigParams().getPicHeight();
    }

    public static int getDefaultImgQuality(Context context) {
        return Initializer.getConfigParams().getPicQuality();
    }

    public static int getDefaultImgWidth(Context context) {
        return Initializer.getConfigParams().getPicWidth();
    }
}

