/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.monetization.internal.objects;

import android.content.Context;
import android.util.Base64;
import com.inmobi.androidsdk.bootstrapper.Initializer;
import com.inmobi.commons.ads.cache.AdData;
import com.inmobi.commons.ads.cache.AdDatabaseManager;
import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.Log;
import com.inmobi.monetization.IMNative;
import com.inmobi.monetization.internal.objects.NativeAd;
import java.util.List;
import org.json.JSONObject;

public class NativeAdsCache {
    static NativeAdsCache a;

    private NativeAdsCache(Context context) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NativeAdsCache getInstance() {
        if (a == null) {
            synchronized (NativeAdsCache.class) {
                a = new NativeAdsCache(InternalSDKUtil.getContext());
            }
        }
        AdDatabaseManager.getInstance().setDBLimit(Initializer.getConfigParams().getNativeSdkConfigParams().getmMaxCacheSize());
        return a;
    }

    public IMNative getCachedAd(String string2) {
        try {
            JSONObject jSONObject = new JSONObject(AdDatabaseManager.getInstance().getAd(string2).getContent());
            NativeAd nativeAd = new NativeAd(new String(Base64.decode((String)jSONObject.getString("pubContent"), (int)0)).trim(), jSONObject.getString("contextCode"), jSONObject.getString("namespace"));
            return nativeAd;
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-[Monetization]", "Exception getting cached ad", exception);
            return null;
        }
    }

    public int getNumCachedAds(String string2) {
        try {
            int n2 = AdDatabaseManager.getInstance().getNoOfAds(string2);
            return n2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void saveNativeAds(String string2, List<String> list) {
        if (list != null && list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                AdData adData = new AdData();
                adData.setContent(list.get(i2));
                adData.setTimestamp(System.currentTimeMillis());
                adData.setAppId(string2);
                adData.setAdType("native");
                AdDatabaseManager.getInstance().insertAd(adData);
            }
        }
    }
}

