/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.monetization.internal;

import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.Log;
import com.inmobi.monetization.internal.GetLtvpRulesRequest;
import com.inmobi.monetization.internal.GetLtvpRulesResponse;
import com.inmobi.monetization.internal.LtvpErrorCode;
import com.inmobi.monetization.internal.ServiceProvider;
import com.inmobi.monetization.internal.abstraction.IGetLtvpRuleRequestListener;
import com.inmobi.monetization.internal.objects.LtvpRuleCache;

public class LtvpRuleProcessor
implements IGetLtvpRuleRequestListener {
    private ServiceProvider a = ServiceProvider.getInstance();

    private LtvpRuleProcessor() {
    }

    public static LtvpRuleProcessor getInstance() {
        return new LtvpRuleProcessor();
    }

    public void dispatchLtvpRule() {
        Log.internal("[InMobi]-[Monetization]", "Fetching LTVP Rule");
        GetLtvpRulesRequest getLtvpRulesRequest = new GetLtvpRulesRequest();
        this.a.getLtvpRule(getLtvpRulesRequest, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionsRule getLtvpRuleConfig(long l2) {
        int n2;
        ActionsRule.MEDIATION.getValue();
        LtvpRuleCache ltvpRuleCache = LtvpRuleCache.getInstance(InternalSDKUtil.getContext());
        if (ltvpRuleCache.getHardExpiryForLtvpRule() <= System.currentTimeMillis() || ltvpRuleCache.getHardExpiryForLtvpRule() == 0L) {
            Log.internal("[InMobi]-[Monetization]", "Hard Expiry or 1st rule fetch. Default mediation. Fetching Rule");
            this.dispatchLtvpRule();
            ltvpRuleCache.clearLtvpRuleCache();
            return ActionsRule.MEDIATION;
        }
        if (ltvpRuleCache.getSoftExpiryForLtvpRule() <= System.currentTimeMillis()) {
            Log.internal("[InMobi]-[Monetization]", "Soft Expiry. Default mediation. Fetching Rule");
            this.dispatchLtvpRule();
            n2 = ltvpRuleCache.getLtvpRule(l2);
            return ActionsRule.a(n2);
        }
        Log.internal("[InMobi]-[Monetization]", "Valid rule");
        n2 = ltvpRuleCache.getLtvpRule(l2);
        return ActionsRule.a(n2);
    }

    @Override
    public void onLtvpGetRuleFailed(GetLtvpRulesRequest getLtvpRulesRequest, LtvpErrorCode ltvpErrorCode) {
        Log.internal("[InMobi]-[Monetization]", "Ltvp Rule error" + ltvpErrorCode.toString());
    }

    @Override
    public void onLtvpGetRuleSucceeded(GetLtvpRulesRequest getLtvpRulesRequest, GetLtvpRulesResponse getLtvpRulesResponse) {
        Log.internal("[InMobi]-[Monetization]", "Ltvp Rule received" + getLtvpRulesResponse.getRules().toString());
        LtvpRuleCache.getInstance(InternalSDKUtil.getContext()).setLtvpRuleConfig(getLtvpRulesResponse);
    }

    public static final class ActionsRule
    extends Enum<ActionsRule> {
        public static final /* enum */ ActionsRule ACTIONS_ONLY;
        public static final /* enum */ ActionsRule ACTIONS_TO_MEDIATION;
        public static final /* enum */ ActionsRule MEDIATION;
        public static final /* enum */ ActionsRule NO_ADS;
        private static final /* synthetic */ ActionsRule[] b;
        int a;

        static {
            MEDIATION = new ActionsRule(0);
            NO_ADS = new ActionsRule(1);
            ACTIONS_TO_MEDIATION = new ActionsRule(2);
            ACTIONS_ONLY = new ActionsRule(3);
            ActionsRule[] actionsRuleArray = new ActionsRule[]{MEDIATION, NO_ADS, ACTIONS_TO_MEDIATION, ACTIONS_ONLY};
            b = actionsRuleArray;
        }

        private ActionsRule(int n3) {
            this.a = n3;
        }

        static ActionsRule a(int n2) {
            switch (n2) {
                default: {
                    return MEDIATION;
                }
                case 1: {
                    return NO_ADS;
                }
                case 2: {
                    return ACTIONS_TO_MEDIATION;
                }
                case 3: 
            }
            return ACTIONS_ONLY;
        }

        public static ActionsRule valueOf(String string2) {
            return Enum.valueOf(ActionsRule.class, string2);
        }

        public static ActionsRule[] values() {
            return (ActionsRule[])b.clone();
        }

        public int getValue() {
            return this.a;
        }
    }
}

