/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.uid;

import android.content.Context;
import android.content.pm.PackageManager;
import com.inmobi.commons.InMobi;
import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.Log;
import com.inmobi.commons.uid.UID;
import com.inmobi.commons.uid.UIDHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

public class UIDUtil {
    private static Random a = new Random();

    static String a(String string2) {
        if (string2 == null) {
            return "";
        }
        try {
            String string3 = URLEncoder.encode(string2, "UTF-8");
            return string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedOperationException(unsupportedEncodingException);
        }
    }

    public static void bindToConnection(Map<String, String> map, URLConnection uRLConnection) {
        for (String string2 : map.keySet()) {
            uRLConnection.addRequestProperty(string2, map.get(string2));
        }
    }

    public static String bindToGetParam(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : map.keySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            Object[] objectArray = new Object[]{UIDUtil.a(string2), UIDUtil.a(map.get(string2))};
            stringBuilder.append(String.format("%s=%s", objectArray));
        }
        return stringBuilder.toString();
    }

    public static void bindToJSON(Map<String, String> map, JSONObject jSONObject) {
        for (String string2 : map.keySet()) {
            try {
                jSONObject.put(string2, (Object)map.get(string2));
            }
            catch (JSONException jSONException) {
                Log.internal("[InMobi]-4.1.1", "UIDUtil: Unable to bind to JSON for key " + string2);
            }
        }
    }

    public static String getEncryptedJSON(Map<String, String> map) {
        JSONObject jSONObject = new JSONObject();
        UIDUtil.bindToJSON(map, jSONObject);
        return UIDHelper.encryptRSA(jSONObject.toString());
    }

    public static String getEncryptedUid(String string2) {
        return UID.getCommonsUid().getDefaultUidMap(1, string2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getMap(Context context, UID uID) {
        Map<String, String> map = UIDUtil.getUid(uID);
        String string2 = context.getPackageName();
        String string3 = "";
        try {
            String string4;
            string3 = string4 = Integer.valueOf(context.getPackageManager().getPackageInfo((String)string2, (int)0).versionCode).toString();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.internal("[InMobi]-4.1.1", "Unable to get app version", nameNotFoundException);
        }
        map.put("u-appbid", string2);
        map.put("u-appver", string3);
        String string5 = InMobi.getAppId();
        if (string5 == null) {
            string5 = "";
        }
        map.put("mk-siteid", string5);
        map.put("mk-version", "pr-SAND-" + InternalSDKUtil.getInMobiInternalVersion("4.1.1") + "-" + "20140131");
        map.put("ua", InternalSDKUtil.getSavedUserAgent());
        return map;
    }

    public static Map<String, String> getUid(UID uID) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = Integer.toString(a.nextInt());
        hashMap.put("u-id-key", string2);
        hashMap.put("u-key-ver", UIDHelper.getRSAKeyVersion());
        if (uID == null) {
            hashMap.put("u-id-map", UID.getCommonsUid().getDefaultUidMap(1, string2, null));
            return hashMap;
        }
        hashMap.put("u-id-map", uID.getUidMap(1, string2, null));
        return hashMap;
    }
}

