/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.thinICE.wifi;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import com.inmobi.commons.thinICE.icedatacollector.IceDataCollector;
import com.inmobi.commons.thinICE.icedatacollector.ThinICEConfigSettings;
import com.inmobi.commons.thinICE.wifi.WifiInfo;
import java.util.ArrayList;
import java.util.List;

public final class WifiUtil {
    private static final String[] a = new String[]{"android.permission.ACCESS_WIFI_STATE"};
    private static final String[] b = new String[]{"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE"};
    private static final String[] c = new String[]{"android.permission.WAKE_LOCK"};

    private static long a(byte by2) {
        return 0xFFL & (long)by2;
    }

    private static long a(byte[] byArray) {
        long l2 = 0L;
        if (byArray != null && byArray.length == 6) {
            l2 = WifiUtil.a(byArray[5]) | WifiUtil.a(byArray[4]) << 8 | WifiUtil.a(byArray[3]) << 16 | WifiUtil.a(byArray[2]) << 24 | WifiUtil.a(byArray[1]) << 32 | WifiUtil.a(byArray[0]) << 40;
        }
        return l2;
    }

    private static boolean a(boolean bl2, String string2) {
        return bl2 && string2 != null && string2.endsWith("_nomap");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WifiInfo getConnectedWifiInfo(Context context) {
        boolean bl2;
        int n2 = IceDataCollector.getConfig().getWifiFlags();
        if (!ThinICEConfigSettings.bitTest(n2, 2)) {
            bl2 = true;
            return WifiUtil.getConnectedWifiInfo(context, bl2, ThinICEConfigSettings.bitTest(n2, 1));
        }
        bl2 = false;
        return WifiUtil.getConnectedWifiInfo(context, bl2, ThinICEConfigSettings.bitTest(n2, 1));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static WifiInfo getConnectedWifiInfo(Context context, boolean bl2, boolean bl3) {
        String string2;
        String string3;
        WifiInfo wifiInfo;
        android.net.wifi.WifiInfo wifiInfo2;
        block5: {
            block4: {
                wifiInfo2 = ((WifiManager)context.getSystemService("wifi")).getConnectionInfo();
                if (wifiInfo2 == null) break block4;
                wifiInfo = new WifiInfo();
                string3 = wifiInfo2.getBSSID();
                string2 = wifiInfo2.getSSID();
                if (string3 != null && !WifiUtil.a(bl2, string2)) break block5;
            }
            return null;
        }
        wifiInfo.bssid = WifiUtil.macToLong(string3);
        if (bl3) {
            string2 = null;
        }
        wifiInfo.ssid = string2;
        wifiInfo.rssi = wifiInfo2.getRssi();
        wifiInfo.ip = wifiInfo2.getIpAddress();
        return wifiInfo;
    }

    public static boolean hasGetConnectedWifiInfoPermission(Context context) {
        String[] stringArray = a;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (context.checkCallingOrSelfPermission(stringArray[i2]) == 0) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean hasWifiScanPermission(Context context, boolean bl2) {
        String[] stringArray = b;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (context.checkCallingOrSelfPermission(stringArray[i2]) != 0) return false;
        }
        if (!bl2) return true;
        String[] stringArray2 = c;
        int n3 = stringArray2.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            if (context.checkCallingOrSelfPermission(stringArray2[i3]) == 0) continue;
            return false;
        }
        return true;
    }

    public static long macToLong(String string2) {
        String[] stringArray = string2.split("\\:");
        byte[] byArray = new byte[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            byArray[i2] = (byte)Integer.parseInt(stringArray[i2], 16);
        }
        return WifiUtil.a(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static WifiInfo scanResultToWifiInfo(ScanResult scanResult, boolean bl2) {
        if (scanResult == null) {
            return null;
        }
        WifiInfo wifiInfo = new WifiInfo();
        wifiInfo.bssid = WifiUtil.macToLong(scanResult.BSSID);
        String string2 = null;
        if (!bl2) {
            string2 = scanResult.SSID;
        }
        wifiInfo.ssid = string2;
        wifiInfo.rssi = scanResult.level;
        return wifiInfo;
    }

    public static List<WifiInfo> scanResultsToWifiInfos(List<ScanResult> list, boolean bl2, boolean bl3) {
        if (list == null) {
            return null;
        }
        ArrayList<WifiInfo> arrayList = new ArrayList<WifiInfo>();
        for (ScanResult scanResult : list) {
            if (WifiUtil.a(bl2, scanResult.SSID)) continue;
            arrayList.add(WifiUtil.scanResultToWifiInfo(scanResult, bl3));
        }
        return arrayList;
    }
}

