/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.thinICE.location;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import com.inmobi.commons.thinICE.location.LocationInfo;
import java.util.HashMap;

public final class LocationUtil {
    private static LocationInfo a(Context context, String string2) {
        Location location = ((LocationManager)context.getSystemService("location")).getLastKnownLocation(string2);
        if (location == null) {
            return null;
        }
        LocationInfo locationInfo = new LocationInfo();
        locationInfo.time = location.getTime();
        locationInfo.provider = location.getProvider();
        locationInfo.latitude = location.getLatitude();
        locationInfo.longitude = location.getLongitude();
        locationInfo.accuracy = location.getAccuracy();
        return locationInfo;
    }

    public static HashMap<String, LocationInfo> getLastKnownLocations(Context context) {
        HashMap<String, LocationInfo> hashMap = new HashMap<String, LocationInfo>();
        if (LocationUtil.hasFineLocationPermission(context)) {
            hashMap.put("gps", LocationUtil.a(context, "gps"));
        }
        if (LocationUtil.hasCoarseLocationPermission(context)) {
            hashMap.put("network", LocationUtil.a(context, "network"));
        }
        return hashMap;
    }

    public static boolean hasCoarseLocationPermission(Context context) {
        return context.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0;
    }

    public static boolean hasFineLocationPermission(Context context) {
        return context.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    public static boolean hasLocationPermission(Context context) {
        return LocationUtil.hasFineLocationPermission(context) || LocationUtil.hasCoarseLocationPermission(context);
    }
}

