/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.internal;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import com.inmobi.commons.analytics.bootstrapper.AnalyticsInitializer;
import com.inmobi.commons.analytics.bootstrapper.ThinICEConfig;
import com.inmobi.commons.cache.RetryMechanism;
import com.inmobi.commons.internal.ActivityRecognitionSampler;
import com.inmobi.commons.internal.ApplicationFocusManager;
import com.inmobi.commons.internal.CommonsException;
import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.JSONPayloadCreator;
import com.inmobi.commons.internal.Log;
import com.inmobi.commons.internal.b;
import com.inmobi.commons.thinICE.icedatacollector.IceDataCollector;
import com.inmobi.commons.thinICE.icedatacollector.Sample;
import com.inmobi.commons.thinICE.icedatacollector.ThinICEConfigSettings;
import com.inmobi.commons.thinICE.icedatacollector.ThinICEListener;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Timer;

public final class ThinICE {
    private static boolean a = false;
    private static ThinICEListener b = new b();
    private static Timer c = new Timer();

    private ThinICE() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"NewApi"})
    private static void a(Activity activity) throws CommonsException {
        if (!a && activity == null) {
            throw new CommonsException(1);
        }
        if (!a) {
            if (Build.VERSION.SDK_INT >= 14) {
                ApplicationFocusManager.init(activity);
                ApplicationFocusManager.addFocusChangedListener(new ApplicationFocusManager.FocusChangedListener(){

                    @Override
                    public void onFocusChanged(boolean bl2) {
                        if (bl2) {
                            IceDataCollector.start(InternalSDKUtil.getContext());
                            return;
                        }
                        ThinICE.b();
                    }
                });
                IceDataCollector.start(activity.getApplicationContext());
            } else {
                IceDataCollector.setListener(b);
            }
            a = true;
        }
        InternalSDKUtil.initialize(activity.getApplicationContext());
    }

    static /* synthetic */ void a(List list) {
        ThinICE.b(list);
    }

    private static void b() {
        List<Sample> list = IceDataCollector.getData();
        IceDataCollector.stop();
        ThinICE.b(list);
        ActivityRecognitionSampler.stop();
    }

    private static void b(String string2) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(AnalyticsInitializer.getConfigParams().getThinIceConfig().getEndpointUrl()).openConnection();
        InternalSDKUtil.addCommonPropertiesToConnection(httpURLConnection);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(false);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream());
        outputStreamWriter.write(string2);
        outputStreamWriter.flush();
        outputStreamWriter.close();
        httpURLConnection.getResponseCode();
    }

    private static void b(List<Sample> list) {
        if (list.size() == 0 && ActivityRecognitionSampler.getCollectedList().size() == 0) {
            Log.internal("[InMobi]-4.1.1", "No ThinICE data is collected. NoOp.");
            return;
        }
        if (!AnalyticsInitializer.getConfigParams().getThinIceConfig().isEnabled()) {
            Log.internal("[InMobi]-4.1.1", "ThisICE disabled. Not sending data. NoOp.");
            return;
        }
        RetryMechanism retryMechanism = new RetryMechanism((int)AnalyticsInitializer.getConfigParams().getThinIceConfig().getMaxRetry(), 1000 * (int)AnalyticsInitializer.getConfigParams().getThinIceConfig().getRetryInterval(), c);
        final String string2 = new JSONPayloadCreator().toPayloadString(list, ActivityRecognitionSampler.getCollectedList(), InternalSDKUtil.getContext());
        Log.internal("[InMobi]-4.1.1", "Sending " + list.size() + " ThinICE params to server " + string2);
        retryMechanism.rescheduleTimer(new RetryMechanism.RetryRunnable(){

            @Override
            public void completed() {
            }

            @Override
            public void run() throws Exception {
                Log.internal("[InMobi]-4.1.1", "Sending ThinICE data to server " + AnalyticsInitializer.getConfigParams().getThinIceConfig().getEndpointUrl());
                if (InternalSDKUtil.checkNetworkAvailibility(InternalSDKUtil.getContext())) {
                    ThinICE.b(string2);
                    return;
                }
                throw new Exception("Device not connected.");
            }
        });
    }

    public static void setConfig(ThinICEConfig thinICEConfig) {
        if (thinICEConfig != null) {
            ThinICEConfigSettings thinICEConfigSettings = new ThinICEConfigSettings();
            thinICEConfigSettings.setEnabled(thinICEConfig.isEnabled());
            thinICEConfigSettings.setSampleCellEnabled(thinICEConfig.isCellEnabled());
            thinICEConfigSettings.setSampleCellOperatorEnabled(thinICEConfig.isOperatorEnabled());
            thinICEConfigSettings.setSampleConnectedWifiEnabled(thinICEConfig.isConnectedWifiEnabled());
            thinICEConfigSettings.setSampleHistorySize(thinICEConfig.getSampleHistorySize());
            thinICEConfigSettings.setSampleInterval(1000L * thinICEConfig.getSampleInterval());
            thinICEConfigSettings.setSampleLocationEnabled(true);
            thinICEConfigSettings.setSampleVisibleWifiEnabled(thinICEConfig.isVisibleWifiEnabled());
            thinICEConfigSettings.setStopRequestTimeout(1000L * thinICEConfig.getStopRequestTimeout());
            thinICEConfigSettings.setWifiFlags(thinICEConfig.getWifiFlags());
            thinICEConfigSettings.setCellOpFlags(thinICEConfig.getCellOpsFlag());
            IceDataCollector.setConfig(thinICEConfigSettings);
        }
    }

    public static void start(Activity activity) throws CommonsException {
        if (!InternalSDKUtil.isInitializedSuccessfully(false)) {
            return;
        }
        ThinICE.a(activity);
        if (Build.VERSION.SDK_INT < 14) {
            IceDataCollector.start((Context)activity);
        }
        ActivityRecognitionSampler.start();
    }

    public static void stop(Activity activity) throws CommonsException {
        ThinICE.a(activity);
        if (Build.VERSION.SDK_INT < 14) {
            ThinICE.b();
        }
    }
}

