/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.internal;

import android.content.Context;
import com.inmobi.commons.analytics.bootstrapper.AnalyticsInitializer;
import com.inmobi.commons.analytics.bootstrapper.ThinICEConfig;
import com.inmobi.commons.data.LocationInfo;
import com.inmobi.commons.internal.ActivityRecognitionSampler;
import com.inmobi.commons.internal.AppDetectionManager;
import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.Log;
import com.inmobi.commons.internal.PayloadCreator;
import com.inmobi.commons.thinICE.cellular.CellOperatorInfo;
import com.inmobi.commons.thinICE.cellular.CellTowerInfo;
import com.inmobi.commons.thinICE.cellular.CellUtil;
import com.inmobi.commons.thinICE.icedatacollector.Sample;
import com.inmobi.commons.thinICE.icedatacollector.ThinICEConfigSettings;
import com.inmobi.commons.thinICE.wifi.WifiInfo;
import com.inmobi.commons.uid.UIDUtil;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONPayloadCreator
implements PayloadCreator {
    private JSONObject a() {
        JSONArray jSONArray = AppDetectionManager.getInstalledApps();
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("t", 2);
            jSONObject.put("ts", System.currentTimeMillis());
            jSONObject.put("a-meta", (Object)jSONArray);
            return jSONObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private JSONObject a(ActivityRecognitionSampler.ActivitySample activitySample) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("t", 3);
            jSONObject.put("ts", activitySample.getTimestamp());
            jSONObject.put("a", activitySample.getActivity());
            return jSONObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private JSONObject a(CellTowerInfo cellTowerInfo) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("id", (Object)cellTowerInfo.id);
            if (cellTowerInfo.signalStrength != 0) {
                jSONObject.put("ss", cellTowerInfo.signalStrength);
            }
            return jSONObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject a(Sample sample, ThinICEConfig thinICEConfig) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("t", 1);
            if (thinICEConfig.isConnectedWifiEnabled()) {
                jSONObject.put("c-ap", (Object)this.a(sample.connectedWifiAp));
            }
            if (thinICEConfig.isCellEnabled()) {
                jSONObject.put("c-sc", (Object)this.a(sample.connectedCellTowerInfo));
            }
            if (thinICEConfig.isVisibleWifiEnabled()) {
                JSONArray jSONArray = new JSONArray();
                if (sample.visibleWifiAp != null) {
                    Iterator<WifiInfo> iterator = sample.visibleWifiAp.iterator();
                    while (iterator.hasNext()) {
                        JSONObject jSONObject2 = this.a(iterator.next());
                        if (jSONObject2 == null) continue;
                        jSONArray.put((Object)jSONObject2);
                    }
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("v-ap", (Object)jSONArray);
                }
            }
            if (jSONObject.length() > 1) {
                jSONObject.put("ts", sample.utc);
                return jSONObject;
            }
            return null;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    private JSONObject a(WifiInfo wifiInfo) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("bssid", wifiInfo.bssid);
            jSONObject.put("essid", (Object)wifiInfo.ssid);
            return jSONObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String currentLocationStr() {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringBuilder != null && LocationInfo.isValidGeoInfo()) {
            stringBuilder.append(LocationInfo.getLat());
            stringBuilder.append(",");
            stringBuilder.append(LocationInfo.getLon());
            stringBuilder.append(",");
            stringBuilder.append((int)LocationInfo.getLocAccuracy());
            return stringBuilder.toString();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toPayloadString(List<Sample> list, List<ActivityRecognitionSampler.ActivitySample> list2, Context context) {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        ThinICEConfig thinICEConfig = AnalyticsInitializer.getConfigParams().getThinIceConfig();
        for (Sample sample : list) {
            JSONObject jSONObject2;
            if (sample == null || (jSONObject2 = this.a(sample, thinICEConfig)) == null) continue;
            jSONArray.put((Object)jSONObject2);
        }
        for (ActivityRecognitionSampler.ActivitySample activitySample : list2) {
            JSONObject jSONObject3;
            if (activitySample == null || (jSONObject3 = this.a(activitySample)) == null) continue;
            jSONArray.put((Object)jSONObject3);
        }
        JSONObject jSONObject4 = this.a();
        if (jSONObject4 != null) {
            jSONArray.put((Object)jSONObject4);
        }
        try {
            if (jSONArray.length() > 0) {
                jSONObject.put("payload", (Object)jSONArray);
            }
            CellOperatorInfo cellOperatorInfo = CellUtil.getCellNetworkInfo(context);
            if (thinICEConfig.isOperatorEnabled()) {
                if (!(ThinICEConfigSettings.bitTest(thinICEConfig.getCellOpsFlag(), 1) || cellOperatorInfo.simMcc == -1 && cellOperatorInfo.simMnc == -1)) {
                    jSONObject.put("s-ho", (Object)(cellOperatorInfo.simMcc + "_" + cellOperatorInfo.simMnc));
                }
                if (!(ThinICEConfigSettings.bitTest(thinICEConfig.getCellOpsFlag(), 2) || cellOperatorInfo.currentMcc == -1 && cellOperatorInfo.currentMnc == -1)) {
                    jSONObject.put("s-co", (Object)(cellOperatorInfo.currentMcc + "_" + cellOperatorInfo.currentMnc));
                }
            }
            Calendar calendar = Calendar.getInstance();
            System.currentTimeMillis();
            jSONObject.put("tz", calendar.get(15) + calendar.get(16));
            jSONObject.put("ts", calendar.getTimeInMillis());
            jSONObject.put("mk-version", (Object)("pr-SAND-" + InternalSDKUtil.getInMobiInternalVersion("4.1.1") + "-" + "20140131"));
            String string2 = JSONPayloadCreator.currentLocationStr();
            if (string2 != null && !"".equals(string2)) {
                jSONObject.put("u-latlong-accu", (Object)string2);
            }
            Map<String, String> map = UIDUtil.getMap(context, null);
            map.remove("ua");
            map.remove("s-ver");
            UIDUtil.bindToJSON(map, jSONObject);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.internal("[InMobi]-4.1.1", "Unable to create payload for sending ThinICE params");
            return null;
        }
    }
}

