/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.inmobi.commons.InMobi;
import com.inmobi.commons.cache.CacheController;
import com.inmobi.commons.internal.ApiStatCollector;
import com.inmobi.commons.internal.CommonsConfig;
import com.inmobi.commons.internal.CommonsException;
import com.inmobi.commons.internal.Log;
import com.inmobi.commons.internal.d;
import com.inmobi.commons.uid.UIDUtil;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class InternalSDKUtil {
    public static final String BASE_LOG_TAG = "[InMobi]";
    public static final String INMOBI_SDK_RELEASE_DATE = "20140131";
    public static final String INMOBI_SDK_RELEASE_VERSION = "4.1.1";
    public static final String LOGGING_TAG = "[InMobi]-4.1.1";
    public static final String PRODUCT_COMMONS = "commons";
    private static CommonsConfig a = new CommonsConfig();
    private static String b;
    private static Context c;
    private static Map<String, String> d;
    private static CacheController.Validator e;
    private static boolean f;

    static {
        c = null;
        d = new HashMap<String, String>();
        e = new d();
        f = true;
    }

    private static void a() {
        d = UIDUtil.getMap(InternalSDKUtil.getContext(), null);
    }

    static boolean a(Map<String, Object> map) {
        InternalSDKUtil.a();
        try {
            CommonsConfig commonsConfig = new CommonsConfig();
            commonsConfig.setFromMap(map);
            a = commonsConfig;
            ApiStatCollector.getLogger().setMetricConfigParams(commonsConfig.getApiStatsConfig());
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static void addCommonPropertiesToConnection(HttpURLConnection httpURLConnection) {
        String string2 = InternalSDKUtil.getUserAgent(InternalSDKUtil.getContext());
        if (string2 != null) {
            httpURLConnection.setRequestProperty("User-Agent", string2);
        }
    }

    public static boolean checkNetworkAvailibility(Context context) {
        ConnectivityManager connectivityManager;
        block4: {
            if (context == null) {
                return false;
            }
            try {
                connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                if (connectivityManager.getActiveNetworkInfo() != null) break block4;
                return false;
            }
            catch (Exception exception) {
                Log.internal(LOGGING_TAG, "Cannot check network state", exception);
                return false;
            }
        }
        boolean bl2 = connectivityManager.getActiveNetworkInfo().isConnected();
        return bl2;
    }

    public static boolean getBooleanFromJSON(JSONObject jSONObject, String string2, boolean bl2) {
        try {
            boolean bl3 = jSONObject.getBoolean(string2);
            return bl3;
        }
        catch (Exception exception) {
            try {
                Log.debug(LOGGING_TAG, "JSON with property " + string2 + " found but has bad datatype(" + jSONObject.get(string2).getClass() + "). Reverting to " + bl2);
                return bl2;
            }
            catch (JSONException jSONException) {
                return bl2;
            }
        }
    }

    public static boolean getBooleanFromMap(Map<String, Object> map, String string2) {
        Object object = map.get(string2);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        Log.internal(LOGGING_TAG, "Key " + string2 + " has illegal value");
        throw new IllegalArgumentException();
    }

    public static CommonsConfig getConfig() {
        return a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getConnectivityType(Context context) {
        String string2;
        int n2;
        try {
            if (context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") != 0) return null;
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) return null;
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            int n3 = networkInfo.getType();
            n2 = networkInfo.getSubtype();
            if (n3 == 1) {
                return "wifi";
            }
            if (n3 != 0) return null;
            string2 = "carrier";
            if (n2 == 1) {
                return "gprs";
            }
        }
        catch (Exception exception) {
            Log.internal(LOGGING_TAG, "Error getting the network info", exception);
            return null;
        }
        if (n2 == 2) {
            return "edge";
        }
        if (n2 == 3) {
            return "umts";
        }
        if (n2 != 0) return string2;
        return "carrier";
    }

    public static Context getContext() {
        return c;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getDisplayRotation(Display display) {
        Method method;
        try {
            Method method2;
            method = method2 = Display.class.getMethod("getRotation", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Method method3;
                method = method3 = Display.class.getMethod("getOrientation", null);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                Log.internal(PRODUCT_COMMONS, "Unable to access getOrientation method via reflection");
                return -999;
            }
        }
        if (method == null) return -999;
        try {
            return (Integer)method.invoke((Object)display, (Object[])null);
        }
        catch (Exception exception) {
            Log.internal(PRODUCT_COMMONS, "Unable to access display rotation");
        }
        return -999;
    }

    /*
     * Unable to fully structure code
     */
    public static String getFinalRedirectedUrl(String var0) {
        block9: {
            var1_1 = 0;
            var2_2 = var0;
            while (true) {
                block10: {
                    var6_3 = (HttpURLConnection)new URL(var2_2).openConnection();
                    InternalSDKUtil.addCommonPropertiesToConnection(var6_3);
                    var6_3.setUseCaches(false);
                    var6_3.setRequestMethod("GET");
                    var7_4 = var6_3.getResponseCode();
                    if (var7_4 < 300 || var7_4 >= 400) break block9;
                    var8_5 = var10_6 = var6_3.getHeaderField("Location");
                    if (var8_5 != null) break block10;
                    var8_5 = var2_2;
lbl15:
                    // 4 sources

                    while (true) {
                        var6_3.disconnect();
                        return var8_5;
                        break;
                    }
                }
                var11_7 = var6_3.getResponseCode();
                if (var11_7 == 200) ** GOTO lbl15
                var12_8 = var1_1 + 1;
                if (var1_1 >= 5) ** GOTO lbl15
                var1_1 = var12_8;
                var2_2 = var8_5;
                continue;
                break;
            }
            catch (Exception var3_9) {
                var4_10 = var3_9;
                var5_11 = var2_2;
lbl31:
                // 2 sources

                while (true) {
                    Log.internal("[InMobi]-4.1.1", "Cannot get redirect url", var4_10);
                    return var5_11;
                }
            }
            catch (Exception var9_12) {
                var5_11 = var8_5;
                var4_10 = var9_12;
                ** continue;
            }
        }
        var8_5 = var2_2;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static String getInMobiInternalVersion(String string2) {
        String[] stringArray = string2.split("[.]");
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (true) {
            if (n2 >= stringArray.length) {
                if (!stringBuffer.equals("")) return stringBuffer.substring(1).toString();
                return "";
            }
            try {
                int n3 = 65 + Integer.valueOf(stringArray[n2]);
                stringBuffer.append("T").append((char)n3);
            }
            catch (NumberFormatException numberFormatException) {}
            ++n2;
        }
    }

    public static int getIntFromJSON(JSONObject jSONObject, String string2, int n2) {
        try {
            int n3 = jSONObject.getInt(string2);
            return n3;
        }
        catch (Exception exception) {
            try {
                Log.debug(LOGGING_TAG, "JSON with property " + string2 + " found but has bad datatype(" + jSONObject.get(string2).getClass() + "). Reverting to " + n2);
                return n2;
            }
            catch (JSONException jSONException) {
                return n2;
            }
        }
    }

    public static int getIntFromMap(Map<String, Object> map, String string2, int n2, long l2) {
        int n3;
        Object object = map.get(string2);
        if (object instanceof Integer && (long)(n3 = ((Integer)object).intValue()) <= l2 && n3 >= n2) {
            return n3;
        }
        Log.internal(LOGGING_TAG, "Key " + string2 + " has illegal value");
        throw new IllegalArgumentException();
    }

    public static long getLongFromJSON(JSONObject jSONObject, String string2, long l2) {
        try {
            long l3 = jSONObject.getLong(string2);
            return l3;
        }
        catch (Exception exception) {
            try {
                Log.debug(LOGGING_TAG, "JSON with property " + string2 + " found but has bad datatype(" + jSONObject.get(string2).getClass() + "). Reverting to " + l2);
                return l2;
            }
            catch (JSONException jSONException) {
                return l2;
            }
        }
    }

    public static long getLongFromMap(Map<String, Object> map, String string2, long l2, long l3) {
        long l4;
        Object object = map.get(string2);
        if (object instanceof Long && (l4 = ((Long)object).longValue()) <= l3 && l4 >= l2) {
            return l4;
        }
        if (l2 < Integer.MIN_VALUE) {
            l2 = Integer.MIN_VALUE;
        }
        int n2 = (int)l2;
        if (l3 > Integer.MAX_VALUE) {
            l3 = Integer.MAX_VALUE;
        }
        return InternalSDKUtil.getIntFromMap(map, string2, n2, (int)l3);
    }

    public static String getSavedUserAgent() {
        return b;
    }

    public static String getStringFromJSON(JSONObject jSONObject, String string2, String string3) {
        try {
            String string4 = jSONObject.getString(string2);
            return string4;
        }
        catch (Exception exception) {
            try {
                Log.debug(LOGGING_TAG, "JSON with property " + string2 + " found but has bad datatype(" + jSONObject.get(string2).getClass() + "). Reverting to " + string3);
                return string3;
            }
            catch (JSONException jSONException) {
                return string3;
            }
        }
    }

    public static String getStringFromMap(Map<String, Object> map, String string2) {
        Object object = map.get(string2);
        if (object instanceof String) {
            return (String)object;
        }
        Log.internal(LOGGING_TAG, "Key " + string2 + " has illegal value");
        throw new IllegalArgumentException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUserAgent(Context context) {
        try {
            block6: {
                block5: {
                    if (b != null) break block5;
                    if (Build.VERSION.SDK_INT < 17) break block6;
                    b = com.inmobi.commons.internal.InternalSDKUtil$a.a(context);
                }
                return b;
            }
            b = new WebView(context).getSettings().getUserAgentString();
            return b;
        }
        catch (Exception exception) {
            Log.internal(LOGGING_TAG, "Cannot get user agent", exception);
            return b;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initialize(Context context) {
        if (InternalSDKUtil.getContext() == null) {
            if (context == null) {
                c.getApplicationContext();
            } else {
                c = context.getApplicationContext();
            }
        }
        if (InMobi.getAppId() == null) {
            return;
        }
        if (f) {
            f = false;
            InternalSDKUtil.a();
        }
        try {
            InternalSDKUtil.a(CacheController.getConfig(PRODUCT_COMMONS, context, d, e).getData());
            return;
        }
        catch (CommonsException commonsException) {
            Log.debug(LOGGING_TAG, "IMCommons config init: IMCommonsException caught. Reason: " + commonsException.toString());
            return;
        }
        catch (Exception exception) {
            Log.debug(LOGGING_TAG, "Exception while getting commons config data.");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isDefOrientationLandscape(int n2, int n3, int n4) {
        return n3 > n4 && (n2 == 0 || n2 == 2) || n3 < n4 && (n2 == 1 || n2 == 3);
    }

    public static boolean isInitializedSuccessfully() {
        return InternalSDKUtil.isInitializedSuccessfully(true);
    }

    public static boolean isInitializedSuccessfully(boolean bl2) {
        if (InternalSDKUtil.getContext() == null || InMobi.getAppId() == null) {
            if (bl2) {
                Log.debug(LOGGING_TAG, "InMobi not initialized. Call InMobi.initialize before using any InMobi API");
            }
            return false;
        }
        return true;
    }

    public static boolean isTablet(Context context) {
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        double d2 = (float)displayMetrics.widthPixels / displayMetrics.xdpi;
        double d3 = (float)displayMetrics.heightPixels / displayMetrics.ydpi;
        return Math.sqrt(d2 * d2 + d3 * d3) > 7.0;
    }

    public static void populate(Map<String, Object> map, Map<String, Object> map2, boolean bl2) {
        for (String string2 : map.keySet()) {
            if (map2.get(string2) == null) {
                map2.put(string2, map.get(string2));
            }
            Object object = map.get(string2);
            Object object2 = map2.get(string2);
            if (object instanceof Map && object2 instanceof Map) {
                if (!bl2) {
                    map2.put(string2, object);
                    continue;
                }
                InternalSDKUtil.populate((Map)object, (Map)object2, true);
                continue;
            }
            map2.put(string2, object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static void populate(JSONObject jSONObject, JSONObject jSONObject2, boolean bl2) throws JSONException {
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            Object object;
            String string2;
            block7: {
                string2 = (String)iterator.next();
                try {
                    jSONObject2.get(string2);
                }
                catch (JSONException jSONException) {
                    jSONObject2.put(string2, jSONObject.get(string2));
                    continue;
                }
                object = jSONObject.get(string2);
                Object object2 = jSONObject2.get(string2);
                if (!(object instanceof JSONObject) || !(object2 instanceof JSONObject)) break block7;
                if (!bl2) {
                    jSONObject2.put(string2, object);
                }
                try {
                    InternalSDKUtil.populate((JSONObject)object, (JSONObject)object2, true);
                }
                catch (JSONException jSONException) {
                    Log.internal(LOGGING_TAG, "Cannot populate to json exception", jSONException);
                }
                continue;
            }
            jSONObject2.put(string2, object);
        }
    }

    public static JSONObject populateToNewJSON(JSONObject jSONObject, JSONObject jSONObject2, boolean bl2) throws JSONException {
        JSONObject jSONObject3 = new JSONObject();
        InternalSDKUtil.populate(jSONObject2, jSONObject3, false);
        InternalSDKUtil.populate(jSONObject, jSONObject3, bl2);
        return jSONObject3;
    }

    public static Map<String, Object> populateToNewMap(Map<String, Object> map, Map<String, Object> map2, boolean bl2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        InternalSDKUtil.populate(map2, hashMap, false);
        InternalSDKUtil.populate(map, hashMap, bl2);
        return hashMap;
    }

    public static void setContext(Context context) {
        block5: {
            block4: {
                if (c != null) break block4;
                c = context.getApplicationContext();
                if (InMobi.getAppId() != null) break block5;
            }
            return;
        }
        InternalSDKUtil.a();
        try {
            CacheController.getConfig(PRODUCT_COMMONS, context, d, e);
            return;
        }
        catch (CommonsException commonsException) {
            Log.internal(PRODUCT_COMMONS, "Unable retrive config for commons product");
            return;
        }
    }

    public static boolean validateAppId(String string2) {
        if (string2 == null) {
            Log.debug(LOGGING_TAG, "appId is null");
            return false;
        }
        if (string2.matches("(x)+")) {
            Log.debug(LOGGING_TAG, "appId is all xxxxxxx");
            return false;
        }
        if ("".equals(string2.trim())) {
            Log.debug(LOGGING_TAG, "appId is all blank");
            return false;
        }
        return true;
    }

    @TargetApi(value=17)
    static class a {
        a() {
        }

        static String a(Context context) {
            return WebSettings.getDefaultUserAgent((Context)context);
        }
    }
}

