/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.internal;

import android.content.Context;
import android.content.SharedPreferences;
import com.inmobi.commons.internal.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;

public class FileOperations {
    public static boolean getBooleanPreferences(Context context, String string2, String string3) {
        if (context == null || string2 == null || string3 == null || "".equals(string2.trim()) || "".equals(string3.trim())) {
            Log.debug("[InMobi]-4.1.1", "Failed to get preferences..App context NULL");
            return false;
        }
        return context.getSharedPreferences(string2, 0).getBoolean(string3, false);
    }

    public static int getIntPreferences(Context context, String string2, String string3) {
        if (context == null || string2 == null || string3 == null || "".equals(string2.trim()) || "".equals(string3.trim())) {
            Log.debug("[InMobi]-4.1.1", "Failed to get preferences..App context NULL");
            return 0;
        }
        return context.getSharedPreferences(string2, 0).getInt(string3, 0);
    }

    public static long getLongPreferences(Context context, String string2, String string3) {
        if (context == null || string2 == null || string3 == null || "".equals(string2.trim()) || "".equals(string3.trim())) {
            Log.debug("[InMobi]-4.1.1", "Failed to get preferences..App context NULL");
            return 0L;
        }
        return context.getSharedPreferences(string2, 0).getLong(string3, 0L);
    }

    public static String getPreferences(Context context, String string2, String string3) {
        if (context == null || string2 == null || string3 == null || "".equals(string2.trim()) || "".equals(string3.trim())) {
            Log.debug("[InMobi]-4.1.1", "Failed to get preferences..App context NULL");
            return null;
        }
        return context.getSharedPreferences(string2, 0).getString(string3, null);
    }

    public static boolean isFileExist(Context context, String string2) {
        boolean bl2 = new File(context.getDir("data", 0), string2).exists();
        boolean bl3 = false;
        if (bl2) {
            bl3 = true;
        }
        return bl3;
    }

    public static String readFileAsString(Context context, String string2) throws IOException {
        String string3;
        File file = new File(context.getCacheDir().getAbsolutePath() + File.separator + string2);
        file.createNewFile();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string3 = bufferedReader.readLine()) != null) {
            stringBuffer.append("\n").append(string3);
        }
        bufferedReader.close();
        if (stringBuffer.length() >= 1) {
            return stringBuffer.substring(1).toString();
        }
        return "";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readFromFile(Context context, String string2) {
        ObjectInputStream objectInputStream;
        Object object;
        block15: {
            Object object2;
            object = null;
            if (context == null || string2 == null || "".equals(string2.trim())) {
                Log.internal("[InMobi]-4.1.1", "Cannot read map application context or Filename NULL");
                return object;
            }
            File file = new File(context.getDir("data", 0), string2);
            ObjectInputStream objectInputStream2 = new ObjectInputStream(new FileInputStream(file));
            object = object2 = objectInputStream2.readObject();
            objectInputStream = objectInputStream2;
            break block15;
            catch (EOFException eOFException) {
                block16: {
                    objectInputStream2 = null;
                    break block16;
                    catch (FileNotFoundException fileNotFoundException) {
                        FileNotFoundException fileNotFoundException2;
                        block17: {
                            objectInputStream = null;
                            break block17;
                            catch (StreamCorruptedException streamCorruptedException) {
                                StreamCorruptedException streamCorruptedException2;
                                block18: {
                                    objectInputStream = null;
                                    break block18;
                                    catch (IOException iOException) {
                                        IOException iOException2;
                                        block19: {
                                            objectInputStream = null;
                                            break block19;
                                            catch (ClassNotFoundException classNotFoundException) {
                                                ClassNotFoundException classNotFoundException2;
                                                block20: {
                                                    objectInputStream = null;
                                                    break block20;
                                                    catch (ClassNotFoundException classNotFoundException3) {
                                                        objectInputStream = objectInputStream2;
                                                        classNotFoundException2 = classNotFoundException3;
                                                    }
                                                }
                                                Log.internal("[InMobi]-4.1.1", "Error: class not found", classNotFoundException2);
                                                object = null;
                                            }
                                            catch (IOException iOException3) {
                                                objectInputStream = objectInputStream2;
                                                iOException2 = iOException3;
                                            }
                                        }
                                        Log.internal("[InMobi]-4.1.1", "Event log File IO Exception", iOException2);
                                        object = null;
                                    }
                                    catch (StreamCorruptedException streamCorruptedException3) {
                                        objectInputStream = objectInputStream2;
                                        streamCorruptedException2 = streamCorruptedException3;
                                    }
                                }
                                Log.internal("[InMobi]-4.1.1", "Event log File corrupted", streamCorruptedException2);
                                object = null;
                            }
                            catch (FileNotFoundException fileNotFoundException3) {
                                objectInputStream = objectInputStream2;
                                fileNotFoundException2 = fileNotFoundException3;
                            }
                        }
                        Log.internal("[InMobi]-4.1.1", "Event log File doesnot exist", fileNotFoundException2);
                        object = null;
                    }
                    catch (EOFException eOFException2) {}
                }
                Log.internal("[InMobi]-4.1.1", "End of File reached");
                objectInputStream = objectInputStream2;
                object = null;
            }
        }
        if (objectInputStream == null) return object;
        try {
            objectInputStream.close();
            return object;
        }
        catch (IOException iOException) {
            Log.internal("[InMobi]-4.1.1", "Log File Close Exception");
            return false;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean saveToFile(Context context, String string2, Object object) {
        block6: {
            if (context == null || string2 == null || "".equals(string2.trim()) || object == null) {
                Log.internal("[InMobi]-4.1.1", "Cannot read map application context of Filename NULL");
                return false;
            }
            File file = new File(context.getDir("data", 0), string2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file, false));
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            if (objectOutputStream == null) break block6;
            try {
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                Log.internal("[InMobi]-4.1.1", "Log File Close Exception");
                return false;
            }
        }
        return true;
        catch (FileNotFoundException fileNotFoundException) {
            Log.internal("[InMobi]-4.1.1", "Log File Not found", fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            Log.internal("[InMobi]-4.1.1", "Log File IO Exception", iOException);
            return false;
        }
    }

    public static void setPreferences(Context context, String string2, String string3, float f2) {
        if (context == null || string2 == null || string3 == null || "".equals(string2.trim()) || "".equals(string3.trim())) {
            Log.debug("[InMobi]-4.1.1", "Failed to set preferences..App context NULL");
            return;
        }
        SharedPreferences.Editor editor = context.getSharedPreferences(string2, 0).edit();
        editor.putFloat(string3, f2);
        editor.commit();
    }

    public static void setPreferences(Context context, String string2, String string3, int n2) {
        if (context == null || string2 == null || string3 == null || "".equals(string2.trim()) || "".equals(string3.trim())) {
            Log.debug("[InMobi]-4.1.1", "Failed to set preferences..App context NULL");
            return;
        }
        SharedPreferences.Editor editor = context.getSharedPreferences(string2, 0).edit();
        editor.putInt(string3, n2);
        editor.commit();
    }

    public static void setPreferences(Context context, String string2, String string3, long l2) {
        if (context == null || string2 == null || string3 == null || "".equals(string2.trim()) || "".equals(string3.trim())) {
            Log.debug("[InMobi]-4.1.1", "Failed to set preferences..App context NULL");
            return;
        }
        SharedPreferences.Editor editor = context.getSharedPreferences(string2, 0).edit();
        editor.putLong(string3, l2);
        editor.commit();
    }

    public static void setPreferences(Context context, String string2, String string3, boolean bl2) {
        if (context == null || string2 == null || string3 == null || "".equals(string2.trim()) || "".equals(string3.trim())) {
            Log.debug("[InMobi]-4.1.1", "Failed to set preferences..App context NULL");
            return;
        }
        SharedPreferences.Editor editor = context.getSharedPreferences(string2, 0).edit();
        editor.putBoolean(string3, bl2);
        editor.commit();
    }

    public static boolean setPreferences(Context context, String string2, String string3, String string4) {
        if (context == null || string2 == null || string3 == null || "".equals(string2.trim()) || "".equals(string3.trim())) {
            Log.internal("[InMobi]-4.1.1", "Failed to set preferences..App context NULL");
            return false;
        }
        SharedPreferences.Editor editor = context.getSharedPreferences(string2, 0).edit();
        editor.putString(string3, string4);
        editor.commit();
        return true;
    }

    public static void writeStringToFile(Context context, String string2, String string3, boolean bl2) throws IOException {
        File file = new File(context.getCacheDir().getAbsolutePath() + File.separator + string2);
        file.createNewFile();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, bl2));
        bufferedWriter.write(string3);
        bufferedWriter.close();
    }
}

