/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.internal;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.inmobi.commons.analytics.bootstrapper.AnalyticsInitializer;
import com.inmobi.commons.internal.FileOperations;
import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.Log;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppDetectionManager {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONArray getInstalledApps() {
        JSONArray jSONArray;
        try {
            if (!AnalyticsInitializer.getConfigParams().getThinIceConfig().isAppDetectionEnabled()) return null;
            if (FileOperations.getLongPreferences(InternalSDKUtil.getContext(), "AppDetectionPrefs", "AppDetectionCollectionTimestamp") + AnalyticsInitializer.getConfigParams().getThinIceConfig().getAppDetectionInterval() >= System.currentTimeMillis()) return null;
            PackageManager packageManager = InternalSDKUtil.getContext().getPackageManager();
            jSONArray = new JSONArray();
            for (ApplicationInfo applicationInfo : packageManager.getInstalledApplications(128)) {
                JSONObject jSONObject = new JSONObject();
                String string2 = applicationInfo.packageName;
                boolean bl2 = (1 & applicationInfo.flags) != 0;
                jSONObject.put("a-bid", (Object)string2);
                jSONObject.put("a-system", bl2);
                jSONArray.put((Object)jSONObject);
            }
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-4.1.1", "Exception fetching app meta data", exception);
            return null;
        }
        {
            if (jSONArray.length() == 0) {
                return null;
            }
            JSONArray jSONArray2 = jSONArray;
            if (jSONArray2 == null) return jSONArray2;
            FileOperations.setPreferences(InternalSDKUtil.getContext(), "AppDetectionPrefs", "AppDetectionCollectionTimestamp", System.currentTimeMillis());
            return jSONArray2;
        }
    }
}

