/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.inmobi.commons.db.ColumnData;
import com.inmobi.commons.db.TableData;
import com.inmobi.commons.internal.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;

public abstract class DatabaseHandler
extends SQLiteOpenHelper {
    public static final String DATABASE_NAME = "im.db";
    private static String c = "CREATE TABLE IF NOT EXISTS ";
    private static String d = "DROP TABLE IF EXISTS ";
    private static String e = " PRIMARY KEY ";
    private static String f = " AUTOINCREMENT ";
    private static String g = " NOT NULL ";
    private static String h = "SELECT * FROM ";
    private static String i = " WHERE ";
    private static String j = " ORDER BY ";
    private static String k = "; ";
    private static String l = " Limit ?";
    private ArrayList<TableData> a;
    private SQLiteDatabase b;

    protected DatabaseHandler(Context context, ArrayList<TableData> arrayList) {
        super(context, DATABASE_NAME, null, 1);
        this.a = arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(SQLiteDatabase sQLiteDatabase) {
        try {
            if (this.a == null || this.a.isEmpty()) return;
            for (TableData tableData : this.a) {
                String string2;
                String string3 = tableData.getmTableName();
                LinkedHashMap<String, ColumnData> linkedHashMap = tableData.getmColumns();
                StringBuilder stringBuilder = new StringBuilder(c + string3 + " (");
                for (String string4 : linkedHashMap.keySet()) {
                    ColumnData columnData = linkedHashMap.get(string4);
                    stringBuilder.append(" " + string4 + " " + columnData.getDataType().toString());
                    if (columnData.isPrimaryKey()) {
                        stringBuilder.append(e);
                    }
                    if (columnData.isAutoIncrement()) {
                        stringBuilder.append(f);
                    }
                    if (columnData.isMandatory()) {
                        stringBuilder.append(g);
                    }
                    stringBuilder.append(",");
                }
                String string5 = ',' == stringBuilder.charAt(-1 + stringBuilder.length()) ? stringBuilder.substring(0, -2 + stringBuilder.length()) : (string2 = stringBuilder.toString());
                String string6 = string5.concat(" );");
                Log.internal("[InMobi]-4.1.1", "Table: " + string6);
                sQLiteDatabase.execSQL(string6);
            }
            return;
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-4.1.1", "Exception creating table", exception);
        }
    }

    public void close() {
        try {
            this.b.close();
            return;
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-4.1.1", "Failed to close  db", exception);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int delete(String string2, String string3, String[] stringArray) {
        synchronized (this) {
            try {
                int n2 = this.b.delete(string2, string3, stringArray);
                return n2;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-4.1.1", "Failed to insert to db", exception);
                return -1;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cursor executeQuery(String string2, String[] stringArray) {
        synchronized (this) {
            try {
                Cursor cursor = this.b.rawQuery(string2, stringArray);
                return cursor;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-4.1.1", "Failed to execute db query", exception);
                return null;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cursor getAll(String var1_1, String var2_2) {
        synchronized (this) {
            block7: {
                if (var2_2 == null) ** GOTO lbl5
                if (!"".equals(var2_2.trim())) break block7;
lbl5:
                // 2 sources

                var6_3 = this.b.rawQuery(DatabaseHandler.h + var1_1 + DatabaseHandler.k, null);
lbl6:
                // 2 sources

                while (true) {
                    var6_3.moveToFirst();
                    return var6_3;
                }
            }
            try {
                var6_3 = var8_5 = this.b.rawQuery(DatabaseHandler.h + var1_1 + DatabaseHandler.j + var2_2 + DatabaseHandler.k, null);
                ** continue;
            }
            catch (Exception var4_6) {
                Log.internal("[InMobi]-4.1.1", "Failed to all rows", var4_6);
                return null;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cursor getNRows(String var1_1, String var2_2, int var3_3) {
        synchronized (this) {
            block7: {
                if (var2_2 == null) ** GOTO lbl5
                if (!"".equals(var2_2.trim())) break block7;
lbl5:
                // 2 sources

                var7_4 = this.b.rawQuery(DatabaseHandler.h + var1_1 + DatabaseHandler.k, null);
lbl6:
                // 2 sources

                while (true) {
                    var7_4.moveToFirst();
                    return var7_4;
                }
            }
            try {
                var9_6 = this.b;
                var10_7 = DatabaseHandler.h + var1_1 + DatabaseHandler.j + var2_2 + DatabaseHandler.l + DatabaseHandler.k;
                var11_8 = new String[]{String.valueOf(var3_3)};
                var7_4 = var12_9 = var9_6.rawQuery(var10_7, var11_8);
                ** continue;
            }
            catch (Exception var5_10) {
                Log.internal("[InMobi]-4.1.1", "Failed to all rows", var5_10);
                return null;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public int getNoOfRows(String var1_1, String var2_2, String[] var3_3) {
        synchronized (this) {
            block9: {
                if (var2_2 != null) {
                    if ("".equals(var2_2.trim())) break block9;
                    var8_4 = this.b.rawQuery(DatabaseHandler.h + var1_1 + DatabaseHandler.i + var2_2, var3_3);
lbl6:
                    // 2 sources

                    while (true) {
                        var6_5 = var8_4.getCount();
                        var8_4.close();
lbl9:
                        // 2 sources

                        return var6_5;
                    }
                }
            }
            try {
                var8_4 = var7_6 = this.b.rawQuery(DatabaseHandler.h + var1_1 + DatabaseHandler.k, null);
                ** continue;
            }
            catch (Exception var5_7) {
                Log.internal("[InMobi]-4.1.1", "Failed to get number of rows", var5_7);
                var6_5 = 0;
                ** continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cursor getRow(String var1_1, String var2_2, String[] var3_3) {
        synchronized (this) {
            block7: {
                if (var2_2 == null) ** GOTO lbl5
                if (!"".equals(var2_2.trim())) break block7;
lbl5:
                // 2 sources

                var7_4 = this.b.rawQuery(DatabaseHandler.h + var1_1 + DatabaseHandler.k, null);
lbl6:
                // 2 sources

                while (true) {
                    var7_4.moveToFirst();
                    return var7_4;
                }
            }
            try {
                var7_4 = var9_6 = this.b.rawQuery(DatabaseHandler.h + var1_1 + DatabaseHandler.i + var2_2 + DatabaseHandler.k, var3_3);
                ** continue;
            }
            catch (Exception var5_7) {
                Log.internal("[InMobi]-4.1.1", "Failed to all rows", var5_7);
                return null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getTableSize(String string2) {
        synchronized (this) {
            try {
                Cursor cursor = this.b.rawQuery(h + string2 + k, null);
                int n2 = cursor.getCount();
                cursor.close();
                return n2;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-4.1.1", "Failed to table size ", exception);
                return 0;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long insert(String string2, ContentValues contentValues) {
        synchronized (this) {
            try {
                long l2 = this.b.insert(string2, null, contentValues);
                return l2;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-4.1.1", "Failed to insert to db", exception);
                return -1L;
            }
        }
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        try {
            this.a(sQLiteDatabase);
            return;
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-4.1.1", "Exception Creating table", exception);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n2, int n3) {
        try {
            Iterator<TableData> iterator = this.a.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().getmTableName();
                sQLiteDatabase.execSQL(d + string2);
            }
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-4.1.1", "Exception Deleting table", exception);
            return;
        }
        {
            this.onCreate(sQLiteDatabase);
            return;
        }
    }

    public void open() {
        try {
            this.b = this.getWritableDatabase();
            return;
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-4.1.1", "Failed to open  db", exception);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long update(String string2, ContentValues contentValues, String string3, String[] stringArray) {
        synchronized (this) {
            int n2;
            try {
                n2 = this.b.update(string2, contentValues, string3, stringArray);
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-4.1.1", "Failed to insert to db", exception);
                return -1L;
            }
            return n2;
        }
    }
}

