/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.cache;

import com.inmobi.commons.cache.CacheController;
import com.inmobi.commons.cache.ProductConfig;
import com.inmobi.commons.cache.RetryMechanism;
import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.Log;
import com.inmobi.commons.uid.UIDUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class ProductCacheConfig
extends ProductConfig {
    public static final int DEFAULT_EXPIRY = 432000;
    public static final int DEFAULT_INTERVAL = 60;
    public static final int DEFAULT_MAX_RETRY = 3;
    private static Timer a = new Timer();
    private AtomicBoolean b = new AtomicBoolean(false);
    private Map<String, String> c = new HashMap<String, String>();
    private CacheController.Validator d = null;
    private RetryMechanism e = new RetryMechanism(3, 60000, a);
    private CacheController.Committer f;
    private long g;

    public ProductCacheConfig(JSONObject jSONObject) {
        try {
            this.loadFromJSON(jSONObject);
            return;
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-4.1.1", "JSON retrieved is invalid.");
            return;
        }
    }

    public ProductCacheConfig(JSONObject jSONObject, CacheController.Committer committer) {
        this(jSONObject);
        this.f = committer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a() throws Exception {
        b b2;
        try {
            b2 = this.c();
            String string2 = b2.b;
            if (string2 != null) {
                if (this.d != null) {
                    if (!this.d.validate(this.a(string2))) {
                        throw new IOException("Invalid config.");
                    }
                    this.setData(string2);
                } else {
                    this.setData(string2);
                }
                this.setTimestamp((int)(System.currentTimeMillis() / 1000L));
                this.g = b2.c;
                Log.internal("[InMobi]-4.1.1", "Product with url " + this.getUrl() + " accepted data " + this.getRawData());
                this.f.onCommit();
                return;
            }
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-4.1.1", "Error connecting to url, or " + this.getUrl() + " did not return 200. Purge cache update.", exception);
            throw exception;
        }
        this.setTimestamp((int)(System.currentTimeMillis() / 1000L));
        this.g = b2.c;
        this.f.onCommit();
    }

    private void b() {
        if (!this.b.compareAndSet(false, true)) {
            return;
        }
        this.e.rescheduleTimer(new RetryMechanism.RetryRunnable(){

            @Override
            public void completed() {
                ProductCacheConfig.this.b.set(false);
            }

            @Override
            public void run() throws Exception {
                if (InternalSDKUtil.checkNetworkAvailibility(InternalSDKUtil.getContext())) {
                    ProductCacheConfig.this.a();
                    return;
                }
                throw new IOException("Network unavailable");
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private b c() throws IOException {
        String string2 = "";
        String string3 = UIDUtil.bindToGetParam(this.c);
        String string4 = string3 != null && !"".equals(string3) ? (this.getUrl().endsWith("?") ? this.getUrl() + string3 : (this.getUrl().contains("?") ? this.getUrl() + "&" + string3 : this.getUrl() + "?" + string3)) : this.getUrl();
        URL uRL = new URL(string4);
        Log.internal("[InMobi]-4.1.1", "Sending request to " + string4 + " to retreive cache..");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        InternalSDKUtil.addCommonPropertiesToConnection(httpURLConnection);
        httpURLConnection.setIfModifiedSince(this.g);
        httpURLConnection.setRequestMethod("GET");
        int n2 = httpURLConnection.getResponseCode();
        if (n2 == 304) {
            b b2 = new b();
            com.inmobi.commons.cache.ProductCacheConfig$b.a(b2, null);
            com.inmobi.commons.cache.ProductCacheConfig$b.a(b2, httpURLConnection.getLastModified());
            return b2;
        }
        if (n2 != 200) {
            throw new IOException("Server did not return 200. ");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        while (true) {
            String string5;
            if ((string5 = bufferedReader.readLine()) == null) {
                bufferedReader.close();
                b b3 = new b();
                com.inmobi.commons.cache.ProductCacheConfig$b.a(b3, string2);
                com.inmobi.commons.cache.ProductCacheConfig$b.a(b3, httpURLConnection.getLastModified());
                return b3;
            }
            string2 = string2 + string5;
        }
    }

    public ProductConfig getConfig() {
        return this;
    }

    public String getData(CacheController.Validator validator) {
        if (validator != null) {
            this.d = validator;
        }
        this.setRetryNumber(0);
        int n2 = (int)(System.currentTimeMillis() / 1000L);
        if (this.getTimestamp() + this.getExpiry() - n2 <= 0) {
            this.b();
        }
        return this.getRawData();
    }

    public String getData(Map<String, String> map, CacheController.Validator validator) {
        if (map != null) {
            this.c = map;
        }
        return this.getData(validator);
    }

    public Map<String, String> getMap() {
        return this.c;
    }

    public CacheController.Validator getValidator() {
        return this.d;
    }

    public final void loadFromJSON(JSONObject jSONObject) {
        this.setExpiry(InternalSDKUtil.getIntFromJSON(jSONObject, "expiry", 432000));
        this.setMaxRetry(InternalSDKUtil.getIntFromJSON(jSONObject, "maxRetry", 3));
        this.setRetryInterval(InternalSDKUtil.getIntFromJSON(jSONObject, "retryInterval", 60));
        this.g = InternalSDKUtil.getLongFromJSON(jSONObject, "lastModified", 0L);
        this.setUrl(InternalSDKUtil.getStringFromJSON(jSONObject, "url", ""));
        this.setProtocol(InternalSDKUtil.getStringFromJSON(jSONObject, "protocol", "json"));
        this.e = new RetryMechanism(this.getMaxRetry(), 1000 * this.getRetryInterval(), a);
        this.setTimestamp(InternalSDKUtil.getIntFromJSON(jSONObject, "timestamp", 0));
        this.setData(InternalSDKUtil.getStringFromJSON(jSONObject, "data", null));
    }

    protected void reset() {
        this.setExpiry(0);
        this.setRetryInterval(0);
        this.setMaxRetry(0);
        this.setTimestamp(0);
        this.setUrl(null);
        this.setProtocol(null);
        this.setData(null);
    }

    public void setMap(Map<String, String> map) {
        this.c = map;
    }

    public void setValidator(CacheController.Validator validator) {
        this.d = validator;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject toJSON() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject = new JSONObject("{expiry:" + this.getExpiry() + "," + "maxRetry:" + this.getMaxRetry() + "," + "retryInterval:" + this.getRetryInterval() + "," + "protocol:" + this.getProtocol() + ",timestamp:" + this.getTimestamp() + "}");
        }
        catch (JSONException jSONException) {
            jSONObject = jSONObject2;
            JSONException jSONException2 = jSONException;
            Log.internal("[InMobi]-4.1.1", "Ill formed JSON product(" + this.getUrl() + ") toString", jSONException2);
            return jSONObject;
        }
        jSONObject.put("url", (Object)this.getUrl());
        jSONObject.put("data", (Object)this.getRawData());
        jSONObject.put("lastModified", this.g);
        return jSONObject;
        {
            catch (JSONException jSONException) {}
        }
    }

    public String toString() {
        return this.toJSON().toString();
    }

    private class b {
        private String b;
        private long c;

        private b() {
        }

        static /* synthetic */ long a(b b2, long l2) {
            b2.c = l2;
            return l2;
        }

        static /* synthetic */ String a(b b2, String string2) {
            b2.b = string2;
            return string2;
        }
    }
}

