/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.analytics.net;

import android.content.Context;
import android.os.Build;
import com.inmobi.commons.analytics.db.AnalyticsEvent;
import com.inmobi.commons.analytics.net.AnalyticsPayload;
import com.inmobi.commons.analytics.util.AnalyticsUtils;
import com.inmobi.commons.analytics.util.SessionInfo;
import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.Log;
import com.inmobi.commons.thirdparty.Base62;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsPayloadBuilder {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONArray a(List<AnalyticsEvent> list) {
        JSONArray jSONArray = new JSONArray();
        Iterator<AnalyticsEvent> iterator = list.iterator();
        while (true) {
            JSONObject jSONObject;
            block13: {
                AnalyticsEvent analyticsEvent;
                block14: {
                    if (!iterator.hasNext()) {
                        return jSONArray;
                    }
                    analyticsEvent = iterator.next();
                    jSONObject = new JSONObject();
                    String string2 = Base62.fromBase10(analyticsEvent.getEventId());
                    if (string2 != null) {
                        jSONObject.put("eid", (Object)string2);
                    }
                    jSONObject.put("t", (Object)analyticsEvent.getEventType());
                    jSONObject.put("ts", analyticsEvent.getEventTimeStamp());
                    jSONObject.put("ld", (Object)analyticsEvent.getEventLevelId());
                    jSONObject.put("ls", (Object)analyticsEvent.getEventLevelStatus());
                    jSONObject.put("ln", (Object)analyticsEvent.getEventLevelName());
                    String string3 = analyticsEvent.getEventAttributeMap();
                    if (string3 == null) break block14;
                    try {
                        jSONObject.put("am", (Object)new JSONObject(analyticsEvent.getEventAttributeMap()));
                    }
                    catch (Exception exception) {
                        Log.debug("[InMobi]-[Analytics]-4.1.1", "Events attribute map is incorrect. Not sending custom event map.");
                    }
                }
                try {
                    jSONObject.put("tt", (Object)analyticsEvent.getEventTimeTaken());
                    if (analyticsEvent.getEventAttemptCount() != null) {
                        jSONObject.put("ac", 1);
                    }
                    jSONObject.put("at", (Object)analyticsEvent.getEventAttemptTime());
                    jSONObject.put("en", (Object)analyticsEvent.getEventCustomName());
                    if (!"pi".equals(analyticsEvent.getEventType())) break block13;
                    jSONObject.put("in", (Object)analyticsEvent.getTransactionItemName());
                    int n2 = analyticsEvent.getTransactionItemCount();
                    if (n2 > 0) {
                        jSONObject.put("n", n2);
                    }
                    jSONObject.put("id", (Object)analyticsEvent.getTransactionItemDescription());
                    jSONObject.put("ip", analyticsEvent.getTransactionItemPrice());
                    jSONObject.put("c", (Object)analyticsEvent.getTransactionCurrencyCode());
                    jSONObject.put("pi", (Object)analyticsEvent.getTransactionProductId());
                    jSONObject.put("ti", (Object)analyticsEvent.getTransactionId());
                    int n3 = analyticsEvent.getTransactionItemType();
                    if (AnalyticsEvent.TRANSACTION_ITEM_TYPE.INVALID.getValue() != n3) {
                        jSONObject.put("it", n3);
                    }
                    int n4 = analyticsEvent.getTransactionStatus();
                    if (AnalyticsEvent.TRANSACTION_STATUS_SERVER_CODE.INVALID.getValue() != n4) {
                        jSONObject.put("tp", n4);
                    }
                }
                catch (Exception exception) {
                    Log.internal("[InMobi]-[Analytics]-4.1.1", "Creation of events json object failed", exception);
                }
            }
            jSONArray.put((Object)jSONObject);
        }
    }

    private JSONObject a(String string2, long l2, Context context) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("ft", SessionInfo.getFirstTime());
            jSONObject.put("a", (Object)context.getPackageName());
            jSONObject.put("an", (Object)AnalyticsUtils.getApplicationName(context));
            jSONObject.put("av", (Object)AnalyticsUtils.getAppVersion(context));
            jSONObject.put("p", (Object)"android");
            jSONObject.put("pv", (Object)Build.VERSION.RELEASE);
            jSONObject.put("ca", (Object)InternalSDKUtil.getConnectivityType(context));
            jSONObject.put("ma", (Object)Build.MANUFACTURER);
            jSONObject.put("mo", (Object)Build.MODEL);
            jSONObject.put("ss", (Object)string2);
            jSONObject.put("sts", l2);
            jSONObject.put("sv", (Object)"4.1.1");
            jSONObject.put("co", AnalyticsUtils.getCountryISO(context));
            return jSONObject;
        }
        catch (JSONException jSONException) {
            Log.internal("[InMobi]-[Analytics]-4.1.1", "Creation of session object failed", jSONException);
            return jSONObject;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject a(JSONObject jSONObject, JSONArray jSONArray) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.put("session", (Object)jSONObject);
        }
        catch (JSONException jSONException) {
            Log.internal("[InMobi]-[Analytics]-4.1.1", "Session addition to payload failed");
        }
        try {
            jSONObject2.put("events", (Object)jSONArray);
            return jSONObject2;
        }
        catch (JSONException jSONException) {
            Log.internal("[InMobi]-[Analytics]-4.1.1", "Events addition to payload failed");
            return jSONObject2;
        }
    }

    public AnalyticsPayload getPayloadList(List<AnalyticsEvent> list, Context context) {
        Log.debug("[InMobi]-[Analytics]-4.1.1", "PayloadBuilder->getPayloadList:");
        JSONArray jSONArray = new JSONArray();
        ArrayList<AnalyticsEvent> arrayList = new ArrayList<AnalyticsEvent>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        int n2 = 0;
        while (n2 < list.size()) {
            int n3;
            arrayList.clear();
            AnalyticsEvent analyticsEvent = list.get(n2);
            String string2 = analyticsEvent.getEventSessionId();
            for (n3 = n2; n3 < list.size() && string2.equals(list.get(n3).getEventSessionId()); ++n3) {
                arrayList2.add(list.get(n3).getEventTableId());
                arrayList.add(list.get(n3));
            }
            JSONArray jSONArray2 = this.a(arrayList);
            jSONArray.put((Object)this.a(this.a(string2, analyticsEvent.getEventSessionTimeStamp(), context), jSONArray2));
            n2 = n3;
        }
        AnalyticsPayload analyticsPayload = new AnalyticsPayload(null, arrayList2);
        if (jSONArray.length() != 0) {
            analyticsPayload.setCompletePayload(jSONArray.toString());
            analyticsPayload.setPayloadSize(list.size());
        }
        return analyticsPayload;
    }
}

