/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.analytics.iat.impl;

import com.inmobi.commons.analytics.iat.impl.AdTrackerUtils;
import com.inmobi.commons.analytics.iat.impl.Goal;
import com.inmobi.commons.analytics.iat.impl.config.AdTrackerEventType;
import com.inmobi.commons.analytics.iat.impl.config.AdTrackerInitializer;
import com.inmobi.commons.analytics.iat.impl.net.AdTrackerNetworkInterface;
import com.inmobi.commons.internal.FileOperations;
import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.Log;
import java.util.Vector;

public class GoalList
extends Vector<Goal> {
    public static GoalList getLoggedGoals() {
        boolean bl2 = FileOperations.isFileExist(InternalSDKUtil.getContext(), "eventlog");
        GoalList goalList = null;
        if (bl2) {
            goalList = (GoalList)FileOperations.readFromFile(InternalSDKUtil.getContext(), "eventlog");
        }
        if (goalList == null) {
            goalList = new GoalList();
        }
        return goalList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addGoal(String string2, int n2, long l2, int n3, boolean bl2) {
        AdTrackerNetworkInterface.setSynced(false);
        if (string2 == null || "".equals(string2.trim())) {
            Log.debug("[InMobi]-[AdTracker]-4.1.1", "GoalName is null");
            return false;
        }
        if (n2 < 1 || l2 < 0L) {
            Log.internal("[InMobi]-[AdTracker]-4.1.1", "GoalCount cant be 0 or RetryTime cannot be negative");
            return false;
        }
        try {
            for (Goal goal : this) {
                if (!goal.getGoalName().equals(string2)) continue;
                if (!"download".equals(string2)) {
                    goal.setGoalCount(n2 + goal.getGoalCount());
                }
                goal.setRetryCount(n3);
                goal.setRetryTime(l2);
                goal.setDuplicateGoal(bl2);
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        boolean bl3 = false;
        if (bl3) return true;
        this.add(new Goal(string2, n2, l2, n3, bl2));
        return true;
    }

    public Goal getGoal(String string2) {
        if (string2 == null || "".equals(string2.trim())) {
            Log.debug("[InMobi]-[AdTracker]-4.1.1", "GoalName is null");
            return null;
        }
        try {
            for (Goal goal : this) {
                boolean bl2 = goal.getGoalName().equals(string2);
                if (!bl2) continue;
                return goal;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean increaseRetryTime(String var1_1, int var2_2, boolean var3_3) {
        block10: {
            block8: {
                if (var1_1 == null) ** GOTO lbl4
                if (!"".equals(var1_1.trim())) break block8;
lbl4:
                // 2 sources

                Log.internal("[InMobi]-[AdTracker]-4.1.1", "GoalName cannot be null");
                return false;
            }
            var5_4 = this.getGoal(var1_1);
            var6_5 = AdTrackerInitializer.getConfigParams().getRetryParams().getMaxWaitTime();
            var7_6 = AdTrackerInitializer.getConfigParams().getRetryParams().getMaxRetry();
            if (var5_4 == null) ** GOTO lbl33
            var8_7 = var5_4.getRetryTime();
            var10_8 = var5_4.getRetryCount();
            if (var8_7 >= (long)var6_5) break block10;
            var11_9 = 30000L + var8_7 * 2L;
            if (var11_9 > (long)var6_5) {
                var11_9 = var6_5;
            }
lbl19:
            // 4 sources

            while (true) {
                block9: {
                    this.removeGoal(var1_1, var2_2);
                    var14_10 = var10_8 + 1;
                    if (var14_10 >= var7_6) ** GOTO lbl29
                    try {
                        this.addGoal(var1_1, var2_2, var11_9, var14_10, var3_3);
                        break block9;
lbl29:
                        // 1 sources

                        AdTrackerUtils.reportMetric(AdTrackerEventType.GOAL_DUMPED, var5_4, 0, 0L, 0, null);
                        break block9;
                    }
                    catch (Exception var4_11) {
                        Log.internal("[InMobi]-[AdTracker]-4.1.1", "Cant increase retry time", var4_11);
                    }
lbl33:
                    // 2 sources

                    return false;
                }
                return true;
            }
        }
        var11_9 = var6_5;
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeGoal(String string2, int n2) {
        int n3;
        Goal goal2;
        block6: {
            AdTrackerNetworkInterface.setSynced(false);
            if (string2 == null || "".equals(string2.trim())) {
                Log.debug("[InMobi]-[AdTracker]-4.1.1", "GoalName is null");
                return false;
            }
            if (n2 < 1) {
                Log.internal("[InMobi]-[AdTracker]-4.1.1", "GoalCount cannot be 0 or negative");
                return false;
            }
            for (Goal goal2 : this) {
                if (!goal2.getGoalName().equals(string2)) continue;
                n3 = goal2.getGoalCount() - n2;
                if (string2.equals("download")) {
                    this.remove(goal2);
                    return true;
                }
                break block6;
            }
            return true;
        }
        if (n3 <= 0) {
            this.remove(goal2);
            return true;
        }
        goal2.setGoalCount(n3);
        return true;
    }

    public void saveGoals() {
        FileOperations.saveToFile(InternalSDKUtil.getContext(), "eventlog", this);
    }
}

