/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.analytics.iat.impl;

import android.content.Context;
import android.content.Intent;
import com.inmobi.commons.analytics.iat.impl.Goal;
import com.inmobi.commons.analytics.iat.impl.config.AdTrackerEventType;
import com.inmobi.commons.analytics.iat.impl.config.AdTrackerInitializer;
import com.inmobi.commons.analytics.iat.impl.net.AdTrackerNetworkInterface;
import com.inmobi.commons.internal.FileOperations;
import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.Log;
import com.inmobi.commons.metric.EventLog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class AdTrackerUtils {
    public static boolean checkDownloadGoalAdded() {
        if (InternalSDKUtil.getContext() == null) {
            Log.internal("[InMobi]-[AdTracker]-4.1.1", "Application Context NULL cannot checkStatusUpload");
            return false;
        }
        return FileOperations.getBooleanPreferences(InternalSDKUtil.getContext(), "IMAdTrackerStatusUpload", "insertStatus");
    }

    public static boolean checkDownloadGoalUploaded() {
        if (InternalSDKUtil.getContext() == null) {
            Log.internal("[InMobi]-[AdTracker]-4.1.1", "Application Context NULL cannot checkStatusUpload");
            return false;
        }
        return FileOperations.getBooleanPreferences(InternalSDKUtil.getContext(), "IMAdTrackerStatusUpload", "uploadStatus");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getReferrerFromLogs() {
        String[] stringArray = new String[]{"logcat", "-d", "ActivityManager:I"};
        Log.internal("[InMobi]-[AdTracker]-4.1.1", "Getting referrer from logs");
        Pattern pattern = Pattern.compile(AdTrackerInitializer.getConfigParams().getLogcatPattern());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(stringArray).getInputStream()));
        String string2 = null;
        while (true) {
            String string3;
            if ((string3 = bufferedReader.readLine()) == null) {
                Log.internal("[InMobi]-[AdTracker]-4.1.1", "Received referrer from logs: " + string2);
                return string2;
            }
            Matcher matcher = pattern.matcher(string3);
            if (!matcher.find()) continue;
            string2 = matcher.group(1);
        }
        {
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            string2 = null;
            Exception exception2 = exception;
            Log.internal("[InMobi]-[AdTracker]-4.1.1", "Getting referrer from logs failed", exception2);
            return string2;
        }
    }

    public static boolean isPermissionGranted(String string2) {
        try {
            int n2 = InternalSDKUtil.getContext().checkCallingOrSelfPermission(string2);
            if (n2 == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-[AdTracker]-4.1.1", "Cant check permissions", exception);
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void reportMetric(AdTrackerEventType adTrackerEventType, Goal goal, int n2, long l2, int n3, String string2) {
        block6: {
            try {
                if (!AdTrackerNetworkInterface.isMetricSample()) break block6;
                if (AdTrackerEventType.GOAL_SUCCESS.equals(adTrackerEventType)) {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("g", (Object)goal.getGoalName());
                    jSONObject.put("n", goal.getRetryCount());
                    jSONObject.put("t", l2);
                    jSONObject.put("r", n2);
                    AdTrackerInitializer.getLogger().logEvent(new EventLog(AdTrackerEventType.GOAL_SUCCESS, jSONObject));
                    return;
                }
                if (AdTrackerEventType.GOAL_FAILURE.equals(adTrackerEventType)) {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("g", (Object)goal.getGoalName());
                    jSONObject.put("n", goal.getRetryCount());
                    jSONObject.put("e", n3);
                    if (string2 != null) {
                        jSONObject.put("m", (Object)string2);
                    }
                    AdTrackerInitializer.getLogger().logEvent(new EventLog(AdTrackerEventType.GOAL_FAILURE, jSONObject));
                    return;
                }
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-[AdTracker]-4.1.1", "Error reporting metric", exception);
                return;
            }
            {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("g", (Object)goal.getGoalName());
                jSONObject.put("n", goal.getRetryCount());
                AdTrackerInitializer.getLogger().logEvent(new EventLog(AdTrackerEventType.GOAL_DUMPED, jSONObject));
            }
        }
    }

    public static boolean resetStatus() {
        if (InternalSDKUtil.getContext() == null) {
            return false;
        }
        FileOperations.setPreferences(InternalSDKUtil.getContext(), "IMAdTrackerStatusUpload", "uploadStatus", false);
        return true;
    }

    public static boolean sendBroadcastMessage(int n2) {
        try {
            Intent intent = new Intent();
            intent.setAction("action.inmobi.ADTRACKER");
            intent.putExtra("iatError", n2);
            InternalSDKUtil.getContext().sendBroadcast(intent);
            return true;
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-[AdTracker]-4.1.1", "Cant send test broadcast", exception);
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setInternalReferrer(Context var0, String var1_1) {
        if (var0 != null && var1_1 != null) ** GOTO lbl5
        try {
            Log.internal("[InMobi]-[AdTracker]-4.1.1", "Cannot set Market Referrer..Referrer NULL");
            return;
lbl5:
            // 1 sources

            if (0L == FileOperations.getLongPreferences(var0.getApplicationContext(), "IMAdTrackerStatusUpload", "t2")) {
                FileOperations.setPreferences(var0.getApplicationContext(), "IMAdTrackerStatusUpload", "t2", System.currentTimeMillis());
            }
            Log.internal("[InMobi]-[AdTracker]-4.1.1", "Saving referrer from broadcast receiver: " + var1_1);
            FileOperations.setPreferences(var0.getApplicationContext(), "IMAdTrackerStatusUpload", "referrer", var1_1);
            FileOperations.setPreferences(var0.getApplicationContext(), "IMAdTrackerStatusUpload", "rlc", "0");
            var5_2 = FileOperations.getPreferences(var0.getApplicationContext(), "IMAdTrackerStatusUpload", "appId");
            if (var5_2 == null || "".equals(var5_2.trim())) {
                Log.debug("[InMobi]-[AdTracker]-4.1.1", "Initialization incomplete. Please call InMobi initialize with a valid app Id");
                return;
            }
        }
        catch (Exception var2_3) {
            Log.internal("[InMobi]-[AdTracker]-4.1.1", "Cannot set referrer", var2_3);
            return;
        }
        {
            if (FileOperations.getBooleanPreferences(var0.getApplicationContext(), "IMAdTrackerStatusUpload", "waitForReferrer")) {
                InternalSDKUtil.setContext(var0);
                AdTrackerNetworkInterface.init();
                AdTrackerNetworkInterface.getGoalList().addGoal("download", 1, 0L, 0, true);
                AdTrackerNetworkInterface.reportToServer(var5_2);
            }
            AdTrackerNetworkInterface.notifyThread();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void setReferrerFromLogs(Context var0, String var1_1) {
        if (var0 != null && var1_1 != null) ** GOTO lbl5
        try {
            Log.internal("[InMobi]-[AdTracker]-4.1.1", "Cannot set Market Referrer from logs..Referrer NULL");
            return;
lbl5:
            // 1 sources

            if (0L == FileOperations.getLongPreferences(var0.getApplicationContext(), "IMAdTrackerStatusUpload", "t2")) {
                FileOperations.setPreferences(var0.getApplicationContext(), "IMAdTrackerStatusUpload", "t2", System.currentTimeMillis());
            }
            FileOperations.setPreferences(var0.getApplicationContext(), "IMAdTrackerStatusUpload", "referrer", var1_1);
            FileOperations.setPreferences(var0.getApplicationContext(), "IMAdTrackerStatusUpload", "rlc", "1");
            return;
        }
        catch (Exception var2_2) {
            Log.internal("[InMobi]-[AdTracker]-4.1.1", "Cannot set referrer from logs", var2_2);
            return;
        }
    }

    public static boolean updateStatus() {
        if (InternalSDKUtil.getContext() == null) {
            return false;
        }
        FileOperations.setPreferences(InternalSDKUtil.getContext(), "IMAdTrackerStatusUpload", "uploadStatus", true);
        return true;
    }
}

