/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.analytics.db;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.inmobi.commons.analytics.db.AnalyticsEvent;
import com.inmobi.commons.analytics.db.AnalyticsFunctions;
import com.inmobi.commons.analytics.util.SessionInfo;
import com.inmobi.commons.internal.Log;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class FunctionTagTransaction
extends AnalyticsFunctions {
    private Context a;
    private Intent b;
    private Bundle c;

    public FunctionTagTransaction(Context context, Intent intent, Bundle bundle) {
        this.a = context;
        this.b = intent;
        this.c = bundle;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AnalyticsEvent a() {
        block12: {
            try {
                if (SessionInfo.getSessionId(this.a) == null || this.b == null) break block12;
                AnalyticsEvent analyticsEvent = new AnalyticsEvent("pi");
                int n2 = this.b.getIntExtra("RESPONSE_CODE", 0);
                String string2 = this.b.getStringExtra("INAPP_PURCHASE_DATA");
                if (n2 == 0) {
                    block13: {
                        Exception exception;
                        AnalyticsEvent analyticsEvent2;
                        block14: {
                            AnalyticsEvent analyticsEvent3;
                            try {
                                int n3;
                                JSONObject jSONObject = new JSONObject(string2);
                                analyticsEvent.setTransactionId(jSONObject.getString("orderId"));
                                analyticsEvent.setTransactionProductId(jSONObject.getString("productId"));
                                long l2 = jSONObject.getLong("purchaseTime");
                                if (0L == l2) {
                                    l2 = System.currentTimeMillis();
                                }
                                analyticsEvent.setEventTimeStamp(l2 / 1000L);
                                int n4 = jSONObject.getInt("purchaseState");
                                int n5 = AnalyticsEvent.TRANSACTION_STATUS_GOOGLE_API_VALUES.PURCHASED.getValue() == n4 ? AnalyticsEvent.TRANSACTION_STATUS_SERVER_CODE.PURCHASED.getValue() : (AnalyticsEvent.TRANSACTION_STATUS_GOOGLE_API_VALUES.FAILED.getValue() == n4 ? AnalyticsEvent.TRANSACTION_STATUS_SERVER_CODE.FAILED.getValue() : (AnalyticsEvent.TRANSACTION_STATUS_GOOGLE_API_VALUES.REFUNDED.getValue() == n4 ? AnalyticsEvent.TRANSACTION_STATUS_SERVER_CODE.REFUNDED.getValue() : (n3 = AnalyticsEvent.TRANSACTION_STATUS_SERVER_CODE.RESTORED.getValue())));
                                analyticsEvent.setTransactionStatus(n5);
                            }
                            catch (JSONException jSONException) {
                                Log.debug("[InMobi]-[Analytics]-4.1.1", "Error sending transaction info. Transaction details invalid");
                                Log.internal("[InMobi]-[Analytics]-4.1.1", "Failed transaction", jSONException);
                                return null;
                            }
                            analyticsEvent2 = analyticsEvent3 = this.a(analyticsEvent);
                            try {
                                analyticsEvent2.setEventSessionId(SessionInfo.getSessionId(this.a));
                                analyticsEvent2.setEventSessionTimeStamp(SessionInfo.getSessionTime(this.a));
                                analyticsEvent = analyticsEvent2;
                                break block13;
                            }
                            catch (Exception exception2) {
                                break block14;
                            }
                            catch (Exception exception3) {
                                analyticsEvent2 = analyticsEvent;
                                exception = exception3;
                            }
                        }
                        Log.debug("[InMobi]-[Analytics]-4.1.1", "Error sending transaction info. Bundle details invalid");
                        Log.internal("[InMobi]-[Analytics]-4.1.1", "Failed to send extra params transaction", exception);
                        analyticsEvent = analyticsEvent2;
                    }
                    this.insertInDatabase(analyticsEvent);
                }
                return analyticsEvent;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-[Analytics]-4.1.1", "Exception in tag transaction", exception);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AnalyticsEvent a(AnalyticsEvent analyticsEvent) {
        block6: {
            ArrayList arrayList;
            try {
                if (this.c.getInt("RESPONSE_CODE") != 0) break block6;
                arrayList = this.c.getStringArrayList("DETAILS_LIST");
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-[Analytics]-4.1.1", "Failed to set purchase bundle info", exception);
                return analyticsEvent;
            }
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                JSONObject jSONObject = new JSONObject((String)arrayList.get(i2));
                String string2 = jSONObject.getString("productId");
                long l2 = jSONObject.getLong("price_amount_micros");
                String string3 = jSONObject.getString("price_currency_code");
                String string4 = jSONObject.optString("type");
                String string5 = jSONObject.optString("title");
                String string6 = jSONObject.optString("description");
                if (!string2.equals(analyticsEvent.getTransactionProductId())) continue;
                analyticsEvent.setTransactionItemCount(1);
                analyticsEvent.setTransactionItemDescription(string6);
                analyticsEvent.setTransactionItemName(string5);
                if ("inapp".equals(string4)) {
                    analyticsEvent.setTransactionItemType(AnalyticsEvent.TRANSACTION_ITEM_TYPE.INAPP.getValue());
                } else if ("subs".equals(string4)) {
                    analyticsEvent.setTransactionItemType(AnalyticsEvent.TRANSACTION_ITEM_TYPE.SUBSCRIPTION.getValue());
                }
                analyticsEvent.setTransactionItemPrice((double)l2 / 1000000.0);
                analyticsEvent.setTransactionCurrencyCode(string3);
                return analyticsEvent;
            }
        }
        return analyticsEvent;
    }

    @Override
    public AnalyticsEvent processFunction() {
        return this.a();
    }
}

