/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.analytics.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.inmobi.commons.analytics.db.AnalyticsEvent;
import com.inmobi.commons.analytics.db.AnalyticsSQLiteHelper;
import com.inmobi.commons.analytics.net.AnalyticsNetworkManager;
import com.inmobi.commons.analytics.util.AnalyticsUtils;
import com.inmobi.commons.analytics.util.SessionInfo;
import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class AnalyticsDatabaseManager {
    private static AnalyticsDatabaseManager c;
    private static final String[] d;
    private static final String[] e;
    private static final String[] f;
    private static final String[] g;
    private static final String[] h;
    private static final String[] i;
    private AnalyticsSQLiteHelper a;
    private SQLiteDatabase b;

    static {
        d = new String[]{"_id", "eventid", "type", "sid", "ts", "ssts", "am"};
        e = new String[]{"_id", "levelid", "levelname"};
        f = new String[]{"_id", "levelid", "levelname", "levelstatus", "timetaken", "attemptcount", "attempttime"};
        g = new String[]{"_id", "eventname"};
        h = new String[]{"_id", "levelid", "begintime", "totalcount", "totaltime"};
        i = new String[]{"_id", "itemName", "itemType", "itemCount", "itemDescription", "itemPrice", "currencyCode", "productId", "transactionId", "transactionStatus"};
    }

    private AnalyticsDatabaseManager() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private AnalyticsEvent a(Cursor cursor) {
        AnalyticsEvent analyticsEvent = new AnalyticsEvent(cursor.getString(2));
        analyticsEvent.setEventSessionId(cursor.getString(3));
        analyticsEvent.setEventId(cursor.getLong(0));
        analyticsEvent.setEventTimeStamp(cursor.getLong(4));
        analyticsEvent.setEventSessionTimeStamp(cursor.getLong(5));
        analyticsEvent.setEventAttributeMap(cursor.getString(6));
        long l2 = cursor.getLong(1);
        String string2 = Long.toString(l2);
        Log.debug("[InMobi]-[Analytics]-4.1.1", "IMAppDatabaseManager->" + analyticsEvent.getEventType() + "-" + l2);
        if (l2 > -1L) {
            Cursor cursor2;
            if (analyticsEvent.getEventType().equals("lb")) {
                cursor2 = this.b.query("levelbegin", e, "_id = ?", new String[]{string2}, null, null, null);
                cursor2.moveToFirst();
                analyticsEvent.setEventLevelId(cursor2.getString(1));
                analyticsEvent.setEventLevelName(cursor2.getString(2));
            } else if (analyticsEvent.getEventType().equals("le")) {
                cursor2 = this.b.query("levelend", f, "_id = ?", new String[]{string2}, null, null, null);
                cursor2.moveToFirst();
                analyticsEvent.setEventLevelId(cursor2.getString(1));
                analyticsEvent.setEventLevelName(cursor2.getString(2));
                analyticsEvent.setEventLevelStatus(cursor2.getString(3));
                analyticsEvent.setEventTimeTaken(cursor2.getString(4));
                analyticsEvent.setEventAttemptCount(cursor2.getString(5));
                analyticsEvent.setEventAttemptTime(cursor2.getString(6));
            } else if (analyticsEvent.getEventType().equals("ce")) {
                cursor2 = this.b.query("customevent", g, "_id = ?", new String[]{string2}, null, null, null);
                cursor2.moveToFirst();
                analyticsEvent.setEventCustomName(cursor2.getString(1));
            } else {
                boolean bl2 = analyticsEvent.getEventType().equals("pi");
                cursor2 = null;
                if (bl2) {
                    cursor2 = this.b.query("transactiondetail", i, "_id = ?", new String[]{string2}, null, null, null);
                    cursor2.moveToFirst();
                    analyticsEvent.setTransactionItemName(cursor2.getString(1));
                    analyticsEvent.setTransactionItemType(cursor2.getInt(2));
                    analyticsEvent.setTransactionItemCount(cursor2.getInt(3));
                    analyticsEvent.setTransactionItemDescription(cursor2.getString(4));
                    analyticsEvent.setTransactionItemPrice(cursor2.getDouble(5));
                    analyticsEvent.setTransactionCurrencyCode(cursor2.getString(6));
                    analyticsEvent.setTransactionProductId(cursor2.getString(7));
                    analyticsEvent.setTransactionId(cursor2.getString(8));
                    analyticsEvent.setTransactionStatus(cursor2.getInt(9));
                }
            }
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return analyticsEvent;
    }

    private void a() {
        this.b = this.a.getWritableDatabase();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void a(AnalyticsEvent analyticsEvent, long l2) {
        Log.debug("[InMobi]-[Analytics]-4.1.1", "IMAppDatabaseManager->insertEvents-" + analyticsEvent.getEventType());
        if (l2 < AnalyticsUtils.getMaxdbcount()) {
            ContentValues contentValues = new ContentValues();
            long l3 = -1L;
            long l4 = analyticsEvent.getEventTimeStamp();
            if (analyticsEvent.getEventType().equals("lb")) {
                ContentValues contentValues2 = new ContentValues();
                contentValues2.put("begintime", Long.valueOf(l4));
                SQLiteDatabase sQLiteDatabase = this.b;
                String[] stringArray = new String[]{analyticsEvent.getEventLevelId()};
                if (sQLiteDatabase.update("attemptdata", contentValues2, "levelid = ?", stringArray) <= 0) {
                    contentValues2.put("levelid", analyticsEvent.getEventLevelId());
                    contentValues2.put("totalcount", Integer.toString(0));
                    contentValues2.put("totaltime", Integer.toString(0));
                    this.b.insert("attemptdata", null, contentValues2);
                }
                contentValues.put("levelid", analyticsEvent.getEventLevelId());
                contentValues.put("levelname", analyticsEvent.getEventLevelName());
                l3 = this.b.insert("levelbegin", null, contentValues);
            } else if (analyticsEvent.getEventType().equals("le")) {
                String string2;
                String string3;
                String string4;
                SQLiteDatabase sQLiteDatabase = this.b;
                String[] stringArray = h;
                String[] stringArray2 = new String[]{analyticsEvent.getEventLevelId()};
                Cursor cursor = sQLiteDatabase.query("attemptdata", stringArray, "levelid = ?", stringArray2, null, null, null, "1");
                if (cursor.getCount() > 0) {
                    cursor.moveToFirst();
                    long l5 = l4 - Long.parseLong(cursor.getString(2));
                    string4 = Long.toString(l5);
                    string3 = Long.toString(l5 + Long.parseLong(cursor.getString(4)));
                    string2 = Integer.toString(1 + Integer.parseInt(cursor.getString(3)));
                    ContentValues contentValues3 = new ContentValues();
                    contentValues3.put("totalcount", string2);
                    contentValues3.put("totaltime", string3);
                    SQLiteDatabase sQLiteDatabase2 = this.b;
                    String[] stringArray3 = new String[]{analyticsEvent.getEventLevelId()};
                    sQLiteDatabase2.update("attemptdata", contentValues3, "levelid = ?", stringArray3);
                } else {
                    string3 = "0";
                    string2 = "0";
                    string4 = "0";
                }
                cursor.close();
                contentValues.put("levelid", analyticsEvent.getEventLevelId());
                contentValues.put("levelstatus", analyticsEvent.getEventLevelStatus());
                contentValues.put("levelname", analyticsEvent.getEventLevelName());
                contentValues.put("timetaken", string4);
                contentValues.put("attemptcount", string2);
                contentValues.put("attempttime", string3);
                l3 = this.b.insert("levelend", null, contentValues);
            } else if (analyticsEvent.getEventType().equals("pi")) {
                int n2;
                contentValues.put("itemName", analyticsEvent.getTransactionItemName());
                int n3 = analyticsEvent.getTransactionItemType();
                if (AnalyticsEvent.TRANSACTION_ITEM_TYPE.INVALID.getValue() != n3) {
                    contentValues.put("itemType", Integer.valueOf(n3));
                }
                if ((n2 = analyticsEvent.getTransactionItemCount()) > 0) {
                    contentValues.put("itemCount", Integer.valueOf(n2));
                }
                contentValues.put("itemDescription", analyticsEvent.getTransactionItemDescription());
                contentValues.put("itemPrice", Double.valueOf(analyticsEvent.getTransactionItemPrice()));
                contentValues.put("currencyCode", analyticsEvent.getTransactionCurrencyCode());
                contentValues.put("productId", analyticsEvent.getTransactionProductId());
                contentValues.put("transactionId", analyticsEvent.getTransactionId());
                int n4 = analyticsEvent.getTransactionStatus();
                if (AnalyticsEvent.TRANSACTION_STATUS_SERVER_CODE.INVALID.getValue() != n4) {
                    contentValues.put("transactionStatus", Integer.valueOf(n4));
                }
                l3 = this.b.insert("transactiondetail", null, contentValues);
            } else if (analyticsEvent.getEventType().equals("ce")) {
                contentValues.put("eventname", analyticsEvent.getEventCustomName());
                l3 = this.b.insert("customevent", null, contentValues);
            }
            ContentValues contentValues4 = new ContentValues();
            contentValues4.put("eventid", Long.valueOf(l3));
            contentValues4.put("type", analyticsEvent.getEventType());
            contentValues4.put("sid", analyticsEvent.getEventSessionId());
            contentValues4.put("ts", Long.valueOf(analyticsEvent.getEventTimeStamp()));
            contentValues4.put("ssts", Long.valueOf(analyticsEvent.getEventSessionTimeStamp()));
            contentValues4.put("am", analyticsEvent.getEventAttributeMap());
            this.b.insert("eventlist", null, contentValues4);
        } else {
            Log.debug("[InMobi]-[Analytics]-4.1.1", "Database full");
        }
        if (!AnalyticsUtils.getStartHandle() && AnalyticsNetworkManager.getHandler() != null) {
            AnalyticsUtils.setStartHandle(true);
            AnalyticsNetworkManager.getHandler().sendEmptyMessageDelayed(1001, AnalyticsUtils.getTimeinterval());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void a(List<Long> list) {
        Log.debug("[InMobi]-[Analytics]-4.1.1", "IMAppDatabaseManager->deleteEvents");
        Iterator<Long> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            Cursor cursor = this.b.query("eventlist", d, "_id=?", new String[]{string2}, null, null, null, "1");
            cursor.moveToFirst();
            Long l2 = cursor.getLong(1);
            String string3 = l2.toString();
            String string4 = cursor.getString(2);
            if (l2 > -1L) {
                if (string4.equals("lb")) {
                    this.b.delete("levelbegin", "_id = ?", new String[]{string3});
                } else if (string4.equals("le")) {
                    this.b.delete("levelend", "_id = ?", new String[]{string3});
                } else if (string4.equals("ce")) {
                    this.b.delete("customevent", "_id = ?", new String[]{string3});
                } else if (string4.equals("pi")) {
                    this.b.delete("transactiondetail", "_id = ?", new String[]{string3});
                }
            }
            cursor.close();
            this.b.delete("eventlist", "_id = ?", new String[]{string2});
        }
        return;
    }

    private void b() {
        this.a.close();
    }

    private List<AnalyticsEvent> c() {
        Log.debug("[InMobi]-[Analytics]-4.1.1", "IMAppDatabaseManager->getEvents");
        ArrayList<AnalyticsEvent> arrayList = new ArrayList<AnalyticsEvent>();
        if (!this.b.isOpen()) {
            android.util.Log.v((String)"[InMobi]-[Analytics]-4.1.1", (String)"IMAppDatabaseManager->getEvents()-database is not open");
            return arrayList;
        }
        Cursor cursor = this.b.query("eventlist", d, null, null, null, null, null, AnalyticsUtils.getMaxevents());
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            AnalyticsEvent analyticsEvent = this.a(cursor);
            analyticsEvent.setEventTableId(cursor.getLong(0));
            arrayList.add(analyticsEvent);
            cursor.moveToNext();
        }
        cursor.close();
        return arrayList;
    }

    public static AnalyticsDatabaseManager getInstance() {
        synchronized (AnalyticsDatabaseManager.class) {
            if (c == null) {
                c = new AnalyticsDatabaseManager();
                File file = InternalSDKUtil.getContext().getDatabasePath("appengage.db");
                if (file.isFile()) {
                    file.renameTo(InternalSDKUtil.getContext().getDatabasePath("ltvp.db"));
                    SessionInfo.updatedFromOldSDK(InternalSDKUtil.getContext());
                }
                AnalyticsDatabaseManager.c.a = new AnalyticsSQLiteHelper(InternalSDKUtil.getContext());
            }
            AnalyticsDatabaseManager analyticsDatabaseManager = c;
            return analyticsDatabaseManager;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteEvents(List<Long> list) {
        synchronized (this) {
            try {
                this.a();
                this.a(list);
                this.b();
                return;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-[Analytics]-4.1.1", "Error deleting from DB.");
                return;
            }
            finally {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AnalyticsEvent> getEvents() {
        synchronized (this) {
            List<AnalyticsEvent> list;
            try {
                this.a();
                list = this.c();
                this.b();
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-[Analytics]-4.1.1", "Error reading events from DB.");
                return new ArrayList<AnalyticsEvent>();
            }
            return list;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertEvents(AnalyticsEvent analyticsEvent) {
        synchronized (this) {
            try {
                this.a();
                this.a(analyticsEvent, this.b.compileStatement("SELECT COUNT(*) FROM eventlist").simpleQueryForLong());
                this.b();
                return;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-[Analytics]-4.1.1", "Error in inserting into DB.", exception);
                exception.printStackTrace();
                return;
            }
            finally {
            }
        }
    }
}

