/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.analytics.androidsdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.inmobi.commons.analytics.iat.impl.AdTrackerUtils;
import com.inmobi.commons.analytics.iat.impl.net.AdTrackerNetworkInterface;
import com.inmobi.commons.internal.FileOperations;
import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.Log;
import java.net.URLEncoder;

public class IMAdTrackerReceiver
extends BroadcastReceiver {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals("com.android.vending.INSTALL_REFERRER")) {
            try {
                Log.debug("[InMobi]-[AdTracker]-4.1.1", "Received INSTALL REFERRER");
                String string2 = intent.getExtras().getString("referrer");
                Log.debug("[InMobi]-[AdTracker]-4.1.1", "Referrer String: " + string2);
                FileOperations.setPreferences(context.getApplicationContext(), "IMAdTrackerStatusUpload", "rfs", 1);
                String string3 = URLEncoder.encode(string2, "utf-8");
                AdTrackerUtils.setInternalReferrer(context.getApplicationContext(), string3);
                return;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-[AdTracker]-4.1.1", "Error install receiver", exception);
                return;
            }
        } else {
            if (!intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE") || !InternalSDKUtil.checkNetworkAvailibility(context)) return;
            try {
                Log.internal("[InMobi]-[AdTracker]-4.1.1", "Received CONNECTIVITY BROADCAST");
                AdTrackerNetworkInterface.init();
                AdTrackerNetworkInterface.reportToServer(FileOperations.getPreferences(context.getApplicationContext(), "IMAdTrackerStatusUpload", "appId"));
                return;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-[AdTracker]-4.1.1", "Connectivity receiver exception", exception);
                return;
            }
        }
    }
}

