/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.ads.cache;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.inmobi.commons.ads.cache.AdData;
import com.inmobi.commons.ads.cache.AdDatabaseHelper;
import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.Log;

public class AdDatabaseManager {
    private static AdDatabaseManager c;
    private AdDatabaseHelper a;
    private SQLiteDatabase b;
    private int d = 1000;

    protected AdDatabaseManager() {
    }

    public static AdDatabaseManager getInstance() {
        synchronized (AdDatabaseManager.class) {
            if (c == null) {
                c = new AdDatabaseManager();
                AdDatabaseManager.c.a = new AdDatabaseHelper(InternalSDKUtil.getContext());
            }
            AdDatabaseManager adDatabaseManager = c;
            return adDatabaseManager;
        }
    }

    protected void close() {
        try {
            this.b.close();
            return;
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-4.1.1", "Failed to close ads db", exception);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AdData getAd(String string2) {
        synchronized (this) {
            try {
                this.open();
                Cursor cursor = this.b.rawQuery("SELECT * FROM ad WHERE appid = ? Order by timestamp Limit 1;", new String[]{string2});
                cursor.moveToFirst();
                AdData adData = new AdData();
                adData.setAdId(cursor.getLong(0));
                adData.setTimestamp(cursor.getLong(1));
                adData.setAppId(cursor.getString(2));
                adData.setContent(cursor.getString(3));
                cursor.close();
                this.b.delete("ad", "adid = " + adData.getAdId(), null);
                this.close();
                return adData;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-4.1.1", "Failed to get native ads from db", exception);
                return null;
            }
        }
    }

    protected int getDBSize() {
        try {
            this.open();
            int n2 = this.b.rawQuery("SELECT * FROM ad; ", null).getCount();
            this.close();
            return n2;
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-4.1.1", "Failed to get native ads from db", exception);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNoOfAds(String string2) {
        synchronized (this) {
            try {
                this.open();
                int n2 = this.b.rawQuery("SELECT * FROM ad WHERE appid = ?; ", new String[]{string2}).getCount();
                this.close();
                return n2;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-4.1.1", "Failed to get native ads from db", exception);
                return 0;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertAd(AdData adData) {
        synchronized (this) {
            try {
                ContentValues contentValues = new ContentValues();
                contentValues.put("timestamp", Long.valueOf(adData.getTimestamp()));
                contentValues.put("appid", adData.getAppId());
                contentValues.put("content", adData.getContent());
                contentValues.put("adtype", adData.getAdType());
                if (this.getDBSize() >= this.d) {
                    this.open();
                    Cursor cursor = this.b.rawQuery("SELECT adid FROM ad WHERE timestamp= (SELECT MIN(timestamp) FROM ad Limit 1);", null);
                    cursor.moveToFirst();
                    long l2 = cursor.getLong(0);
                    cursor.close();
                    this.b.delete("ad", "adid = " + l2, null);
                    this.close();
                }
                this.open();
                this.b.insert("ad", null, contentValues);
                this.close();
                return;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-4.1.1", "Failed to insert native ads to db", exception);
                return;
            }
            finally {
            }
        }
    }

    protected void open() {
        try {
            this.b = this.a.getWritableDatabase();
            return;
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-4.1.1", "Failed to open ads db", exception);
            return;
        }
    }

    public void setDBLimit(int n2) {
        if (n2 > 0) {
            this.d = n2;
        }
    }
}

