/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.androidsdk.impl.imai.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import com.inmobi.androidsdk.impl.imai.IMAIClickEventList;
import com.inmobi.androidsdk.impl.imai.db.ClickData;
import com.inmobi.commons.db.ColumnData;
import com.inmobi.commons.db.DatabaseHandler;
import com.inmobi.commons.db.TableData;
import com.inmobi.commons.internal.InternalSDKUtil;
import com.inmobi.commons.internal.Log;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class ClickDatabaseManager
extends DatabaseHandler {
    public static final String COLUMN_CLICK_ID = "clickid";
    public static final String COLUMN_CLICK_URL = "clickurl";
    public static final String COLUMN_FOLLOW_REDIRECT = "followredirect";
    public static final String COLUMN_PINGWV = "pingwv";
    public static final String COLUMN_RETRY_COUNT = "retrycount";
    public static final String COLUMN_TIMESTAMP = "timestamp";
    public static final String TABLE_CLICK = "clickevent";
    private static ClickDatabaseManager a;
    private int b = 1000;

    protected ClickDatabaseManager(Context context, ArrayList<TableData> arrayList) {
        super(context, arrayList);
    }

    private static TableData a() {
        TableData tableData = new TableData();
        LinkedHashMap<String, ColumnData> linkedHashMap = new LinkedHashMap<String, ColumnData>();
        ColumnData columnData = new ColumnData();
        columnData.setPrimaryKey(true);
        columnData.setDataType(ColumnData.ColumnType.INTEGER);
        columnData.setMandatory(true);
        linkedHashMap.put(COLUMN_CLICK_ID, columnData);
        ColumnData columnData2 = new ColumnData();
        columnData2.setDataType(ColumnData.ColumnType.VARCHAR);
        columnData2.setMandatory(true);
        linkedHashMap.put(COLUMN_CLICK_URL, columnData2);
        ColumnData columnData3 = new ColumnData();
        columnData3.setDataType(ColumnData.ColumnType.INTEGER);
        columnData3.setMandatory(true);
        linkedHashMap.put(COLUMN_PINGWV, columnData3);
        ColumnData columnData4 = new ColumnData();
        columnData4.setDataType(ColumnData.ColumnType.INTEGER);
        columnData4.setMandatory(true);
        linkedHashMap.put(COLUMN_FOLLOW_REDIRECT, columnData4);
        ColumnData columnData5 = new ColumnData();
        columnData5.setDataType(ColumnData.ColumnType.INTEGER);
        columnData5.setMandatory(true);
        linkedHashMap.put(COLUMN_RETRY_COUNT, columnData5);
        ColumnData columnData6 = new ColumnData();
        columnData6.setDataType(ColumnData.ColumnType.INTEGER);
        columnData6.setMandatory(true);
        linkedHashMap.put(COLUMN_TIMESTAMP, columnData6);
        tableData.setmColumns(linkedHashMap);
        tableData.setmTableName(TABLE_CLICK);
        return tableData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClickDatabaseManager getInstance() {
        synchronized (ClickDatabaseManager.class) {
            try {
                if (a != null) return a;
                ArrayList<TableData> arrayList = new ArrayList<TableData>();
                arrayList.add(ClickDatabaseManager.a());
                a = new ClickDatabaseManager(InternalSDKUtil.getContext(), arrayList);
                return a;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-[Network]-4.1.1", "Exception getting DB Manager Instance", exception);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteClickEvents(ArrayList<Long> arrayList) {
        synchronized (this) {
            if (arrayList == null) return false;
            try {
                if (arrayList.isEmpty()) return false;
                this.open();
                for (long l2 : arrayList) {
                    this.delete(TABLE_CLICK, "clickid = " + l2, null);
                }
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-[Network]-4.1.1", "Exception deleting click events", exception);
                return false;
            }
            {
                this.close();
                return true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMAIClickEventList getClickEvents(int n2) {
        synchronized (this) {
            IMAIClickEventList iMAIClickEventList = new IMAIClickEventList();
            try {
                this.open();
                Cursor cursor = this.getNRows(TABLE_CLICK, COLUMN_TIMESTAMP, n2);
                cursor.moveToFirst();
                do {
                    ClickData clickData = new ClickData();
                    clickData.setClickId(cursor.getLong(0));
                    clickData.setClickUrl(cursor.getString(1));
                    if (1 == cursor.getInt(2)) {
                        clickData.setPingWv(true);
                    } else {
                        clickData.setPingWv(false);
                    }
                    if (1 == cursor.getInt(3)) {
                        clickData.setFollowRedirect(true);
                    } else {
                        clickData.setFollowRedirect(false);
                    }
                    clickData.setRetryCount(cursor.getInt(4));
                    clickData.setTimestamp(cursor.getLong(5));
                    iMAIClickEventList.add(clickData);
                } while (cursor.moveToNext());
                cursor.close();
                this.close();
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-4.1.1", "Failed to get clicks from db", exception);
            }
            return iMAIClickEventList;
        }
    }

    public int getNoOfEvents() {
        try {
            this.open();
            int n2 = ClickDatabaseManager.getInstance().getNoOfRows(TABLE_CLICK, null, null);
            this.close();
            return n2;
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-[Network]-4.1.1", "Exception getting no of click events", exception);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertClick(ClickData clickData) {
        synchronized (this) {
            try {
                this.open();
                ContentValues contentValues = new ContentValues();
                contentValues.put(COLUMN_TIMESTAMP, Long.valueOf(clickData.getTimestamp()));
                contentValues.put(COLUMN_CLICK_URL, clickData.getClickUrl());
                contentValues.put(COLUMN_PINGWV, Boolean.valueOf(clickData.isPingWv()));
                contentValues.put(COLUMN_RETRY_COUNT, Integer.valueOf(clickData.getRetryCount()));
                contentValues.put(COLUMN_FOLLOW_REDIRECT, Boolean.valueOf(clickData.isFollowRedirects()));
                if (this.getTableSize(TABLE_CLICK) >= this.b) {
                    Cursor cursor = this.executeQuery("SELECT clickid FROM clickevent WHERE timestamp= (SELECT MIN(timestamp) FROM clickevent Limit 1);", null);
                    cursor.moveToFirst();
                    long l2 = cursor.getLong(0);
                    cursor.close();
                    this.delete(TABLE_CLICK, "clickid = " + l2, null);
                }
                this.insert(TABLE_CLICK, contentValues);
                this.close();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Log.internal("[InMobi]-4.1.1", "Failed to insert click event to db", exception);
                return;
            }
            finally {
            }
        }
    }

    public void setDBLimit(int n2) {
        if (n2 > 0) {
            this.b = n2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateRetryCount(ArrayList<ClickData> arrayList) {
        synchronized (this) {
            if (arrayList == null) return false;
            try {
                if (arrayList.isEmpty()) return false;
                this.open();
                for (ClickData clickData : arrayList) {
                    ContentValues contentValues = new ContentValues();
                    contentValues.put(COLUMN_CLICK_ID, Long.valueOf(clickData.getClickId()));
                    contentValues.put(COLUMN_CLICK_URL, clickData.getClickUrl());
                    contentValues.put(COLUMN_FOLLOW_REDIRECT, Boolean.valueOf(clickData.isFollowRedirects()));
                    contentValues.put(COLUMN_PINGWV, Boolean.valueOf(clickData.isPingWv()));
                    contentValues.put(COLUMN_RETRY_COUNT, Integer.valueOf(1 + clickData.getRetryCount()));
                    contentValues.put(COLUMN_TIMESTAMP, Long.valueOf(clickData.getTimestamp()));
                    String[] stringArray = new String[]{String.valueOf(clickData.getClickId())};
                    this.update(TABLE_CLICK, contentValues, "clickid= ?", stringArray);
                }
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-[Network]-4.1.1", "Exception updating retry count", exception);
                return false;
            }
            {
                this.close();
                return true;
            }
        }
    }
}

