/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.androidsdk.impl.imai;

import android.os.Build;
import android.webkit.JavascriptInterface;
import com.inmobi.androidsdk.impl.imai.IMAICore;
import com.inmobi.commons.InMobi;
import com.inmobi.commons.internal.ApiStatCollector;
import com.inmobi.commons.internal.Log;
import com.inmobi.commons.metric.EventLog;
import com.inmobi.re.container.IMWebView;
import java.lang.ref.WeakReference;

public class IMAIController {
    public static final String IMAI_BRIDGE = "imaiController";
    private transient WeakReference<IMWebView> a;

    public IMAIController(IMWebView iMWebView) {
        IMAICore.initialize();
        this.a = new WeakReference<IMWebView>(iMWebView);
    }

    @JavascriptInterface
    public String getPlatformVersion() {
        Log.debug("[InMobi]-[Network]-4.1.1", "get platform version");
        return Integer.toString(Build.VERSION.SDK_INT);
    }

    @JavascriptInterface
    public String getSdkVersion() {
        Log.debug("[InMobi]-[Network]-4.1.1", "get sdk version");
        return InMobi.getVersion();
    }

    @JavascriptInterface
    public void log(String string2) {
        Log.debug("[InMobi]-[Network]-4.1.1", string2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JavascriptInterface
    public void openEmbedded(String string2) {
        ApiStatCollector.getLogger().logEvent(new EventLog(new ApiStatCollector.ApiEventType(1001), null));
        try {
            Log.debug("[InMobi]-[Network]-4.1.1", "IMAI open Embedded");
            if (!IMAICore.validateURL(string2)) {
                IMAICore.fireErrorEvent(this.a, "Null url passed", "openEmbedded", string2);
                return;
            }
            if (string2.startsWith("http") || string2.startsWith("https")) {
                IMAICore.launchEmbeddedBrowser(this.a, string2);
                IMAICore.fireOpenEmbeddedSuccessful(this.a, string2);
                return;
            }
        }
        catch (Exception exception) {
            IMAICore.fireErrorEvent(this.a, exception.getMessage(), "openEmbedded", string2);
            Log.internal("[InMobi]-[Network]-4.1.1", "IMAI openEmbedded failed", exception);
            return;
        }
        {
            this.openExternal(string2);
            return;
        }
    }

    @JavascriptInterface
    public void openExternal(String string2) {
        ApiStatCollector.getLogger().logEvent(new EventLog(new ApiStatCollector.ApiEventType(1002), null));
        try {
            Log.debug("[InMobi]-[Network]-4.1.1", "IMAI open external");
            if (!IMAICore.validateURL(string2)) {
                IMAICore.fireErrorEvent(this.a, "Null url passed", "openExternal", string2);
                return;
            }
            IMAICore.launchExternalApp(string2);
            IMAICore.fireOpenExternalSuccessful(this.a, string2);
            return;
        }
        catch (Exception exception) {
            IMAICore.fireErrorEvent(this.a, exception.getMessage(), "openExternal", string2);
            Log.internal("[InMobi]-[Network]-4.1.1", "IMAI openExternal failed", exception);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JavascriptInterface
    public void ping(String string2, boolean bl2) {
        ApiStatCollector.getLogger().logEvent(new EventLog(new ApiStatCollector.ApiEventType(1003), null));
        try {
            Log.debug("[InMobi]-[Network]-4.1.1", "IMAI ping");
            if (!IMAICore.validateURL(string2)) {
                IMAICore.fireErrorEvent(this.a, "Null url passed", "ping", string2);
                return;
            }
            if (string2.contains("http") || string2.contains("https")) {
                IMAICore.ping(this.a, string2, bl2);
                return;
            }
        }
        catch (Exception exception) {
            IMAICore.fireErrorEvent(this.a, exception.getMessage(), "ping", string2);
            Log.internal("[InMobi]-[Network]-4.1.1", "IMAI ping failed", exception);
            return;
        }
        {
            IMAICore.fireErrorEvent(this.a, "Invalid url passed", "ping", string2);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JavascriptInterface
    public void pingInWebView(String string2, boolean bl2) {
        ApiStatCollector.getLogger().logEvent(new EventLog(new ApiStatCollector.ApiEventType(1004), null));
        try {
            Log.debug("[InMobi]-[Network]-4.1.1", "IMAI ping in webview");
            if (!IMAICore.validateURL(string2)) {
                IMAICore.fireErrorEvent(this.a, "Null url passed", "pingInWebView", string2);
                return;
            }
            if (string2.contains("http") || string2.contains("https")) {
                IMAICore.pingInWebview(this.a, string2, bl2);
                return;
            }
        }
        catch (Exception exception) {
            IMAICore.fireErrorEvent(this.a, exception.getMessage(), "pingInWebView", string2);
            Log.internal("[InMobi]-[Network]-4.1.1", "IMAI pingInWebView failed", exception);
            return;
        }
        {
            IMAICore.fireErrorEvent(this.a, "Invalid url passed", "pingInWebView", string2);
            return;
        }
    }
}

