/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.androidsdk.impl.imai;

import com.inmobi.androidsdk.bootstrapper.Initializer;
import com.inmobi.androidsdk.impl.imai.db.ClickData;
import com.inmobi.androidsdk.impl.imai.db.ClickDatabaseManager;
import com.inmobi.androidsdk.impl.net.RequestResponseManager;
import com.inmobi.commons.internal.Log;
import java.util.ArrayList;
import java.util.Iterator;

public class IMAIClickEventList
extends ArrayList<ClickData> {
    private static final long serialVersionUID = -211778664111073467L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IMAIClickEventList getLoggedClickEvents() {
        synchronized (IMAIClickEventList.class) {
            int n2 = ClickDatabaseManager.getInstance().getNoOfEvents();
            IMAIClickEventList iMAIClickEventList = null;
            if (n2 != 0) {
                int n3 = Initializer.getConfigParams().getImai().getmDefaultEventsBatch();
                ClickDatabaseManager.getInstance().setDBLimit(Initializer.getConfigParams().getImai().getmMaxDb());
                IMAIClickEventList iMAIClickEventList2 = ClickDatabaseManager.getInstance().getClickEvents(n3);
                ArrayList<Long> arrayList = new ArrayList<Long>();
                Iterator iterator = iMAIClickEventList2.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(((ClickData)iterator.next()).getClickId());
                }
                ClickDatabaseManager.getInstance().deleteClickEvents(arrayList);
                iMAIClickEventList = iMAIClickEventList2;
            }
            if (iMAIClickEventList != null) return iMAIClickEventList;
            return new IMAIClickEventList();
        }
    }

    public ClickData getClickEvent(long l2) {
        try {
            for (ClickData clickData : this) {
                long l3 = clickData.getClickId();
                if (l3 != l2) continue;
                return clickData;
            }
        }
        catch (Exception exception) {
            Log.internal("[InMobi]-[Network]-4.1.1", "Cant get click event", exception);
            return null;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reduceRetryCount(int n2) {
        synchronized (this) {
            try {
                RequestResponseManager.isSynced.set(false);
                ClickData clickData = this.getClickEvent(n2);
                int n3 = clickData.getRetryCount();
                this.removeClickEvent(n2);
                if (n3 > 1) {
                    clickData.setRetryCount(-1 + clickData.getRetryCount());
                    this.add(clickData);
                }
                return;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-[Network]-4.1.1", "Cant reduce retry count", exception);
                return;
            }
            finally {
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeClickEvent(long l2) {
        synchronized (this) {
            try {
                RequestResponseManager.isSynced.set(false);
                this.remove(this.getClickEvent(l2));
                return true;
            }
            catch (Exception exception) {
                Log.internal("[InMobi]-[Network]-4.1.1", "Cant remove click event", exception);
                return false;
            }
        }
    }

    public void saveClickEvents() {
        Log.internal("[InMobi]-[Network]-4.1.1", "Save ping events");
        if (RequestResponseManager.mDBWriterQueue != null && !RequestResponseManager.mDBWriterQueue.isEmpty()) {
            for (ClickData clickData : RequestResponseManager.mDBWriterQueue) {
                ClickDatabaseManager.getInstance().insertClick(clickData);
            }
        }
    }
}

