/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.reflect;

import com.google.gson.internal.$Gson$Preconditions;
import com.google.gson.internal.$Gson$Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class TypeToken<T> {
    final int hashCode;
    final Class<? super T> rawType;
    final Type type;

    protected TypeToken() {
        this.type = TypeToken.getSuperclassTypeParameter(this.getClass());
        this.rawType = $Gson$Types.getRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    TypeToken(Type type) {
        this.type = $Gson$Types.canonicalize($Gson$Preconditions.checkNotNull(type));
        this.rawType = $Gson$Types.getRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    private static AssertionError buildUnexpectedTypeError(Type type, Class<?> ... classArray) {
        StringBuilder stringBuilder = new StringBuilder("Unexpected type. Expected one of: ");
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(classArray[i2].getName()).append(", ");
        }
        stringBuilder.append("but got: ").append(type.getClass().getName()).append(", for type token: ").append(type.toString()).append('.');
        return new AssertionError((Object)stringBuilder.toString());
    }

    public static <T> TypeToken<T> get(Class<T> clazz) {
        return new TypeToken<T>(clazz);
    }

    public static TypeToken<?> get(Type type) {
        return new TypeToken(type);
    }

    static Type getSuperclassTypeParameter(Class<?> clazz) {
        Type type = clazz.getGenericSuperclass();
        if (type instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        return $Gson$Types.canonicalize(((ParameterizedType)type).getActualTypeArguments()[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isAssignableFrom(Type type, GenericArrayType genericArrayType) {
        Type type2 = genericArrayType.getGenericComponentType();
        if (!(type2 instanceof ParameterizedType)) return true;
        Type type3 = type;
        if (type instanceof GenericArrayType) {
            type3 = ((GenericArrayType)type).getGenericComponentType();
            return TypeToken.isAssignableFrom(type3, (ParameterizedType)type2, new HashMap<String, Type>());
        }
        if (!(type instanceof Class)) return TypeToken.isAssignableFrom(type3, (ParameterizedType)type2, new HashMap<String, Type>());
        Class<?> clazz = (Class<?>)type;
        while (true) {
            if (!clazz.isArray()) {
                type3 = clazz;
                return TypeToken.isAssignableFrom(type3, (ParameterizedType)type2, new HashMap<String, Type>());
            }
            clazz = clazz.getComponentType();
        }
    }

    private static boolean isAssignableFrom(Type type, ParameterizedType parameterizedType, Map<String, Type> map) {
        if (type == null) {
            return false;
        }
        if (parameterizedType.equals(type)) {
            return true;
        }
        Class<?> clazz = $Gson$Types.getRawType(type);
        boolean bl2 = type instanceof ParameterizedType;
        ParameterizedType parameterizedType2 = null;
        if (bl2) {
            parameterizedType2 = (ParameterizedType)type;
        }
        if (parameterizedType2 != null) {
            Type[] typeArray = parameterizedType2.getActualTypeArguments();
            TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
            for (int i2 = 0; i2 < typeArray.length; ++i2) {
                Type type2 = typeArray[i2];
                TypeVariable<Class<?>> typeVariable = typeVariableArray[i2];
                while (type2 instanceof TypeVariable) {
                    type2 = map.get(((TypeVariable)type2).getName());
                }
                map.put(typeVariable.getName(), type2);
            }
            if (TypeToken.typeEquals(parameterizedType2, parameterizedType, map)) {
                return true;
            }
        }
        Type[] typeArray = clazz.getGenericInterfaces();
        int n2 = typeArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            if (!TypeToken.isAssignableFrom(typeArray[i3], parameterizedType, new HashMap<String, Type>(map))) continue;
            return true;
        }
        return TypeToken.isAssignableFrom(clazz.getGenericSuperclass(), parameterizedType, new HashMap<String, Type>(map));
    }

    private static boolean matches(Type type, Type type2, Map<String, Type> map) {
        return type2.equals(type) || type instanceof TypeVariable && type2.equals(map.get(((TypeVariable)type).getName()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean typeEquals(ParameterizedType parameterizedType, ParameterizedType parameterizedType2, Map<String, Type> map) {
        if (!parameterizedType.getRawType().equals(parameterizedType2.getRawType())) return false;
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        Type[] typeArray2 = parameterizedType2.getActualTypeArguments();
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            if (TypeToken.matches(typeArray[i2], typeArray2[i2], map)) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object object) {
        return object instanceof TypeToken && $Gson$Types.equals(this.type, ((TypeToken)object).type);
    }

    public final Class<? super T> getRawType() {
        return this.rawType;
    }

    public final Type getType() {
        return this.type;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    @Deprecated
    public boolean isAssignableFrom(TypeToken<?> typeToken) {
        return this.isAssignableFrom(typeToken.getType());
    }

    @Deprecated
    public boolean isAssignableFrom(Class<?> clazz) {
        return this.isAssignableFrom((Type)clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public boolean isAssignableFrom(Type type) {
        if (type == null) {
            return false;
        }
        if (this.type.equals(type)) {
            return true;
        }
        if (this.type instanceof Class) {
            return this.rawType.isAssignableFrom($Gson$Types.getRawType(type));
        }
        if (this.type instanceof ParameterizedType) {
            return TypeToken.isAssignableFrom(type, (ParameterizedType)this.type, new HashMap<String, Type>());
        }
        if (!(this.type instanceof GenericArrayType)) throw TypeToken.buildUnexpectedTypeError(this.type, Class.class, ParameterizedType.class, GenericArrayType.class);
        if (!this.rawType.isAssignableFrom($Gson$Types.getRawType(type))) return false;
        if (!TypeToken.isAssignableFrom(type, (GenericArrayType)this.type)) return false;
        return true;
    }

    public final String toString() {
        return $Gson$Types.typeToString(this.type);
    }
}

