/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class LinkedTreeMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final Comparator<Comparable> NATURAL_ORDER;
    Comparator<? super K> comparator;
    private EntrySet entrySet;
    final Node<K, V> header = new Node();
    private KeySet keySet;
    int modCount = 0;
    Node<K, V> root;
    int size = 0;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl2 = !LinkedTreeMap.class.desiredAssertionStatus();
        $assertionsDisabled = bl2;
        NATURAL_ORDER = new Comparator<Comparable>(){

            @Override
            public int compare(Comparable comparable, Comparable comparable2) {
                return comparable.compareTo(comparable2);
            }
        };
    }

    public LinkedTreeMap() {
        this(NATURAL_ORDER);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public LinkedTreeMap(Comparator<? super K> comparator) {
        void var1_2;
        if (comparator == null) {
            Comparator<Comparable> comparator2 = NATURAL_ORDER;
        }
        this.comparator = var1_2;
    }

    private boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void rebalance(Node<K, V> node, boolean bl2) {
        Node<K, V> node2 = node;
        while (node2 != null) {
            Node node3;
            int n2;
            Node node4 = node2.left;
            int n3 = node4 != null ? node4.height : 0;
            int n4 = n3 - (n2 = (node3 = node2.right) != null ? node3.height : 0);
            if (n4 == -2) {
                Node node5;
                int n5;
                Node node6 = node3.left;
                int n6 = node6 != null ? node6.height : 0;
                int n7 = n6 - (n5 = (node5 = node3.right) != null ? node5.height : 0);
                if (n7 == -1 || n7 == 0 && !bl2) {
                    this.rotateLeft(node2);
                } else {
                    if (!$assertionsDisabled && n7 != 1) {
                        throw new AssertionError();
                    }
                    this.rotateRight(node3);
                    this.rotateLeft(node2);
                }
                if (bl2) {
                    return;
                }
            } else if (n4 == 2) {
                Node node7;
                int n8;
                Node node8 = node4.left;
                int n9 = node8 != null ? node8.height : 0;
                int n10 = n9 - (n8 = (node7 = node4.right) != null ? node7.height : 0);
                if (n10 == 1 || n10 == 0 && !bl2) {
                    this.rotateRight(node2);
                } else {
                    if (!$assertionsDisabled && n10 != -1) {
                        throw new AssertionError();
                    }
                    this.rotateLeft(node4);
                    this.rotateRight(node2);
                }
                if (bl2) return;
            } else if (n4 == 0) {
                node2.height = n3 + 1;
                if (bl2) {
                    return;
                }
            } else {
                if (!$assertionsDisabled && n4 != -1 && n4 != 1) {
                    throw new AssertionError();
                }
                node2.height = 1 + Math.max(n3, n2);
                if (!bl2) {
                    return;
                }
            }
            node2 = node2.parent;
        }
    }

    private void replaceInParent(Node<K, V> node, Node<K, V> node2) {
        Node node3 = node.parent;
        node.parent = null;
        if (node2 != null) {
            node2.parent = node3;
        }
        if (node3 != null) {
            if (node3.left == node) {
                node3.left = node2;
                return;
            }
            if (!$assertionsDisabled && node3.right != node) {
                throw new AssertionError();
            }
            node3.right = node2;
            return;
        }
        this.root = node2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void rotateLeft(Node<K, V> node) {
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node3.left;
        Node node5 = node3.right;
        node.right = node4;
        if (node4 != null) {
            node4.parent = node;
        }
        this.replaceInParent(node, node3);
        node3.left = node;
        node.parent = node3;
        int n2 = node2 != null ? node2.height : 0;
        int n3 = node4 != null ? node4.height : 0;
        int n4 = node.height = 1 + Math.max(n2, n3);
        int n5 = 0;
        if (node5 != null) {
            n5 = node5.height;
        }
        node3.height = 1 + Math.max(n4, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void rotateRight(Node<K, V> node) {
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node2.left;
        Node node5 = node2.right;
        node.left = node5;
        if (node5 != null) {
            node5.parent = node;
        }
        this.replaceInParent(node, node2);
        node2.right = node;
        node.parent = node2;
        int n2 = node3 != null ? node3.height : 0;
        int n3 = node5 != null ? node5.height : 0;
        int n4 = node.height = 1 + Math.max(n2, n3);
        int n5 = 0;
        if (node4 != null) {
            n5 = node4.height;
        }
        node2.height = 1 + Math.max(n4, n5);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new LinkedHashMap(this);
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
        this.modCount = 1 + this.modCount;
        Node<K, V> node = this.header;
        node.prev = node;
        node.next = node;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.findByObject(object) != null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet;
        EntrySet entrySet2 = this.entrySet;
        if (entrySet2 != null) {
            return entrySet2;
        }
        this.entrySet = entrySet = new EntrySet();
        return entrySet;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    Node<K, V> find(K k2, boolean bl2) {
        Node<K, V> node;
        block10: {
            Node<K, V> node2;
            int n2;
            Node<K, V> node3;
            block6: {
                Comparator<K> comparator = this.comparator;
                node3 = this.root;
                n2 = 0;
                boolean bl3 = true;
                while (true) {
                    Node node4;
                    block9: {
                        block8: {
                            Comparable comparable;
                            block7: {
                                if (!bl3 || (bl3 = false)) break block7;
                                if (node3 == null) break block8;
                                comparable = comparator == NATURAL_ORDER ? (Comparable)k2 : null;
                            }
                            if ((n2 = comparable != null ? comparable.compareTo(node3.key) : comparator.compare(k2, node3.key)) == 0) {
                                return node3;
                            }
                            node4 = n2 < 0 ? node3.left : node3.right;
                            if (node4 != null) break block9;
                        }
                        Node<K, V> node5 = null;
                        if (!bl2) return node5;
                        node2 = this.header;
                        if (node3 == null) {
                            if (comparator != NATURAL_ORDER || k2 instanceof Comparable) break;
                            throw new ClassCastException(k2.getClass().getName() + " is not Comparable");
                        }
                        break block6;
                    }
                    node3 = node4;
                }
                node = new Node<K, V>(node3, k2, node2, node2.prev);
                this.root = node;
                break block10;
            }
            node = new Node<K, V>(node3, k2, node2, node2.prev);
            if (n2 < 0) {
                node3.left = node;
            } else {
                node3.right = node;
            }
            this.rebalance(node3, true);
        }
        this.size = 1 + this.size;
        this.modCount = 1 + this.modCount;
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Node<K, V> findByEntry(Map.Entry<?, ?> entry) {
        Node<K, V> node = this.findByObject(entry.getKey());
        if (node == null) return null;
        if (!this.equal(node.value, entry.getValue())) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Node<K, V> findByObject(Object object) {
        Node<Object, V> node = null;
        if (object == null) return node;
        try {
            Node<Object, V> node2 = this.find(object, false);
            return node2;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    @Override
    public V get(Object object) {
        Node<K, V> node = this.findByObject(object);
        if (node != null) {
            return node.value;
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet;
        KeySet keySet2 = this.keySet;
        if (keySet2 != null) {
            return keySet2;
        }
        this.keySet = keySet = new KeySet();
        return keySet;
    }

    @Override
    public V put(K k2, V v2) {
        if (k2 == null) {
            throw new NullPointerException("key == null");
        }
        Node<K, V> node = this.find(k2, true);
        Object v3 = node.value;
        node.value = v2;
        return v3;
    }

    @Override
    public V remove(Object object) {
        Node<K, V> node = this.removeInternalByKey(object);
        if (node != null) {
            return node.value;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    void removeInternal(Node<K, V> node, boolean bl2) {
        if (bl2) {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node.parent;
        if (node2 != null && node3 != null) {
            Node node5 = node2.height > node3.height ? node2.last() : node3.first();
            this.removeInternal(node5, false);
            Node node6 = node.left;
            int n2 = 0;
            if (node6 != null) {
                n2 = node6.height;
                node5.left = node6;
                node6.parent = node5;
                node.left = null;
            }
            Node node7 = node.right;
            int n3 = 0;
            if (node7 != null) {
                n3 = node7.height;
                node5.right = node7;
                node7.parent = node5;
                node.right = null;
            }
            node5.height = 1 + Math.max(n2, n3);
            this.replaceInParent(node, node5);
            return;
        }
        if (node2 != null) {
            this.replaceInParent(node, node2);
            node.left = null;
        } else if (node3 != null) {
            this.replaceInParent(node, node3);
            node.right = null;
        } else {
            this.replaceInParent(node, null);
        }
        this.rebalance(node4, false);
        this.size = -1 + this.size;
        this.modCount = 1 + this.modCount;
    }

    Node<K, V> removeInternalByKey(Object object) {
        Node<K, V> node = this.findByObject(object);
        if (node != null) {
            this.removeInternal(node, true);
        }
        return node;
    }

    @Override
    public int size() {
        return this.size;
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public void clear() {
            LinkedTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Map.Entry && LinkedTreeMap.this.findByEntry((Map.Entry)object) != null;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new LinkedTreeMapIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    return this.nextNode();
                }
            };
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean remove(Object object) {
            Node node;
            if (!(object instanceof Map.Entry) || (node = LinkedTreeMap.this.findByEntry((Map.Entry)object)) == null) {
                return false;
            }
            LinkedTreeMap.this.removeInternal(node, true);
            return true;
        }

        @Override
        public int size() {
            return LinkedTreeMap.this.size;
        }
    }

    class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public void clear() {
            LinkedTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return LinkedTreeMap.this.containsKey(object);
        }

        @Override
        public Iterator<K> iterator() {
            return new LinkedTreeMapIterator<K>(){

                @Override
                public K next() {
                    return this.nextNode().key;
                }
            };
        }

        @Override
        public boolean remove(Object object) {
            return LinkedTreeMap.this.removeInternalByKey(object) != null;
        }

        @Override
        public int size() {
            return LinkedTreeMap.this.size;
        }
    }

    private abstract class LinkedTreeMapIterator<T>
    implements Iterator<T> {
        int expectedModCount;
        Node<K, V> lastReturned;
        Node<K, V> next;

        private LinkedTreeMapIterator() {
            this.next = LinkedTreeMap.this.header.next;
            this.lastReturned = null;
            this.expectedModCount = LinkedTreeMap.this.modCount;
        }

        @Override
        public final boolean hasNext() {
            return this.next != LinkedTreeMap.this.header;
        }

        final Node<K, V> nextNode() {
            Node node = this.next;
            if (node == LinkedTreeMap.this.header) {
                throw new NoSuchElementException();
            }
            if (LinkedTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = node.next;
            this.lastReturned = node;
            return node;
        }

        @Override
        public final void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            LinkedTreeMap.this.removeInternal(this.lastReturned, true);
            this.lastReturned = null;
            this.expectedModCount = LinkedTreeMap.this.modCount;
        }
    }

    static final class Node<K, V>
    implements Map.Entry<K, V> {
        int height;
        final K key;
        Node<K, V> left;
        Node<K, V> next;
        Node<K, V> parent;
        Node<K, V> prev;
        Node<K, V> right;
        V value;

        Node() {
            this.key = null;
            this.prev = this;
            this.next = this;
        }

        Node(Node<K, V> node, K k2, Node<K, V> node2, Node<K, V> node3) {
            this.parent = node;
            this.key = k2;
            this.height = 1;
            this.next = node2;
            this.prev = node3;
            node3.next = this;
            node2.prev = this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean equals(Object object) {
            boolean bl2 = object instanceof Map.Entry;
            boolean bl3 = false;
            if (!bl2) return bl3;
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null) {
                Object k2 = entry.getKey();
                bl3 = false;
                if (k2 != null) return bl3;
            } else {
                boolean bl4 = this.key.equals(entry.getKey());
                bl3 = false;
                if (!bl4) return bl3;
            }
            if (this.value == null) {
                Object v2 = entry.getValue();
                bl3 = false;
                if (v2 != null) return bl3;
                return true;
            } else {
                boolean bl5 = this.value.equals(entry.getValue());
                bl3 = false;
                if (!bl5) return bl3;
            }
            return true;
        }

        public Node<K, V> first() {
            Node<K, V> node = this;
            Node<K, V> node2 = node.left;
            while (node2 != null) {
                node = node2;
                node2 = node.left;
            }
            return node;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int hashCode() {
            int n2 = this.key == null ? 0 : this.key.hashCode();
            V v2 = this.value;
            int n3 = 0;
            if (v2 == null) {
                return n2 ^ n3;
            }
            n3 = this.value.hashCode();
            return n2 ^ n3;
        }

        public Node<K, V> last() {
            Node<K, V> node = this;
            Node<K, V> node2 = node.right;
            while (node2 != null) {
                node = node2;
                node2 = node.right;
            }
            return node;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

