/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.internal.$Gson$Preconditions;
import com.google.gson.internal.LazilyParsedNumber;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class JsonPrimitive
extends JsonElement {
    private static final Class<?>[] PRIMITIVE_TYPES;
    private Object value;

    static {
        Class[] classArray = new Class[]{Integer.TYPE, Long.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Boolean.TYPE, Character.TYPE, Integer.class, Long.class, Short.class, Float.class, Double.class, Byte.class, Boolean.class, Character.class};
        PRIMITIVE_TYPES = classArray;
    }

    public JsonPrimitive(Boolean bl2) {
        this.setValue(bl2);
    }

    public JsonPrimitive(Character c2) {
        this.setValue(c2);
    }

    public JsonPrimitive(Number number) {
        this.setValue(number);
    }

    JsonPrimitive(Object object) {
        this.setValue(object);
    }

    public JsonPrimitive(String string2) {
        this.setValue(string2);
    }

    private static boolean isIntegral(JsonPrimitive jsonPrimitive) {
        boolean bl2;
        block2: {
            block3: {
                boolean bl3 = jsonPrimitive.value instanceof Number;
                bl2 = false;
                if (!bl3) break block2;
                Number number = (Number)jsonPrimitive.value;
                if (number instanceof BigInteger || number instanceof Long || number instanceof Integer || number instanceof Short) break block3;
                boolean bl4 = number instanceof Byte;
                bl2 = false;
                if (!bl4) break block2;
            }
            bl2 = true;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isPrimitiveOrString(Object object) {
        if (!(object instanceof String)) {
            Class<?> clazz = object.getClass();
            Class<?>[] classArray = PRIMITIVE_TYPES;
            int n2 = classArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return false;
                }
                if (classArray[n3].isAssignableFrom(clazz)) break;
                ++n3;
            }
        }
        return true;
    }

    @Override
    JsonPrimitive deepCopy() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        double d2;
        if (this == object) {
            return true;
        }
        if (object == null) return false;
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JsonPrimitive jsonPrimitive = (JsonPrimitive)object;
        if (this.value == null) {
            if (jsonPrimitive.value == null) return true;
            return false;
        }
        if (JsonPrimitive.isIntegral(this) && JsonPrimitive.isIntegral(jsonPrimitive)) {
            if (this.getAsNumber().longValue() == jsonPrimitive.getAsNumber().longValue()) return true;
            return false;
        }
        if (!(this.value instanceof Number)) return this.value.equals(jsonPrimitive.value);
        if (!(jsonPrimitive.value instanceof Number)) return this.value.equals(jsonPrimitive.value);
        double d3 = this.getAsNumber().doubleValue();
        if (d3 == (d2 = jsonPrimitive.getAsNumber().doubleValue())) return true;
        boolean bl2 = Double.isNaN(d3);
        boolean bl3 = false;
        if (!bl2) return bl3;
        boolean bl4 = Double.isNaN(d2);
        bl3 = false;
        if (!bl4) return bl3;
        return true;
    }

    @Override
    public BigDecimal getAsBigDecimal() {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        return new BigDecimal(this.value.toString());
    }

    @Override
    public BigInteger getAsBigInteger() {
        if (this.value instanceof BigInteger) {
            return (BigInteger)this.value;
        }
        return new BigInteger(this.value.toString());
    }

    @Override
    public boolean getAsBoolean() {
        if (this.isBoolean()) {
            return this.getAsBooleanWrapper();
        }
        return Boolean.parseBoolean(this.getAsString());
    }

    @Override
    Boolean getAsBooleanWrapper() {
        return (Boolean)this.value;
    }

    @Override
    public byte getAsByte() {
        if (this.isNumber()) {
            return this.getAsNumber().byteValue();
        }
        return Byte.parseByte(this.getAsString());
    }

    @Override
    public char getAsCharacter() {
        return this.getAsString().charAt(0);
    }

    @Override
    public double getAsDouble() {
        if (this.isNumber()) {
            return this.getAsNumber().doubleValue();
        }
        return Double.parseDouble(this.getAsString());
    }

    @Override
    public float getAsFloat() {
        if (this.isNumber()) {
            return this.getAsNumber().floatValue();
        }
        return Float.parseFloat(this.getAsString());
    }

    @Override
    public int getAsInt() {
        if (this.isNumber()) {
            return this.getAsNumber().intValue();
        }
        return Integer.parseInt(this.getAsString());
    }

    @Override
    public long getAsLong() {
        if (this.isNumber()) {
            return this.getAsNumber().longValue();
        }
        return Long.parseLong(this.getAsString());
    }

    @Override
    public Number getAsNumber() {
        if (this.value instanceof String) {
            return new LazilyParsedNumber((String)this.value);
        }
        return (Number)this.value;
    }

    @Override
    public short getAsShort() {
        if (this.isNumber()) {
            return this.getAsNumber().shortValue();
        }
        return Short.parseShort(this.getAsString());
    }

    @Override
    public String getAsString() {
        if (this.isNumber()) {
            return this.getAsNumber().toString();
        }
        if (this.isBoolean()) {
            return this.getAsBooleanWrapper().toString();
        }
        return (String)this.value;
    }

    public int hashCode() {
        if (this.value == null) {
            return 31;
        }
        if (JsonPrimitive.isIntegral(this)) {
            long l2 = this.getAsNumber().longValue();
            return (int)(l2 ^ l2 >>> 32);
        }
        if (this.value instanceof Number) {
            long l3 = Double.doubleToLongBits(this.getAsNumber().doubleValue());
            return (int)(l3 ^ l3 >>> 32);
        }
        return this.value.hashCode();
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setValue(Object object) {
        if (object instanceof Character) {
            this.value = String.valueOf(((Character)object).charValue());
            return;
        }
        boolean bl2 = object instanceof Number || JsonPrimitive.isPrimitiveOrString(object);
        $Gson$Preconditions.checkArgument(bl2);
        this.value = object;
    }
}

