/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util.store;

import com.google.api.client.util.Beta;
import com.google.api.client.util.IOUtils;
import com.google.api.client.util.Maps;
import com.google.api.client.util.Throwables;
import com.google.api.client.util.store.AbstractDataStoreFactory;
import com.google.api.client.util.store.AbstractMemoryDataStore;
import com.google.api.client.util.store.DataStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Logger;

@Beta
public class FileDataStoreFactory
extends AbstractDataStoreFactory {
    private static final Logger LOGGER = Logger.getLogger(FileDataStoreFactory.class.getName());
    private final File dataDirectory;

    public FileDataStoreFactory(File file) throws IOException {
        File file2;
        this.dataDirectory = file2 = file.getCanonicalFile();
        if (IOUtils.isSymbolicLink(file2)) {
            throw new IOException("unable to use a symbolic link: " + file2);
        }
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("unable to create directory: " + file2);
        }
        FileDataStoreFactory.setPermissionsToOwnerOnly(file2);
    }

    static void setPermissionsToOwnerOnly(File file) throws IOException {
        try {
            block13: {
                block12: {
                    Method method;
                    Method method2;
                    Method method3;
                    block11: {
                        block10: {
                            Class[] classArray = new Class[]{Boolean.TYPE, Boolean.TYPE};
                            method3 = File.class.getMethod("setReadable", classArray);
                            Class[] classArray2 = new Class[]{Boolean.TYPE, Boolean.TYPE};
                            method2 = File.class.getMethod("setWritable", classArray2);
                            Class[] classArray3 = new Class[]{Boolean.TYPE, Boolean.TYPE};
                            method = File.class.getMethod("setExecutable", classArray3);
                            Object[] objectArray = new Object[]{false, false};
                            if (!((Boolean)method3.invoke((Object)file, objectArray)).booleanValue()) break block10;
                            Object[] objectArray2 = new Object[]{false, false};
                            if (!((Boolean)method2.invoke((Object)file, objectArray2)).booleanValue()) break block10;
                            Object[] objectArray3 = new Object[]{false, false};
                            if (((Boolean)method.invoke((Object)file, objectArray3)).booleanValue()) break block11;
                        }
                        LOGGER.warning("unable to change permissions for everybody: " + file);
                    }
                    Object[] objectArray = new Object[]{true, true};
                    if (!((Boolean)method3.invoke((Object)file, objectArray)).booleanValue()) break block12;
                    Object[] objectArray4 = new Object[]{true, true};
                    if (!((Boolean)method2.invoke((Object)file, objectArray4)).booleanValue()) break block12;
                    Object[] objectArray5 = new Object[]{true, true};
                    if (((Boolean)method.invoke((Object)file, objectArray5)).booleanValue()) break block13;
                }
                LOGGER.warning("unable to change permissions for owner: " + file);
            }
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            Throwables.propagateIfPossible(throwable, IOException.class);
            throw new RuntimeException(throwable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.warning("Unable to set permissions for " + file + ", likely because you are running a version of Java prior to 1.6");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }

    @Override
    protected <V extends Serializable> DataStore<V> createDataStore(String string2) throws IOException {
        return new FileDataStore(this, this.dataDirectory, string2);
    }

    public final File getDataDirectory() {
        return this.dataDirectory;
    }

    @Beta
    static class FileDataStore<V extends Serializable>
    extends AbstractMemoryDataStore<V> {
        private final File dataFile;

        FileDataStore(FileDataStoreFactory fileDataStoreFactory, File file, String string2) throws IOException {
            super(fileDataStoreFactory, string2);
            this.dataFile = new File(file, string2);
            if (IOUtils.isSymbolicLink(this.dataFile)) {
                throw new IOException("unable to use a symbolic link: " + this.dataFile);
            }
            if (this.dataFile.createNewFile()) {
                this.keyValueMap = Maps.newHashMap();
                this.save();
                return;
            }
            this.keyValueMap = (HashMap)IOUtils.deserialize(new FileInputStream(this.dataFile));
        }

        @Override
        public FileDataStoreFactory getDataStoreFactory() {
            return (FileDataStoreFactory)super.getDataStoreFactory();
        }

        @Override
        void save() throws IOException {
            IOUtils.serialize(this.keyValueMap, new FileOutputStream(this.dataFile));
        }
    }
}

