/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util.store;

import com.google.api.client.util.Beta;
import com.google.api.client.util.IOUtils;
import com.google.api.client.util.Lists;
import com.google.api.client.util.Maps;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.store.AbstractDataStore;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.DataStoreUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Beta
class AbstractMemoryDataStore<V extends Serializable>
extends AbstractDataStore<V> {
    HashMap<String, byte[]> keyValueMap;
    private final Lock lock = new ReentrantLock();

    protected AbstractMemoryDataStore(DataStoreFactory dataStoreFactory, String string2) {
        super(dataStoreFactory, string2);
        this.keyValueMap = Maps.newHashMap();
    }

    @Override
    public final DataStore<V> clear() throws IOException {
        this.lock.lock();
        try {
            this.keyValueMap.clear();
            this.save();
            return this;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean containsKey(String string2) throws IOException {
        if (string2 == null) {
            return false;
        }
        this.lock.lock();
        try {
            boolean bl2 = this.keyValueMap.containsKey(string2);
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean containsValue(V v2) throws IOException {
        if (v2 == null) {
            return false;
        }
        this.lock.lock();
        try {
            byte[] byArray = IOUtils.serialize(v2);
            Iterator<byte[]> iterator = this.keyValueMap.values().iterator();
            while (iterator.hasNext()) {
                boolean bl2 = Arrays.equals(byArray, iterator.next());
                if (!bl2) continue;
                this.lock.unlock();
                return true;
            }
            this.lock.unlock();
            return false;
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    @Override
    public DataStore<V> delete(String string2) throws IOException {
        if (string2 == null) {
            return this;
        }
        this.lock.lock();
        try {
            this.keyValueMap.remove(string2);
            this.save();
            return this;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final V get(String string2) throws IOException {
        if (string2 == null) {
            return null;
        }
        this.lock.lock();
        try {
            Object s2 = IOUtils.deserialize(this.keyValueMap.get(string2));
            return (V)s2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() throws IOException {
        this.lock.lock();
        try {
            boolean bl2 = this.keyValueMap.isEmpty();
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final Set<String> keySet() throws IOException {
        this.lock.lock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.keyValueMap.keySet());
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    void save() throws IOException {
    }

    @Override
    public final DataStore<V> set(String string2, V v2) throws IOException {
        Preconditions.checkNotNull(string2);
        Preconditions.checkNotNull(v2);
        this.lock.lock();
        try {
            this.keyValueMap.put(string2, IOUtils.serialize(v2));
            this.save();
            return this;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() throws IOException {
        this.lock.lock();
        try {
            int n2 = this.keyValueMap.size();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return DataStoreUtils.toString(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Collection<V> values() throws IOException {
        this.lock.lock();
        try {
            ArrayList arrayList = Lists.newArrayList();
            Iterator<byte[]> iterator = this.keyValueMap.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add(IOUtils.deserialize(iterator.next()));
            }
            List list = Collections.unmodifiableList(arrayList);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }
}

