/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util.store;

import com.google.api.client.util.Beta;
import com.google.api.client.util.Maps;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

@Beta
public abstract class AbstractDataStoreFactory
implements DataStoreFactory {
    private static final Pattern ID_PATTERN = Pattern.compile("\\w{1,30}");
    private final Map<String, DataStore<? extends Serializable>> dataStoreMap;
    private final Lock lock = new ReentrantLock();

    public AbstractDataStoreFactory() {
        this.dataStoreMap = Maps.newHashMap();
    }

    protected abstract <V extends Serializable> DataStore<V> createDataStore(String var1) throws IOException;

    @Override
    public final <V extends Serializable> DataStore<V> getDataStore(String string2) throws IOException {
        DataStore<Serializable> dataStore;
        block4: {
            boolean bl2 = ID_PATTERN.matcher(string2).matches();
            Object[] objectArray = new Object[]{string2, ID_PATTERN};
            Preconditions.checkArgument(bl2, "%s does not match pattern %s", objectArray);
            this.lock.lock();
            dataStore = this.dataStoreMap.get(string2);
            if (dataStore != null) break block4;
            dataStore = this.createDataStore(string2);
            this.dataStoreMap.put(string2, dataStore);
        }
        return dataStore;
        finally {
            this.lock.unlock();
        }
    }
}

