/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util.store;

import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import java.io.IOException;
import java.io.Serializable;

@Beta
public abstract class AbstractDataStore<V extends Serializable>
implements DataStore<V> {
    private final DataStoreFactory dataStoreFactory;
    private final String id;

    protected AbstractDataStore(DataStoreFactory dataStoreFactory, String string2) {
        this.dataStoreFactory = Preconditions.checkNotNull(dataStoreFactory);
        this.id = Preconditions.checkNotNull(string2);
    }

    @Override
    public boolean containsKey(String string2) throws IOException {
        return this.get(string2) != null;
    }

    @Override
    public boolean containsValue(V v2) throws IOException {
        return this.values().contains(v2);
    }

    @Override
    public DataStoreFactory getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.size() == 0;
    }

    @Override
    public int size() throws IOException {
        return this.keySet().size();
    }
}

