/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util.escape;

import com.google.api.client.util.escape.Escaper;
import com.google.api.client.util.escape.Platform;

public abstract class UnicodeEscaper
extends Escaper {
    private static final int DEST_PAD = 32;

    protected static int codePointAt(CharSequence charSequence, int n2, int n3) {
        if (n2 < n3) {
            int n4 = n2 + 1;
            char c2 = charSequence.charAt(n2);
            if (c2 < '\ud800' || c2 > '\udfff') {
                return c2;
            }
            if (c2 <= '\udbff') {
                if (n4 == n3) {
                    return -c2;
                }
                char c3 = charSequence.charAt(n4);
                if (Character.isLowSurrogate(c3)) {
                    return Character.toCodePoint(c2, c3);
                }
                throw new IllegalArgumentException("Expected low surrogate but got char '" + c3 + "' with value " + c3 + " at index " + n4);
            }
            throw new IllegalArgumentException("Unexpected low surrogate character '" + c2 + "' with value " + c2 + " at index " + (n4 - 1));
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    private static char[] growBuffer(char[] cArray, int n2, int n3) {
        char[] cArray2 = new char[n3];
        if (n2 > 0) {
            System.arraycopy(cArray, 0, cArray2, 0, n2);
        }
        return cArray2;
    }

    @Override
    public abstract String escape(String var1);

    protected abstract char[] escape(int var1);

    /*
     * Enabled aggressive block sorting
     */
    protected final String escapeSlow(String string2, int n2) {
        int n3 = string2.length();
        char[] cArray = Platform.charBufferFromThreadLocal();
        int n4 = 0;
        int n5 = 0;
        while (n2 < n3) {
            int n6 = UnicodeEscaper.codePointAt(string2, n2, n3);
            if (n6 < 0) {
                throw new IllegalArgumentException("Trailing high surrogate at end of input");
            }
            char[] cArray2 = this.escape(n6);
            int n7 = Character.isSupplementaryCodePoint(n6) ? 2 : 1;
            int n8 = n2 + n7;
            if (cArray2 != null) {
                int n9 = n2 - n5;
                int n10 = n4 + n9 + cArray2.length;
                if (cArray.length < n10) {
                    cArray = UnicodeEscaper.growBuffer(cArray, n4, 32 + (n10 + n3 - n2));
                }
                if (n9 > 0) {
                    string2.getChars(n5, n2, cArray, n4);
                    n4 += n9;
                }
                if (cArray2.length > 0) {
                    System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
                    n4 += cArray2.length;
                }
                n5 = n8;
            }
            n2 = this.nextEscapeIndex(string2, n8, n3);
        }
        int n11 = n3 - n5;
        if (n11 > 0) {
            int n12 = n4 + n11;
            if (cArray.length < n12) {
                cArray = UnicodeEscaper.growBuffer(cArray, n4, n12);
            }
            string2.getChars(n5, n3, cArray, n4);
            n4 = n12;
        }
        return new String(cArray, 0, n4);
    }

    protected abstract int nextEscapeIndex(CharSequence var1, int var2, int var3);
}

