/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util.escape;

import com.google.api.client.util.escape.UnicodeEscaper;

public class PercentEscaper
extends UnicodeEscaper {
    public static final String SAFECHARS_URLENCODER = "-_.*";
    public static final String SAFEPATHCHARS_URLENCODER = "-_.!~*'()@:$&,;=";
    public static final String SAFEQUERYSTRINGCHARS_URLENCODER = "-_.!~*'()@:$,;/?:";
    public static final String SAFEUSERINFOCHARS_URLENCODER = "-_.!~*'():$&,;=";
    public static final String SAFE_PLUS_RESERVED_CHARS_URLENCODER = "-_.!~*'()@:$&,;=+/?";
    private static final char[] UPPER_HEX_DIGITS;
    private static final char[] URI_ESCAPED_SPACE;
    private final boolean plusForSpace;
    private final boolean[] safeOctets;

    static {
        URI_ESCAPED_SPACE = new char[]{'+'};
        UPPER_HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    }

    public PercentEscaper(String string2, boolean bl2) {
        if (string2.matches(".*[0-9A-Za-z].*")) {
            throw new IllegalArgumentException("Alphanumeric characters are always 'safe' and should not be explicitly specified");
        }
        if (bl2 && string2.contains(" ")) {
            throw new IllegalArgumentException("plusForSpace cannot be specified when space is a 'safe' character");
        }
        if (string2.contains("%")) {
            throw new IllegalArgumentException("The '%' character cannot be specified as 'safe'");
        }
        this.plusForSpace = bl2;
        this.safeOctets = PercentEscaper.createSafeOctets(string2);
    }

    private static boolean[] createSafeOctets(String string2) {
        int n2 = 122;
        char[] cArray = string2.toCharArray();
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = Math.max(cArray[i2], n2);
        }
        boolean[] blArray = new boolean[n2 + 1];
        for (int i3 = 48; i3 <= 57; ++i3) {
            blArray[i3] = true;
        }
        for (int i4 = 65; i4 <= 90; ++i4) {
            blArray[i4] = true;
        }
        for (int i5 = 97; i5 <= 122; ++i5) {
            blArray[i5] = true;
        }
        int n4 = cArray.length;
        for (int i6 = 0; i6 < n4; ++i6) {
            blArray[cArray[i6]] = true;
        }
        return blArray;
    }

    @Override
    public String escape(String string2) {
        int n2 = string2.length();
        int n3 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n3 >= n2) break block3;
                    char c2 = string2.charAt(n3);
                    if (c2 < this.safeOctets.length && this.safeOctets[c2]) break block4;
                    string2 = this.escapeSlow(string2, n3);
                }
                return string2;
            }
            ++n3;
        }
    }

    @Override
    protected char[] escape(int n2) {
        if (n2 < this.safeOctets.length && this.safeOctets[n2]) {
            return null;
        }
        if (n2 == 32 && this.plusForSpace) {
            return URI_ESCAPED_SPACE;
        }
        if (n2 <= 127) {
            char[] cArray = new char[3];
            cArray[0] = 37;
            cArray[2] = UPPER_HEX_DIGITS[n2 & 0xF];
            cArray[1] = UPPER_HEX_DIGITS[n2 >>> 4];
            return cArray;
        }
        if (n2 <= 2047) {
            char[] cArray = new char[6];
            cArray[0] = 37;
            cArray[3] = 37;
            cArray[5] = UPPER_HEX_DIGITS[n2 & 0xF];
            int n3 = n2 >>> 4;
            cArray[4] = UPPER_HEX_DIGITS[8 | n3 & 3];
            int n4 = n3 >>> 2;
            cArray[2] = UPPER_HEX_DIGITS[n4 & 0xF];
            int n5 = n4 >>> 4;
            cArray[1] = UPPER_HEX_DIGITS[n5 | 0xC];
            return cArray;
        }
        if (n2 <= 65535) {
            char[] cArray = new char[9];
            cArray[0] = 37;
            cArray[1] = 69;
            cArray[3] = 37;
            cArray[6] = 37;
            cArray[8] = UPPER_HEX_DIGITS[n2 & 0xF];
            int n6 = n2 >>> 4;
            cArray[7] = UPPER_HEX_DIGITS[8 | n6 & 3];
            int n7 = n6 >>> 2;
            cArray[5] = UPPER_HEX_DIGITS[n7 & 0xF];
            int n8 = n7 >>> 4;
            cArray[4] = UPPER_HEX_DIGITS[8 | n8 & 3];
            int n9 = n8 >>> 2;
            cArray[2] = UPPER_HEX_DIGITS[n9];
            return cArray;
        }
        if (n2 <= 0x10FFFF) {
            char[] cArray = new char[12];
            cArray[0] = 37;
            cArray[1] = 70;
            cArray[3] = 37;
            cArray[6] = 37;
            cArray[9] = 37;
            cArray[11] = UPPER_HEX_DIGITS[n2 & 0xF];
            int n10 = n2 >>> 4;
            cArray[10] = UPPER_HEX_DIGITS[8 | n10 & 3];
            int n11 = n10 >>> 2;
            cArray[8] = UPPER_HEX_DIGITS[n11 & 0xF];
            int n12 = n11 >>> 4;
            cArray[7] = UPPER_HEX_DIGITS[8 | n12 & 3];
            int n13 = n12 >>> 2;
            cArray[5] = UPPER_HEX_DIGITS[n13 & 0xF];
            int n14 = n13 >>> 4;
            cArray[4] = UPPER_HEX_DIGITS[8 | n14 & 3];
            int n15 = n14 >>> 2;
            cArray[2] = UPPER_HEX_DIGITS[n15 & 7];
            return cArray;
        }
        throw new IllegalArgumentException("Invalid unicode character value " + n2);
    }

    @Override
    protected int nextEscapeIndex(CharSequence charSequence, int n2, int n3) {
        char c2;
        while (n2 < n3 && (c2 = charSequence.charAt(n2)) < this.safeOctets.length && this.safeOctets[c2]) {
            ++n2;
        }
        return n2;
    }
}

