/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util.escape;

import com.google.api.client.util.escape.Escaper;
import com.google.api.client.util.escape.PercentEscaper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public final class CharEscapers {
    private static final Escaper URI_ESCAPER = new PercentEscaper("-_.*", true);
    private static final Escaper URI_PATH_ESCAPER = new PercentEscaper("-_.!~*'()@:$&,;=", false);
    private static final Escaper URI_QUERY_STRING_ESCAPER;
    private static final Escaper URI_RESERVED_ESCAPER;
    private static final Escaper URI_USERINFO_ESCAPER;

    static {
        URI_RESERVED_ESCAPER = new PercentEscaper("-_.!~*'()@:$&,;=+/?", false);
        URI_USERINFO_ESCAPER = new PercentEscaper("-_.!~*'():$&,;=", false);
        URI_QUERY_STRING_ESCAPER = new PercentEscaper("-_.!~*'()@:$,;/?:", false);
    }

    private CharEscapers() {
    }

    public static String decodeUri(String string2) {
        try {
            String string3 = URLDecoder.decode(string2, "UTF-8");
            return string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String escapeUri(String string2) {
        return URI_ESCAPER.escape(string2);
    }

    public static String escapeUriPath(String string2) {
        return URI_PATH_ESCAPER.escape(string2);
    }

    public static String escapeUriPathWithoutReserved(String string2) {
        return URI_RESERVED_ESCAPER.escape(string2);
    }

    public static String escapeUriQuery(String string2) {
        return URI_QUERY_STRING_ESCAPER.escape(string2);
    }

    public static String escapeUriUserInfo(String string2) {
        return URI_USERINFO_ESCAPER.escape(string2);
    }
}

