/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.Preconditions;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class Types {
    private Types() {
    }

    private static Type getActualParameterAtPosition(Type type, Class<?> clazz, int n2) {
        Type type2;
        Type type3 = Types.getSuperParameterizedType(type, clazz).getActualTypeArguments()[n2];
        if (type3 instanceof TypeVariable && (type2 = Types.resolveTypeVariable(Arrays.asList(type), (TypeVariable)type3)) != null) {
            return type2;
        }
        return type3;
    }

    public static Type getArrayComponentType(Type type) {
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return ((Class)type).getComponentType();
    }

    public static Type getBound(WildcardType wildcardType) {
        Type[] typeArray = wildcardType.getLowerBounds();
        if (typeArray.length != 0) {
            return typeArray[0];
        }
        return wildcardType.getUpperBounds()[0];
    }

    public static Type getIterableParameter(Type type) {
        return Types.getActualParameterAtPosition(type, Iterable.class, 0);
    }

    public static Type getMapValueParameter(Type type) {
        return Types.getActualParameterAtPosition(type, Map.class, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Class<?> getRawArrayComponentType(List<Type> list, Type type) {
        if (type instanceof TypeVariable) {
            type = Types.resolveTypeVariable(list, (TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(Types.getRawArrayComponentType(list, Types.getArrayComponentType(type)), 0).getClass();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Types.getRawClass((ParameterizedType)type);
        }
        boolean bl2 = type == null;
        Preconditions.checkArgument(bl2, "wildcard type is not supported: %s", type);
        return Object.class;
    }

    public static Class<?> getRawClass(ParameterizedType parameterizedType) {
        return (Class)parameterizedType.getRawType();
    }

    /*
     * Unable to fully structure code
     */
    public static ParameterizedType getSuperParameterizedType(Type var0, Class<?> var1_1) {
        block6: {
            if (!(var0 instanceof Class) && !(var0 instanceof ParameterizedType)) break block6;
            block0: while (var0 != null && var0 != Object.class) {
                if (var0 instanceof Class) {
                    var3_3 = (Class<?>)var0;
lbl5:
                    // 3 sources

                    while (true) {
                        var0 = var3_3.getGenericSuperclass();
                        continue block0;
                        break;
                    }
                }
                var2_2 = (ParameterizedType)var0;
                var3_3 = Types.getRawClass(var2_2);
                if (var3_3 == var1_1) {
                    return var2_2;
                }
                if (!var1_1.isInterface()) ** GOTO lbl5
                var4_4 = var3_3.getGenericInterfaces();
                var5_5 = var4_4.length;
                var6_6 = 0;
                while (true) {
                    block8: {
                        block7: {
                            if (var6_6 < var5_5) ** break;
                            ** continue;
                            var7_7 = var4_4[var6_6];
                            if (!(var7_7 instanceof Class)) break block7;
                            var8_8 = (Class<?>)var7_7;
lbl22:
                            // 2 sources

                            while (var1_1.isAssignableFrom(var8_8)) {
                                var0 = var7_7;
                                continue block0;
                            }
                            break block8;
                        }
                        var8_8 = Types.getRawClass((ParameterizedType)var7_7);
                        ** GOTO lbl22
                    }
                    ++var6_6;
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IllegalArgumentException handleExceptionForNewInstance(Exception exception, Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder("unable to create new instance of class ").append(clazz.getName());
        ArrayList<String> arrayList = new ArrayList<String>();
        if (clazz.isArray()) {
            arrayList.add("because it is an array");
        } else if (clazz.isPrimitive()) {
            arrayList.add("because it is primitive");
        } else if (clazz == Void.class) {
            arrayList.add("because it is void");
        } else {
            if (Modifier.isInterface(clazz.getModifiers())) {
                arrayList.add("because it is an interface");
            } else if (Modifier.isAbstract(clazz.getModifiers())) {
                arrayList.add("because it is abstract");
            }
            if (clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
                arrayList.add("because it is not static");
            }
            if (!Modifier.isPublic(clazz.getModifiers())) {
                arrayList.add("possibly because it is not public");
            } else {
                try {
                    clazz.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    arrayList.add("because it has no accessible default constructor");
                }
            }
        }
        boolean bl2 = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (bl2) {
                stringBuilder.append(" and");
            } else {
                bl2 = true;
            }
            stringBuilder.append(" ").append(string2);
        }
        return new IllegalArgumentException(stringBuilder.toString(), exception);
    }

    public static boolean isArray(Type type) {
        return type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray();
    }

    public static boolean isAssignableToOrFrom(Class<?> clazz, Class<?> clazz2) {
        return clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz);
    }

    public static <T> Iterable<T> iterableOf(final Object object) {
        if (object instanceof Iterable) {
            return (Iterable)object;
        }
        Class<?> clazz = object.getClass();
        Preconditions.checkArgument(clazz.isArray(), "not an array or Iterable: %s", clazz);
        if (!clazz.getComponentType().isPrimitive()) {
            return Arrays.asList((Object[])object);
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int index;
                    final int length;
                    {
                        this.length = Array.getLength(object);
                        this.index = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < this.length;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Object object = object;
                        int n2 = this.index;
                        this.index = n2 + 1;
                        return Array.get(object, n2);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> T newInstance(Class<T> clazz) {
        T t2;
        try {
            t2 = clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Types.handleExceptionForNewInstance(illegalAccessException, clazz);
        }
        catch (InstantiationException instantiationException) {
            throw Types.handleExceptionForNewInstance(instantiationException, clazz);
        }
        return t2;
    }

    public static Type resolveTypeVariable(List<Type> list, TypeVariable<?> typeVariable) {
        Object obj = typeVariable.getGenericDeclaration();
        if (obj instanceof Class) {
            Class clazz = (Class)obj;
            int n2 = list.size();
            ParameterizedType parameterizedType = null;
            while (parameterizedType == null && --n2 >= 0) {
                parameterizedType = Types.getSuperParameterizedType(list.get(n2), clazz);
            }
            if (parameterizedType != null) {
                Type type;
                TypeVariable<?>[] typeVariableArray = obj.getTypeParameters();
                int n3 = 0;
                while (true) {
                    if (n3 >= typeVariableArray.length || typeVariableArray[n3].equals(typeVariable)) {
                        Type type2;
                        type = parameterizedType.getActualTypeArguments()[n3];
                        if (!(type instanceof TypeVariable) || (type2 = Types.resolveTypeVariable(list, (TypeVariable)type)) == null) break;
                        return type2;
                    }
                    ++n3;
                }
                return type;
            }
        }
        return null;
    }

    public static Object toArray(Collection<?> collection, Class<?> clazz) {
        Object[] objectArray;
        if (clazz.isPrimitive()) {
            objectArray = Array.newInstance(clazz, collection.size());
            int n2 = 0;
            for (Object obj : collection) {
                int n3 = n2 + 1;
                Array.set(objectArray, n2, obj);
                n2 = n3;
            }
        } else {
            objectArray = collection.toArray((Object[])Array.newInstance(clazz, collection.size()));
        }
        return objectArray;
    }
}

